/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.helpers;

import com.gridnine.hotels.web.ws.HotelOffer;
import com.gridnine.hotels.web.ws.HotelsOption;
import com.gridnine.hotels.web.ws.HotelsVatComponent;
import com.gridnine.hotels.web.ws.PricedItem;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;

public class VatHelper {
    private static final Set<String> localCurrency = new HashSet<String>();

    public static Boolean isVatIncluded(PricedItem item) {
        if (VatHelper.ignoreVat(item)) {
            return Boolean.FALSE;
        }
        Boolean result = item.isVat();
        if (result == null) {
            result = VatHelper.isVatIncluded(item.getVatComponent());
        }
        return result;
    }

    public static Boolean isVatIncluded(HotelOffer wsOffer) {
        Boolean result;
        result = VatHelper.ignoreVat(wsOffer) ? Boolean.FALSE : ((result = wsOffer.isVat()) == null ? VatHelper.isVatIncluded(wsOffer.getVatComponent()) : result);
        return result;
    }

    public static Boolean isVatIncluded(HotelsOption wsOption) {
        if (wsOption.getPrice() == null || VatHelper.ignoreVat(wsOption.getPrice().getCurrency())) {
            return Boolean.FALSE;
        }
        return VatHelper.isVatIncluded(wsOption.getVatComponent());
    }

    private static boolean ignoreVat(PricedItem item) {
        return VatHelper.ignoreVat(HotelsReservationHelper.getCurrency(item));
    }

    private static boolean ignoreVat(String currencyCode) {
        return !VatHelper.isLocal(currencyCode);
    }

    private static String getCurrency(HotelOffer wsOffer) {
        String result = wsOffer.getBasePrice().getCurrencyCode();
        if (result == null) {
            throw Xeption.forDeveloper((String)"currency is undefined in the {0} object", (Object[])new Object[]{wsOffer.getClass().getName()});
        }
        return result;
    }

    private static boolean ignoreVat(HotelOffer wsOffer) {
        if (wsOffer.isPriceByRequest()) {
            return false;
        }
        return VatHelper.ignoreVat(VatHelper.getCurrency(wsOffer));
    }

    private static boolean isLocal(String currency) {
        return localCurrency.contains(currency.toLowerCase());
    }

    private static Boolean isVatIncluded(HotelsVatComponent vatComponent) {
        if (vatComponent == null || BooleanUtils.isTrue((Boolean)vatComponent.isUnknown())) {
            return null;
        }
        if (vatComponent.isIncluded() != null) {
            return vatComponent.isIncluded();
        }
        return vatComponent.isApplicable();
    }

    public static BigDecimal getVatAmount(BigDecimal totalPrice, HotelsVatComponent vatComponent, BigDecimal oldVatAmount) {
        if (vatComponent != null) {
            if (vatComponent.getAmount() != null) {
                return vatComponent.getAmount();
            }
            if (vatComponent.getPercent() != null) {
                return VatHelper.calcVatAmount(totalPrice, vatComponent.getPercent().doubleValue());
            }
        }
        return oldVatAmount;
    }

    public static Double getVatRate(BigDecimal totalPrice, HotelsVatComponent vatComponent, BigDecimal oldVatAmount) {
        if (vatComponent != null) {
            if (vatComponent.getPercent() != null) {
                return vatComponent.getPercent().doubleValue();
            }
            if (vatComponent.getAmount() != null) {
                return VatHelper.calcVatRate(totalPrice, vatComponent.getAmount());
            }
        }
        return oldVatAmount != null ? VatHelper.calcVatRate(totalPrice, oldVatAmount) : null;
    }

    public static Double calcVatRate(BigDecimal totalPrice, BigDecimal vatAmount) {
        VatAmount va = VatAmount.of((BigDecimal)totalPrice, (BigDecimal)vatAmount);
        return va.getVat();
    }

    public static BigDecimal calcVatAmount(BigDecimal totalPrice, Double vatRate) {
        if (vatRate == null) {
            return null;
        }
        VatAmount va = VatAmount.of((BigDecimal)totalPrice, (double)vatRate);
        return va.getVatAmount();
    }

    static {
        localCurrency.add("rub");
        localCurrency.add("rur");
        String c = DictHelper.getEquivCurrency();
        if (c != null && !localCurrency.contains(c.toLowerCase())) {
            localCurrency.clear();
            localCurrency.add(c.toLowerCase());
        }
    }
}

