/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.hotelsProfile;

import com.gridnine.hotels.web.ws.ClientProfile;
import com.gridnine.hotels.web.ws.HotelVendorProfile;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.ParameterField;
import com.gridnine.hotels.web.ws.Provider;
import com.gridnine.hotels.web.ws.UpdateProfileParams;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelsProviderAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAAndAAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAcademserviceAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorData;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsBronevikAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsHotelbookAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsOstrovokAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsRCRAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsSabreAccount;
import com.gridnine.xtrip.common.hotels2.model.HotelsSusaninAccount;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;

public class UpdateClientProfileRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "updateClientProfile";

    public void process(MessageContext ctx) throws Exception {
        EntityContainer accountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_GDS_ACCOUNT);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData((EntityContainer<HotelsAggregatorGdsAccount>)accountCtr));
    }

    private HotelsAggregatorRequestData buildRequestData(EntityContainer<HotelsAggregatorGdsAccount> accountCtr) {
        HotelsAggregatorGdsAccount account = (HotelsAggregatorGdsAccount)accountCtr.getEntity();
        HotelsAggregatorData hotelsData = account.getHotelsAggregatorData();
        ClientProfile clientProfile = new ClientProfile();
        clientProfile.setUid(MiscUtil.guarded((String)hotelsData.getGdsUid()));
        clientProfile.setPcc(accountCtr.getUid());
        clientProfile.setName(hotelsData.getName());
        clientProfile.setCurrency(hotelsData.getCurrency());
        clientProfile.setLocale("ru");
        if (hotelsData.getMaxSearchTimeMs() != null) {
            clientProfile.setMaxSearchTimeMs((long)hotelsData.getMaxSearchTimeMs().intValue());
        }
        clientProfile.setIgnoreMissingHotels(hotelsData.getIgnoreMissingHotels());
        hotelsData.getVendors().forEach((provider, providerAccount) -> {
            HotelVendorProfile vendorProfile = this.buildHotelVendorProfile((HotelProvider)provider, (BaseHotelsProviderAccount)providerAccount);
            if (vendorProfile != null) {
                clientProfile.getVendors().add(vendorProfile);
            }
        });
        InvocationContext context = new InvocationContext();
        UpdateProfileParams params = new UpdateProfileParams();
        params.setClientProfile(clientProfile);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(params);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }

    private HotelVendorProfile buildHotelVendorProfile(HotelProvider provider, BaseHotelsProviderAccount providerAccount) {
        if (provider == null) {
            return null;
        }
        switch (provider) {
            case BRONEVIK: {
                return this.buildBronevikProfile((HotelsBronevikAccount)providerAccount);
            }
            case OSTROVOK: {
                return this.buildOstrovokProfile((HotelsOstrovokAccount)providerAccount);
            }
            case ACADEMSERVICE: {
                return this.buildAcademserviceProfile((HotelsAcademserviceAccount)providerAccount);
            }
            case A_AND_A: {
                return this.buildAAndAProfile((HotelsAAndAAccount)providerAccount);
            }
            case HOTELBOOK: {
                return this.buildHotelbookProfile((HotelsHotelbookAccount)providerAccount);
            }
            case SUSANIN: {
                return this.buildSusaninProfile((HotelsSusaninAccount)providerAccount);
            }
            case SABRE: {
                return this.buildSabreProfile((HotelsSabreAccount)providerAccount);
            }
            case RCR: {
                return this.buildRCRProfile((HotelsRCRAccount)providerAccount);
            }
        }
        return null;
    }

    private HotelVendorProfile buildBronevikProfile(HotelsBronevikAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.BRONEVIK);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("xmlUrl", providerAccount.getUrl()));
        fields.add(this.buildField("xmlLogin", providerAccount.getLogin()));
        fields.add(this.buildField("xmlPassword", providerAccount.getPassword()));
        fields.add(this.buildField("xmlClientKey", providerAccount.getClientKey()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        fields.add(this.buildField("useSearchHotelOffersRequest", String.valueOf(providerAccount.isUseSearchHotelOffersRequest())));
        fields.add(this.buildField("useNativeSearch", String.valueOf(providerAccount.isUseNativeSearch())));
        return result;
    }

    private HotelVendorProfile buildOstrovokProfile(HotelsOstrovokAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.OSTROVOK);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        fields.add(this.buildField("useNativeSearch", String.valueOf(providerAccount.isUseNativeSearch())));
        return result;
    }

    private HotelVendorProfile buildAcademserviceProfile(HotelsAcademserviceAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.ACADEMSERVICE);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("organizationId", providerAccount.getOrganizationId()));
        fields.add(this.buildField("inboundConnectionEnabled", String.valueOf(providerAccount.isInboundConnectionEnabled())));
        fields.add(this.buildField("inboundConnectionLogin", providerAccount.getInboundConnectionLogin()));
        fields.add(this.buildField("inboundConnectionPassword", providerAccount.getInboundConnectionPassword()));
        fields.add(this.buildField("interestedInHostels", String.valueOf(providerAccount.isSearchHostels())));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        return result;
    }

    private HotelVendorProfile buildAAndAProfile(HotelsAAndAAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.A_AND_A);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("organizationId", providerAccount.getOrganizationId()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        fields.add(this.buildField("useNativeSearch", String.valueOf(providerAccount.isUseNativeSearch())));
        return result;
    }

    private HotelVendorProfile buildHotelbookProfile(HotelsHotelbookAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.HOTELBOOK);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        return result;
    }

    private HotelVendorProfile buildSusaninProfile(HotelsSusaninAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.SUSANIN);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("userId", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        return result;
    }

    private HotelVendorProfile buildSabreProfile(HotelsSabreAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.SABRE);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("transactionExecutor", providerAccount.getTransactionExecutor()));
        fields.add(this.buildField("ipcc", providerAccount.getIpcc()));
        fields.add(this.buildField("radius", providerAccount.getSearchRadius() == null ? null : providerAccount.getSearchRadius().toString()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        return result;
    }

    private HotelVendorProfile buildRCRProfile(HotelsRCRAccount providerAccount) {
        HotelVendorProfile result = new HotelVendorProfile();
        result.setProvider(Provider.RCR);
        result.setFields(new HotelVendorProfile.Fields());
        List fields = result.getFields().getField();
        fields.add(this.buildField("name", providerAccount.getName()));
        fields.add(this.buildField("url", providerAccount.getUrl()));
        fields.add(this.buildField("login", providerAccount.getLogin()));
        fields.add(this.buildField("password", providerAccount.getPassword()));
        fields.add(this.buildField("ignoreMissingHotels", MiscUtil.toString((Object)providerAccount.getIgnoreMissingHotels())));
        return result;
    }

    private ParameterField buildField(String name, String value) {
        ParameterField result = new ParameterField();
        result.setName(name);
        result.setValue(MiscUtil.guarded((String)value));
        return result;
    }
}

