/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.importBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.LoadReservationResponse;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.hotels2.HotelsTestBase;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.importBooking.HotelReservationBuilder;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.XModelAssert;
import org.junit.Assert;
import org.junit.Test;

public class HotelReservationBuilderTest
extends HotelsTestBase {
    HotelReservationBuilder processor = new HotelReservationBuilder();

    @Test
    public void testSell1() throws Exception {
        this.testScenario("Sell1");
    }

    @Test
    public void testSell2() throws Exception {
        this.testScenario("Sell2");
    }

    @Test
    public void testRefund() throws Exception {
        this.testScenario("Refund");
    }

    private void testScenario(String scenario) throws Exception {
        String responseFile = scenario + ".xml";
        String resultFile = scenario + "_result.xml";
        LoadReservationResponse response = this.getResponseFromFile(responseFile, LoadReservationResponse.class);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE, (Object)response.getReturn());
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, this.createGdsAccount());
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)this.createSalesContext());
        this.processor.process(ctx);
        Reservation actual = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        this.checkRoomTokens(actual);
        this.clearSomeFields(actual);
        Reservation expected = new Reservation();
        this.loadXSerializable(resultFile, (XSerializable)expected);
        this.clearSomeFields(expected);
        XModelAssert.assertEntityEquals((BaseEntity)expected, (BaseEntity)actual);
    }

    private void checkRoomTokens(Reservation reservation) {
        BookingStreamHelper.getProductsStream((Reservation)reservation, HotelProduct.class).flatMap(hp -> hp.getRooms().stream()).forEach(room -> Assert.assertNull((Object)room.getToken()));
    }
}

