/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.importBooking;

import com.gridnine.bof.midoffice.ibus.BookingFileOperationParameters;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.exception.NotSaveImportedBookingException;
import com.gridnine.xtrip.common.hotels2.model.ImportHotelBookingFileParams;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.RecordLocatorType;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.system.Document;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseAdvice;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.Date;

public class HotelsExceptionHandler
extends BaseAdvice {
    public boolean handleException(Throwable e, MessageContext ctx) throws Exception {
        ImportHotelBookingFileParams params = (ImportHotelBookingFileParams)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS);
        EntityContainer bookingCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        if (e instanceof NotSaveImportedBookingException) {
            BookingFileOperationParameters parameters = new BookingFileOperationParameters();
            parameters.setSaveBookingFile(false);
            parameters.setSaveSysLog(false);
            ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_OPERATION_PARAMETERS, (Object)parameters);
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_BOOKING_FILE_SAVED, (Object)Boolean.FALSE);
            Collection docs = (Collection)ctx.getObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE_DOCUMENTS);
            if (CollectionUtil.isNotEmpty((Collection)docs)) {
                docs.stream().filter(Document.class::isInstance).map(Document.class::cast).filter(doc -> doc.getType() == DocumentType.GDS_LOG).forEach(doc -> this.enrichStackTrace(e, (Document)doc));
                docs.clear();
            }
            ctx.getMessagesReadOnly().forEach(mes -> this.enrichStackTrace(e, (Message)mes));
            ctx.clearMessages();
        } else {
            this.buildDefaultReservation((BookingFile)bookingCtr.getEntity(), params, salesContext);
        }
        return false;
    }

    private void enrichStackTrace(Throwable e, Document doc) {
        IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)doc.getName(), (String)new String(doc.getContent()))});
    }

    private void enrichStackTrace(Throwable e, Message mes) {
        IncidentsHelper.addStackTraceElement((Throwable)e, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)mes.getMessage().toString(), (String)mes.getDetails())});
    }

    private void buildDefaultReservation(BookingFile booking, ImportHotelBookingFileParams params, SalesContext salesContext) {
        if (!booking.getReservations().isEmpty()) {
            return;
        }
        Reservation reservation = new Reservation();
        reservation.setStatus(ReservationStatus.ERROR);
        reservation.getGdsNameInfo().setOnlineGdsAccount(params.getGdsAccount());
        reservation.setResDate(new Date());
        CommonReservationGdsNameInfoHelper.setRecordLocator((Reservation)reservation, (GdsName)GdsName.HOTEL_AGGREGATOR, (RecordLocatorType)RecordLocatorType.HOTEL_AGGREGATOR_PNR, (String)params.getPnr());
        SalesContextHandler.get().enforceSalesContext(salesContext, reservation);
        reservation.setBookingFile(booking);
        booking.getReservations().add(reservation);
    }
}

