/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.importBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.ImportHotelBookingFileParams;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.SearchQueryHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.List;
import java.util.stream.Collectors;

public class ImportHotelBookingFileParamsValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        ImportHotelBookingFileParams params = (ImportHotelBookingFileParams)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS);
        if (params.getProvider() == null) {
            throw Xeption.forDeveloper((String)"provider is null", (Object[])new Object[0]);
        }
        if (TextUtil.isBlank((String)params.getPnr())) {
            throw Xeption.forDeveloper((String)"pnr is null", (Object[])new Object[0]);
        }
        EntityContainer<BookingFile> bookingCtr = this.findBookingFile(params.getProvider(), params.getPnr());
        if (bookingCtr != null) {
            ctx.addMessage(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"HOTELS2_BOOKING_FILE_FOUND_IN_MOM", (Object[])new Object[]{params.getProvider(), params.getPnr(), ((BookingFile)bookingCtr.getEntity()).getNumber()}));
        }
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, bookingCtr);
    }

    private EntityContainer<BookingFile> findBookingFile(HotelProvider provider, String pnr) {
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchQueryHelper.getRecordLocatorSearchCriterionForMainHotelProductIndex((String)pnr));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)MainHotelProductIndex.Property.provider.name(), (Object)provider));
        query.getPreferredProperties().add(MainHotelProductIndex.Property.bookingNumber.name());
        List indices = EntityStorage.get().search(MainHotelProductIndex.class, query).getData();
        List bookingFileNumbers = indices.stream().map(MainHotelProductIndex::getBookingNumber).distinct().collect(Collectors.toList());
        if (bookingFileNumbers.size() > 1) {
            throw Xeption.forDeveloper((String)"Multiple BookingFiles found for provider {0}, pnr {1}: {2}", (Object[])new Object[]{provider.name(), pnr, bookingFileNumbers});
        }
        return !indices.isEmpty() ? EntityStorage.get().resolve(((MainHotelProductIndex)indices.get(0)).getSource()) : null;
    }
}

