/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.importBooking;

import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.LoadReservationQuery;
import com.gridnine.hotels.web.ws.ReservationID;
import com.gridnine.xtrip.common.hotels2.model.ImportHotelBookingFileParams;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class LoadReservationRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "loadReservation";

    public void process(MessageContext ctx) throws Exception {
        ImportHotelBookingFileParams params = (ImportHotelBookingFileParams)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(params));
    }

    private HotelsAggregatorRequestData buildRequestData(ImportHotelBookingFileParams params) {
        LoadReservationQuery wsParams = new LoadReservationQuery();
        wsParams.setProvider(HotelsBaseHelper.convertProviderToGds(params.getProvider()));
        wsParams.setDictionaryLanguages(HotelsHelper.buildDefaultDictionaryLanguages());
        ReservationID wsReservationId = new ReservationID();
        wsReservationId.setDiscover(Boolean.TRUE);
        wsReservationId.setReservationNumber(params.getPnr());
        wsParams.setReservationID(wsReservationId);
        InvocationContext context = new InvocationContext();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(wsParams);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }
}

