/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.loadReservations;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.LoadReservationsQuery;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.LoadReservationsParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class LoadReservationsRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "loadReservations";

    public void process(MessageContext ctx) throws Exception {
        LoadReservationsParameters params = (LoadReservationsParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_IMPORT_BOOKING_PARAMS);
        EntityContainer account = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(params, (HotelsAggregatorGdsAccount)account.getEntity()));
    }

    private HotelsAggregatorRequestData buildRequestData(LoadReservationsParameters params, HotelsAggregatorGdsAccount account) {
        LoadReservationsQuery query = new LoadReservationsQuery();
        query.setStartDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getStartDate(), 1));
        query.setEndDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getEndDate(), 1));
        query.setProvider(HotelsBaseHelper.convertProviderToGds(account.getProvider()));
        query.setDictionaryLanguages(this.buildDictionaryLanguages());
        InvocationContext context = new InvocationContext();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(query);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }

    private LoadReservationsQuery.DictionaryLanguages buildDictionaryLanguages() {
        LoadReservationsQuery.DictionaryLanguages result = new LoadReservationsQuery.DictionaryLanguages();
        HotelsHelper.populateDictionaryLanguages(result.getEntry());
        return result;
    }
}

