/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.midofficeRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersActions;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersProperties;
import com.gridnine.xtrip.common.hotels2.rules.HotelsTargets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import org.slf4j.LoggerFactory;

public class ApplicableGdsAccountsProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer applicableAccountCtr = (EntityContainer)ctx.getObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNT);
        if (applicableAccountCtr != null) {
            ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, Collections.singletonList(applicableAccountCtr));
            return;
        }
        SearchOffersParameters params = (SearchOffersParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(HotelsTargets.HOTEL_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        HotelsParametersProperties properties = new HotelsParametersProperties(salesContext, proxy);
        properties.setCountry(HotelsHelper.getSearchParametersCountry(params));
        proxy.setPropertySet((Object)properties);
        proxy.setActionSet((Object)new HotelsParametersActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        HashSet<EntityContainer> res = new HashSet<EntityContainer>();
        for (EntityReference ref : ((HotelsParametersActions)proxy.getActionSet()).getApplicableGdsAccounts()) {
            EntityContainer ctr = EntityStorage.get().resolve(ref);
            if (ctr == null) continue;
            res.add(ctr);
        }
        ctx.putObject((Enum)IBusGdsContextKeys.APPLICABLE_GDS_ACCOUNTS, res);
    }
}

