/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.midofficeRules;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.hotels2.rules.HotelsParametersProperties;
import com.gridnine.xtrip.common.hotels2.rules.HotelsSearchResultActions;
import com.gridnine.xtrip.common.hotels2.rules.HotelsTargets;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.rules.RuleEngine;
import com.gridnine.xtrip.common.rules.RuleSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.LoggerFactory;

public class HotelProvidersPriorityProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        SearchOffersParameters params = (SearchOffersParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        RuleSet rules = SalesContextHandler.get().getRules(salesContext);
        RuleProxy proxy = new RuleProxy();
        proxy.getTracer().setDisabled(!LoggerFactory.getLogger((String)"com.gridnine.xtrip.server.gds.GDSConnector.RULES_TRACE").isDebugEnabled());
        proxy.setProxyType(HotelsTargets.HOTEL_SEARCH_RESULT_PARAMETERS.getId());
        proxy.setProxyDate(new Date());
        HotelsParametersProperties properties = new HotelsParametersProperties(salesContext, proxy);
        properties.setCountry(HotelsHelper.getSearchParametersCountry(params));
        proxy.setPropertySet((Object)properties);
        proxy.setActionSet((Object)new HotelsSearchResultActions());
        RuleEngine.applyRules(Collections.singletonList(proxy), (RuleSet)rules);
        HashMap result = new HashMap();
        List hotelProviders = ((HotelsSearchResultActions)proxy.getActionSet()).getHotelProviders().stream().filter(Objects::nonNull).collect(Collectors.toList());
        Collections.reverse(hotelProviders);
        for (int i = 0; i < hotelProviders.size(); ++i) {
            result.put(hotelProviders.get(i), i + 1);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_PROVIDER_PRIORITY, result);
    }
}

