/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.price;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.PricingResult;
import com.gridnine.hotels.web.ws.PricingResultItem;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelOffer;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.PricingParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class PricingResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        PricingParameters params = (PricingParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_PRICING_PARAMS);
        PricingResult response = (PricingResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        EntityContainer gdsAccount = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        HotelsHelper.checkRoomsAvailability(response.getPricingResultItem());
        com.gridnine.xtrip.common.hotels2.model.PricingResult result = new com.gridnine.xtrip.common.hotels2.model.PricingResult();
        HotelCard hotelCard = HotelsHelper.convertHotelCard(((ReservationItem)((PricingResultItem)response.getPricingResultItem().get(0)).getReservationResult().getReservationItems().getReservationItems().get(0)).getHotelCard());
        result.setCard(hotelCard);
        EntityReference gdsAccountRef = gdsAccount.toReference();
        HashMap<String, HotelOffer> map = new HashMap<String, HotelOffer>();
        for (PricingResultItem pri : response.getPricingResultItem()) {
            for (PricingItem pi : pri.getPricingItem()) {
                HotelOffer offer = HotelsHelper.convertHotelOffer(pi, hotelCard, pri, (HotelOffer)params.getOffers().get(Integer.parseInt(pi.getRequestItemId())), (EntityReference<HotelsAggregatorGdsAccount>)gdsAccountRef);
                map.put(pi.getRequestItemId(), offer);
            }
        }
        List offers = hotelCard.getHotelOffers();
        int count = params.getOffers().size();
        for (int i = 0; i < count; ++i) {
            HotelOffer offer = (HotelOffer)map.get(Integer.toString(i));
            HotelOffer originalOffer = (HotelOffer)params.getOffers().get(i);
            if (originalOffer.getAvailability() != null && BooleanUtils.isTrue((Boolean)originalOffer.getAvailability().getImmediateConfirmation()) && offer.getAvailability() != null && BooleanUtils.isFalse((Boolean)offer.getAvailability().getImmediateConfirmation())) {
                ctx.putObject((Enum)IBusHotelsContextKeys.CONFIRMATION_MODE_CHANGED, (Object)true);
            }
            if (offer != null) {
                offers.add(offer);
                offer.setMinClientPrice(originalOffer.getMinClientPrice());
                offer.setMinClientPriceByNight(originalOffer.getMinClientPriceByNight());
                List travellers = offer.getRoomInfo().getTravellers();
                for (int trInd = 0; trInd < travellers.size(); ++trInd) {
                    Traveller traveller = (Traveller)travellers.get(trInd);
                    Traveller originalTraveller = (Traveller)originalOffer.getRoomInfo().getTravellers().get(trInd);
                    traveller.setPassenger(originalTraveller.getPassenger());
                }
                HotelsHelper.addEssentialInfo(originalOffer.getEssentialInfoList(), offer.getEssentialInfoList());
                continue;
            }
            offers.add(originalOffer);
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_PRICING_RESULT, (Object)result);
    }
}

