/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.price;

import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.PricingResult;
import com.gridnine.hotels.web.ws.PricingResultItem;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.util.List;
import java.util.Objects;

public class RepriceResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        List list = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        PricingResult response = (PricingResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        for (PricingResultItem pri : response.getPricingResultItem()) {
            ReservationResult reservationResult = pri.getReservationResult();
            List pricingItems = pri.getPricingItem();
            for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
                String requestItemId = item.getRequestItemId();
                PricingItem pricingItem = pricingItems.stream().filter(pl -> Objects.equals(requestItemId, pl.getRequestItemId())).findFirst().orElse(null);
                HotelProduct hp = (HotelProduct)list.get(Integer.parseInt(requestItemId));
                Integer standardCheckInTime = ((Room)hp.getRooms().get(0)).getStandardCheckInTime();
                Integer standardCheckOutTime = ((Room)hp.getRooms().get(0)).getStandardCheckOutTime();
                HotelsHelper.updateHotelProduct(hp, item, reservationResult, pricingItem, HotelsHelper.convertTime(standardCheckInTime), HotelsHelper.convertTime(standardCheckOutTime), null, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
                HotelsHelper.updateProductSystemNumber(hp);
                RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)hp);
                HotelsHelper.fillContractData(hp, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
                hp.setContractRulesApplied(false);
            }
        }
    }
}

