/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.priceFake;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.PricingItem;
import com.gridnine.hotels.web.ws.ReservationItem;
import com.gridnine.hotels.web.ws.ReservationPricing;
import com.gridnine.hotels.web.ws.ReservationResult;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.rules.standard.hotelProductSettings.HotelProductSettingsActionSet;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rules.elements.RuleProxy;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.handlers.rules.hotel.HotelRulesHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang.BooleanUtils;

public class PriceFakeResultParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        List list = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.PRODUCT_LIST);
        List response = (List)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        ArrayList tidyUpList = null;
        for (ReservationPricing pr : response) {
            List pricingItems = pr.getPricingResult().getPricingItem();
            if (Boolean.TRUE.equals(pr.isRollbackOnDisagree())) {
                if (null == tidyUpList) {
                    tidyUpList = new ArrayList();
                }
                pricingItems.stream().map(PricingItem::getOfferToken).forEach(tidyUpList::add);
            }
            ReservationResult reservationResult = pr.getReservationResult();
            HotelsHelper.updateReservation(reservation, reservationResult);
            for (ReservationItem item : reservationResult.getReservationItems().getReservationItems()) {
                String requestItemId = item.getRequestItemId();
                PricingItem pricingItem = pricingItems.stream().filter(pl -> Objects.equals(requestItemId, pl.getRequestItemId())).findFirst().orElse(null);
                HotelProduct hp = (HotelProduct)list.get(Integer.parseInt(requestItemId));
                Integer standardCheckInTime = ((Room)hp.getRooms().get(0)).getStandardCheckInTime();
                Integer standardCheckOutTime = ((Room)hp.getRooms().get(0)).getStandardCheckOutTime();
                HotelsHelper.updateHotelProduct(hp, item, reservationResult, pricingItem, HotelsHelper.convertTime(standardCheckInTime), HotelsHelper.convertTime(standardCheckOutTime), null, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
                HotelsHelper.updateProductSystemNumber(hp);
                RuleProxy ruleProxy = HotelRulesHelper.applyHotelProductSettingsRules((HotelProduct)hp);
                HotelsHelper.fillContractData(hp, (HotelProductSettingsActionSet)ruleProxy.getActionSet());
                hp.setContractRulesApplied(false);
                if (((Room)hp.getRooms().get(0)).getAvailability() == null || !BooleanUtils.isTrue((Boolean)((Room)hp.getRooms().get(0)).getAvailability().getImmediateConfirmation()) || pricingItem == null || pricingItem.getAvailability() == null || !BooleanUtils.isFalse((Boolean)pricingItem.getAvailability().isImmediateConfirmation())) continue;
                ctx.putObject((Enum)IBusHotelsContextKeys.CONFIRMATION_MODE_CHANGED, (Object)true);
                ctx.addMessage(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)"HOTELS2_HOTEL_PROVIDER_CHANGE_IMMEDIATE_CONFIRMATION", (Object[])new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}));
            }
        }
        if (tidyUpList != null) {
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_TIDY_UP_DATA, tidyUpList);
        }
    }
}

