/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.searchHotelsOffers.byCity;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.HotelsSabreClientIds;
import com.gridnine.hotels.web.ws.HotelsSearchQuery;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.OfferRequestType;
import com.gridnine.hotels.web.ws.Region;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.InvocationContextFactory;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class SearchOffersByCityInitRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "initiateHotelsSearch";

    public void process(MessageContext ctx) throws Exception {
        SearchOffersParameters params = (SearchOffersParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        String clientTariffCode = (String)ctx.getObject((Enum)IBusMidofficeContextKeys.CLIENT_TARIFF_CODE);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        InvocationContextFactory icFactory = new InvocationContextFactory(ctx);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(params, salesContext, icFactory.createSearchOffersContext(), clientTariffCode));
    }

    private HotelsAggregatorRequestData buildRequestData(SearchOffersParameters params, SalesContext salesContext, InvocationContext context, String clientTariffCode) {
        HotelsSearchQuery query = new HotelsSearchQuery();
        query.setLocation(HotelsBaseHelper.convertLocationToGds((DictionaryReference<GeoLocation>)params.getCity()));
        if (params.getRadius() != null) {
            Region region = new Region();
            region.setLatitude(params.getLatitude().doubleValue());
            region.setLongitude(params.getLongitude().doubleValue());
            region.setRadius(params.getRadius().intValue());
            query.setRegion(region);
        }
        if (!params.getSabreContractedIds().isEmpty() || !params.getSabreNegotiatedIds().isEmpty()) {
            HotelsSabreClientIds soapSabreClientIds = new HotelsSabreClientIds();
            soapSabreClientIds.getContractedId().addAll(params.getSabreContractedIds());
            soapSabreClientIds.getNegotiatedId().addAll(params.getSabreNegotiatedIds());
            query.setSabreClientIds(soapSabreClientIds);
        }
        query.setCheckInDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getCheckInDate()));
        query.setCheckOutDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getCheckOutDate()));
        query.setRoomInfo(new HotelsSearchQuery.RoomInfo());
        query.getRoomInfo().getRoomInfo().addAll(params.getRoomsInfo().stream().map(HotelsHelper::convertRoomInfoToGds).collect(Collectors.toList()));
        query.setSubagencyName(((Organization)EntityStorage.get().resolve(salesContext.getSubagency()).getEntity()).getShortName().getStringValue());
        query.setRequestType(OfferRequestType.ALL_OFFERS);
        query.setMixMode(true);
        query.setClientTariffCode(clientTariffCode);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(query);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }
}

