/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.searchHotelsOffers.byCity;

import com.google.common.collect.ArrayListMultimap;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.HotelOffer;
import com.gridnine.hotels.web.ws.HotelsSearchResult;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.HotelsAggregatorGdsAccount;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SearchOffersByCityNextStepResponseParser
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer gdsAccountCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT);
        HotelsSearchResult response = (HotelsSearchResult)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        SearchOffersParameters sop = (SearchOffersParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        if (!response.isCompleted()) {
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_TOKEN, (Object)response.getOfferToken());
        }
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_HOTEL_CARD_LIST, this.getHotelCards(response, (EntityContainer<HotelsAggregatorGdsAccount>)gdsAccountCtr, sop));
        if (response.getWarningMessages() != null && response.getWarningMessages().getWarning() != null) {
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_WARNING_MESSAGES, (Object)response.getWarningMessages().getWarning());
        }
    }

    private List<HotelCard> getHotelCards(HotelsSearchResult response, EntityContainer<HotelsAggregatorGdsAccount> gdsAccountCtr, SearchOffersParameters sop) {
        Objects.requireNonNull(response.getOffers());
        Objects.requireNonNull(response.getHotelCards());
        ArrayListMultimap wsOffersByHotel = ArrayListMultimap.create();
        for (HotelOffer wsOffer : response.getOffers().getOffer()) {
            Objects.requireNonNull(wsOffer.getHotelCardNumber(), String.format("Hotel offer with uid = %s has no hotelCardNumber", wsOffer.getUid()));
            wsOffersByHotel.put((Object)wsOffer.getHotelCardNumber(), (Object)wsOffer);
        }
        List<HotelCard> hotelCards = response.getHotelCards().getHotelCard().stream().map(HotelsHelper::convertHotelCard).filter(Objects::nonNull).collect(Collectors.toList());
        for (HotelCard hotelCard : hotelCards) {
            Collection hotelOffers = wsOffersByHotel.get((Object)hotelCard.getNumber());
            List roomInfo = sop.getRoomsInfo();
            HotelsHelper.convertToHotelCard(roomInfo, hotelOffers, hotelCard, gdsAccountCtr);
        }
        return hotelCards;
    }
}

