/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.searchHotelsOffers.byHotel;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.HotelOffersQuery;
import com.gridnine.hotels.web.ws.HotelsSabreClientIds;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.OfferRequestType;
import com.gridnine.xtrip.common.hotels2.model.SearchOffersParameters;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.InvocationContextFactory;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.stream.Collectors;

public class SearchOffersByHotelInitRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "initiateSearchByHotel";

    public void process(MessageContext ctx) throws Exception {
        SearchOffersParameters params = (SearchOffersParameters)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_SEARCH_OFFERS_PARAMS);
        String clientTariffCode = (String)ctx.getObject((Enum)IBusMidofficeContextKeys.CLIENT_TARIFF_CODE);
        InvocationContextFactory icFactory = new InvocationContextFactory(ctx);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(params, icFactory.createSearchOffersContext(), clientTariffCode));
    }

    private HotelsAggregatorRequestData buildRequestData(SearchOffersParameters params, InvocationContext context, String clientTariffCode) {
        HotelOffersQuery query = new HotelOffersQuery();
        query.setCheckInDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getCheckInDate()));
        query.setCheckOutDate(HotelsBaseHelper.toXMLGregorianCalendar(params.getCheckOutDate()));
        query.setHotelId(params.getHotelCardNumber());
        query.setProviderHotelCode(params.getProviderHotelCode());
        query.setRoomInfo(new HotelOffersQuery.RoomInfo());
        query.getRoomInfo().getRoomInfo().addAll(params.getRoomsInfo().stream().map(HotelsHelper::convertRoomInfoToGds).collect(Collectors.toList()));
        query.setRequestType(OfferRequestType.ALL_OFFERS);
        if (!params.getSabreContractedIds().isEmpty() || !params.getSabreNegotiatedIds().isEmpty()) {
            HotelsSabreClientIds soapSabreClientIds = new HotelsSabreClientIds();
            soapSabreClientIds.getContractedId().addAll(params.getSabreContractedIds());
            soapSabreClientIds.getNegotiatedId().addAll(params.getSabreNegotiatedIds());
            query.setSabreClientIds(soapSabreClientIds);
        }
        query.setClientTariffCode(clientTariffCode);
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(query);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }
}

