/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.Collection;
import org.apache.commons.lang.BooleanUtils;

public class CollectMessagesProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Boolean changed = (Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED);
        Message message = this.buildMessage(ctx.getMessagesReadOnly(), reservation, BooleanUtils.isTrue((Boolean)changed));
        ctx.clearMessages();
        ctx.addMessage(message);
        if (reservation.getStatus() == ReservationStatus.ERROR) {
            reservation.setStatus(null);
            ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED, (Object)true);
        }
    }

    private Message buildMessage(Collection<Message> messages, Reservation reservation, boolean changed) {
        MessageType mesType = MessageType.MESSAGE;
        for (Message mes : messages) {
            if (mes.getType() == MessageType.ERROR) {
                mesType = MessageType.ERROR;
                break;
            }
            if (mes.getType() != MessageType.WARNING) continue;
            mesType = MessageType.WARNING;
        }
        Message result = new Message();
        result.setType(mesType);
        String recordLocator = CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation);
        if (changed) {
            result.setMessage(L10nResourcesManager.createL10nMessage((String)"\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u0431\u044b\u043b\u043e \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u043e", (Object[])new Object[]{recordLocator}));
        } else {
            String message = "\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0} \u043e\u0441\u0442\u0430\u043b\u043e\u0441\u044c \u0431\u0435\u0437 \u0438\u0437\u043c\u0435\u043d\u0435\u043d\u0438\u0439.";
            if (reservation.getStatus() == ReservationStatus.ERROR) {
                message = message.concat(" \u0421\u0442\u0430\u0442\u0443\u0441 '\u041e\u0448\u0438\u0431\u043a\u0430' \u0431\u0443\u0434\u0435\u0442 \u0438\u0437\u043c\u0435\u043d\u0435\u043d.");
            }
            result.setMessage(L10nResourcesManager.createL10nMessage((String)message, (Object[])new Object[]{recordLocator}));
        }
        result.setDetails(MessageHelper.toSimpleString(messages));
        return result;
    }
}

