/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.PenaltyHelper;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.HotelProductUpdater;
import com.gridnine.xtrip.server.ibus.IbusConfigurationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang.BooleanUtils;

public class CorrectHotelReservationProcessor
extends BaseProcessor {
    private boolean correctAnyway = false;

    public void configure(Map<String, String> parameters) {
        this.correctAnyway = Boolean.parseBoolean(IbusConfigurationHelper.getOptionalParameter(parameters, (String)"correct-anyway", (String)"false"));
    }

    public void process(MessageContext ctx) {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Boolean changed = (Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED);
        if (this.needCorrectReservation(changed)) {
            this.correctReservation(reservation, arg_0 -> ((MessageContext)ctx).addMessage(arg_0));
        }
    }

    protected boolean needCorrectReservation(Boolean changed) {
        return this.correctAnyway || BooleanUtils.isTrue((Boolean)changed);
    }

    protected void correctReservation(Reservation reservation, Consumer<Message> messages) {
        this.correctRefunds(reservation, messages);
    }

    private void correctRefunds(Reservation reservation, Consumer<Message> messages) {
        HotelsReservationHelper.getProductsStream(reservation).filter(this::isLastRefund).forEach(ExceptionUtil.wrapConsumer(hp -> this.correctRefund((HotelProduct)hp, messages)));
    }

    private boolean isLastRefund(HotelProduct hp) {
        return hp.getNextProduct() == null && hp.getStatus() == ProductStatus.REFUND && hp.getPreviousProduct() != null && hp.getPreviousProduct().getStatus() == ProductStatus.SELL;
    }

    private void correctRefund(HotelProduct refundProduct, Consumer<Message> messages) throws Exception {
        boolean hasPenalty;
        HotelProduct sellProduct = refundProduct.getPreviousProduct();
        Room refundRoom = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom(refundProduct));
        Room sellRoom = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom(sellProduct));
        boolean priceChanged = false;
        String caption = "\u0442\u0430\u0440\u0438\u0444";
        BigDecimal refundValue = refundRoom.getEquivalentPrice();
        BigDecimal sellValue = sellRoom.getEquivalentPrice();
        if (MiscUtil.isZero((BigDecimal)refundValue, (boolean)true) && !MiscUtil.isZero((BigDecimal)sellValue, (boolean)true)) {
            refundRoom.setEquivalentPrice(sellValue);
            refundRoom.setBasePrice(sellRoom.getBasePrice());
            messages.accept(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildCorrectionMessageTest(refundProduct, caption, refundValue, sellValue), (Object[])new Object[0]));
            priceChanged = true;
        }
        caption = "\u041d\u0414\u0421";
        refundValue = refundRoom.getEquivalentVatPrice();
        sellValue = sellRoom.getEquivalentVatPrice();
        if (refundValue == null && sellValue != null) {
            refundRoom.setVat(sellRoom.getVat());
            refundRoom.setEquivalentVatPrice(sellValue);
            refundRoom.setEquivVatRate(sellRoom.getEquivVatRate());
            refundRoom.setVatAmount(sellRoom.getVatAmount());
            messages.accept(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildCorrectionMessageTest(refundProduct, caption, refundValue, sellValue), (Object[])new Object[0]));
            priceChanged = true;
        }
        caption = "\u041a\u043e\u043c\u0438\u0441\u0441\u0438\u044f";
        boolean bl = hasPenalty = !MiscUtil.isZero((BigDecimal)PenaltyHelper.getPenalty(refundProduct), (boolean)true);
        if (hasPenalty) {
            if (this.hasHotelAggrCommission(refundProduct)) {
                HotelProductCommission hotelCommission = refundProduct.getHotelAggrCommission();
                BigDecimal oldAmount = hotelCommission.getEquivalentAmount();
                hotelCommission.setEquivalentAmount(BigDecimal.ZERO);
                hotelCommission.setAmount(null);
                hotelCommission.setPercentage(null);
                HotelsReservationHelper.updateVendorContractRelationCommission(refundProduct, hotelCommission);
                messages.accept(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildCorrectionMessageTest(refundProduct, caption.concat("/\u0441\u0443\u043c\u043c\u0430"), oldAmount, BigDecimal.ZERO), (Object[])new Object[0]));
            }
        } else if (this.hasHotelAggrCommission(sellProduct) && !this.hasHotelAggrCommission(refundProduct)) {
            HotelsHelper.setHotelCommission(refundProduct, (HotelProductCommission)XCloneHelper.clone((XCloneable)sellProduct.getHotelAggrCommission(), (boolean)true));
            messages.accept(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildCorrectionMessageTest(refundProduct, caption, "", "\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u0430"), (Object[])new Object[0]));
        }
        caption = "UDIDs";
        if (sellProduct.getStatisticalData() != null) {
            boolean modified = false;
            StatisticalData refundStatisticalData = (StatisticalData)MiscUtil.guarded((Object)refundProduct.getStatisticalData(), (Object)new StatisticalData());
            HashMap uids = new HashMap();
            sellProduct.getTravellers().forEach(traveller -> uids.put(traveller.getUid(), traveller.getUid()));
            if (CollectionUtil.isNotEmpty((Collection)sellProduct.getStatisticalData().getTravellerCostCodes()) && CollectionUtil.isEmpty((Collection)refundStatisticalData.getTravellerCostCodes())) {
                refundStatisticalData.getTravellerCostCodes().addAll(XCloneHelper.cloneCollection((Collection)sellProduct.getStatisticalData().getTravellerCostCodes(), (boolean)true, uids));
                modified = true;
            }
            if (modified) {
                refundProduct.setStatisticalData(refundStatisticalData);
                messages.accept(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)this.buildCorrectionMessageTest(refundProduct, caption, "", "\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u044b"), (Object[])new Object[0]));
            }
        }
        if (priceChanged) {
            HotelProductVatFiller.updateVat((HotelProduct)refundProduct);
            HotelProductHelper.updateFops((HotelProduct)refundProduct);
        }
    }

    private boolean hasHotelAggrCommission(HotelProduct hp) {
        return hp.getHotelAggrCommission() != null && !MiscUtil.isZero((BigDecimal)hp.getHotelAggrCommission().getEquivalentAmount(), (boolean)true);
    }

    private String buildCorrectionMessageTest(HotelProduct hp, String caption, Object oldValue, Object newValue) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041a\u043e\u0440\u0440\u0435\u043a\u0442\u0438\u0440\u043e\u0432\u043a\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 ").append(HotelsReservationHelper.getCaption(hp));
        sb.append("/").append(caption).append(": ");
        sb.append(HotelProductUpdater.toString(oldValue)).append("->").append(HotelProductUpdater.toString(newValue));
        return sb.toString();
    }
}

