/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.xtrip.common.hotels2.exception.SyncHotelBookingSetErrorStatusException;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.DailyRate;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProductCommission;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProviderDictData;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Meal;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Penalty;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.XCompareHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.RateMoney;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.model.helpers.ShipmentHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.time.FastDateFormat;

public class HotelProductUpdater {
    private final HotelProduct product;
    private final HotelProduct resultProduct;
    private final HotelProduct newProduct;
    private final List<Message> messages;
    private final boolean alternativelyEquals;
    private boolean changed = false;
    private boolean vatChanged = false;
    private boolean needUpdateFops = false;
    private boolean dontChangeProductWithShipment = false;
    private static Set<ProductStatus> IGNORE_REFUND_STATUSES = EnumSet.of(ProductStatus.REJECT, ProductStatus.VOID_REQUEST);
    private static final FastDateFormat DF = FastDateFormat.getInstance((String)"dd.MM.yyyy HH:mm");

    public HotelProductUpdater(HotelProduct product, HotelProduct newProduct, List<Message> messages) throws Exception {
        this.product = product;
        this.resultProduct = (HotelProduct)XCloneHelper.clone((XCloneable)product);
        this.copyObjectRefs(product, this.resultProduct);
        this.newProduct = newProduct;
        this.messages = messages;
        this.alternativelyEquals = HotelsReservationHelper.alternativelyEquals(product, newProduct);
    }

    public HotelProductUpdater setDontChangeProductWithShipment(boolean value) {
        this.dontChangeProductWithShipment = value;
        return this;
    }

    private void copyObjectRefs(HotelProduct source, HotelProduct target) {
        target.setPreviousProduct(source.getPreviousProduct());
        target.setNextProduct(source.getNextProduct());
    }

    public boolean update() throws Exception {
        XCompareHelper.Difference diff;
        boolean hasRelatedShipment = ShipmentHelper.hasRelatedShipment((BaseProduct)this.product);
        ProductStatus currentProductStatus = this.product.getStatus();
        if (currentProductStatus == ProductStatus.REFUND && this.newProduct.getStatus() == ProductStatus.SELL) {
            throw Xeption.forDeveloper((String)"\u0412 \u041c\u041e\u041c\u0435 \u0441\u0442\u0430\u0442\u0443\u0441 \u0431\u0438\u043b\u0435\u0442\u0430 {0} - \u0432\u043e\u0437\u0432\u0440\u0430\u0442, \u0430 \u0443 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 - \u043f\u0440\u043e\u0434\u0430\u0436\u0430", (Object[])new Object[]{HotelsReservationHelper.getCaption(this.product)});
        }
        if (currentProductStatus == ProductStatus.REFUND && hasRelatedShipment) {
            throw Xeption.forDeveloper((String)"\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 {0} \u0432\u043a\u043b\u044e\u0447\u0435\u043d \u0432 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044e", (Object[])new Object[]{HotelsReservationHelper.getCaption(this.product)});
        }
        if (currentProductStatus == ProductStatus.REQUEST) {
            HotelProduct firstProduct = (HotelProduct)MiscUtil.guarded((Object)this.newProduct.getPreviousProduct(), (Object)this.newProduct);
            currentProductStatus = firstProduct.getStatus();
        }
        if (IGNORE_REFUND_STATUSES.contains(currentProductStatus) && this.newProduct.getStatus() == ProductStatus.REFUND) {
            this.newProduct.setStatus(currentProductStatus);
        }
        Reservation reservation = this.product.getReservation();
        if (this.newProduct.getStatus() == ProductStatus.REFUND) {
            HotelProduct oldSell;
            boolean addRefund = false;
            if (currentProductStatus == ProductStatus.SELL) {
                oldSell = this.product;
                addRefund = true;
            } else if (currentProductStatus == ProductStatus.REFUND) {
                oldSell = this.product.getPreviousProduct();
            } else {
                throw Xeption.forDeveloper((String)"unsupported mom status {0} for refund", (Object[])new Object[]{currentProductStatus});
            }
            HotelProduct newSell = this.newProduct.getPreviousProduct();
            new HotelProductUpdater(oldSell, newSell, this.messages).setDontChangeProductWithShipment(this.dontChangeProductWithShipment).update();
            if (addRefund) {
                this.newProduct.setSystemNumber(oldSell.getSystemNumber());
                BookingHelper.addProduct((Reservation)reservation, (BaseProduct)this.newProduct);
                HotelsReservationHelper.relateProducts(this.product, this.newProduct);
                this.addInsertMessage("\u0432\u043e\u0437\u0432\u0440\u0430\u0442");
                return true;
            }
        }
        this.update("\u0441\u0442\u0430\u0442\u0443\u0441 \u0431\u0438\u043b\u0435\u0442\u0430", HotelProduct::getStatus, arg_0 -> ((HotelProduct)this.resultProduct).setStatus(arg_0));
        this.update("\u0441\u0442\u0430\u0442\u0443\u0441 \u0432 \u043e\u0442\u0435\u043b\u044c\u043d\u043e\u043c \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0435", HotelProduct::getHotelAggrStatus, arg_0 -> ((HotelProduct)this.resultProduct).setHotelAggrStatus(arg_0));
        this.update("\u0441\u0442\u0430\u0442\u0443\u0441 \u0443 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430", HotelProduct::getProviderStatusInfo, arg_0 -> ((HotelProduct)this.resultProduct).setProviderStatusInfo(arg_0));
        this.update("\u043a\u043e\u0434 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelPropertyId, arg_0 -> ((HotelProduct)this.resultProduct).setHotelPropertyId(arg_0), val -> TextUtil.nonBlank((String)this.newProduct.getHotelPropertyId()) && (BooleanUtils.isNotTrue((Boolean)this.resultProduct.getHotelResolved()) || BooleanUtils.isTrue((Boolean)this.newProduct.getHotelResolved())));
        boolean hotelChanged = this.update("\u043a\u043e\u0434 \u043e\u0442\u0435\u043b\u044f \u0443 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430", HotelProduct::getProviderHotelCode, arg_0 -> ((HotelProduct)this.resultProduct).setProviderHotelCode(arg_0));
        this.update("\u0432\u0430\u043b\u044e\u0442\u0430", HotelProduct::getGdsCurrency, arg_0 -> ((HotelProduct)this.resultProduct).setGdsCurrency(arg_0));
        this.update("\u043a\u0443\u0440\u0441 \u0432\u0430\u043b\u044e\u0442\u044b", HotelProduct::getGdsCurrencyRate, arg_0 -> ((HotelProduct)this.resultProduct).setGdsCurrencyRate(arg_0));
        this.update("\u0441\u0442\u0440\u0430\u043d\u0430 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelCountry, arg_0 -> ((HotelProduct)this.resultProduct).setHotelCountry(arg_0));
        this.update("\u0433\u043e\u0440\u043e\u0434 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelLocation, arg_0 -> ((HotelProduct)this.resultProduct).setHotelLocation(arg_0));
        this.update("\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelName, arg_0 -> ((HotelProduct)this.resultProduct).setHotelName(arg_0));
        this.update("\u0430\u0434\u0440\u0435\u0441 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelAddress, arg_0 -> ((HotelProduct)this.resultProduct).setHotelAddress(arg_0));
        this.update("email \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelEmail, arg_0 -> ((HotelProduct)this.resultProduct).setHotelEmail(arg_0));
        this.update("\u0442\u0435\u043b\u0435\u0444\u043e\u043d \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelPhone, arg_0 -> ((HotelProduct)this.resultProduct).setHotelPhone(arg_0));
        this.update("\u0444\u0430\u043a\u0441 \u043e\u0442\u0435\u043b\u044f", HotelProduct::getHotelFax, arg_0 -> ((HotelProduct)this.resultProduct).setHotelFax(arg_0));
        this.update("\u043e\u0444\u043e\u0440\u043c\u043b\u0435\u043d \u043f\u043e 3D", HotelProduct::isTripartiteAgreement, arg_0 -> ((HotelProduct)this.resultProduct).setTripartiteAgreement(arg_0));
        this.update("\u043a\u043b\u0438\u0435\u043d\u0442\u0441\u043a\u0438\u0439 \u043a\u043e\u0434", HotelProduct::getClientTariffCode, arg_0 -> ((HotelProduct)this.resultProduct).setClientTariffCode(arg_0));
        this.updateEssentialInfoData(hotelChanged);
        this.updateTravellers();
        this.updateCommission();
        this.updateProviderData();
        this.updateCancellationPolicy();
        this.updateAdditionalServices();
        this.updateRooms();
        this.updatePenalties();
        boolean updateVatDone = false;
        if (this.needApplyRules()) {
            HotelProductVatFiller.updateVat((HotelProduct)this.resultProduct);
            updateVatDone = true;
            this.resultProduct.setContractRulesApplied(false);
        }
        if (this.needUpdateFops()) {
            if (!updateVatDone) {
                HotelProductVatFiller.updateVat((HotelProduct)this.resultProduct);
            }
            HotelProductHelper.updateFops((HotelProduct)this.resultProduct);
        }
        if (hasRelatedShipment && (diff = ShipmentHelper.getFinanceDifference((BaseProduct)this.product, (BaseProduct)this.resultProduct)) != null) {
            this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u043d\u0430 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f, \u043d\u043e \u0432 \u043d\u0435\u043c \u043f\u043e\u043c\u0435\u043d\u044f\u043b\u0438\u0441\u044c \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e \u0437\u043d\u0430\u0447\u0438\u043c\u044b\u0435 \u043f\u043e\u043b\u044f ({1}: {2} -> {3})", (Object[])new Object[]{HotelsReservationHelper.getCaption(this.product), diff.path, diff.oldValue, diff.newValue}));
            if (this.dontChangeProductWithShipment) {
                throw SyncHotelBookingSetErrorStatusException.forEndUser((String)"\u0414\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u0435\u043d\u0430 \u0440\u0435\u0430\u043b\u0438\u0437\u0430\u0446\u0438\u044f. \u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0431\u0443\u0434\u0435\u0442 \u043f\u0440\u0435\u0440\u0432\u0430\u043d\u0430.", (Object[])new Object[]{HotelsReservationHelper.getCaption(this.product)});
            }
            this.resell();
            return true;
        }
        if (this.changed) {
            this.product.copyFrom((BaseEntity)this.resultProduct, false, new HashMap());
            this.copyObjectRefs(this.resultProduct, this.product);
        }
        return this.changed;
    }

    private boolean needUpdateFops() {
        return this.needUpdateFops || this.vatChanged || this.valueChanged(HotelProduct::getGdsCurrency) || this.valueChanged(HotelProduct::getGdsCurrencyRate) || this.valueChanged(HotelProductHelper::getEquivalentFare) || this.valueChanged(HotelProductHelper::calculateTaxesEquivalentAmount) || this.valueChanged(HotelProductHelper::calculateAddServicesEquivalentAmount) || this.valueChanged(product -> HotelProductHelper.calculatePenaltyEquivalentAmount((HotelProduct)product, (boolean)true));
    }

    private boolean needApplyRules() {
        return this.valueChanged(HotelProduct::getGdsCurrency) || this.valueChanged(HotelProduct::getGdsCurrencyRate) || this.valueChanged(HotelProductHelper::getEquivalentFare) || this.valueChanged(HotelProductHelper::calculateTaxesEquivalentAmount) || this.valueChanged(HotelProductHelper::calculateAddServicesEquivalentAmount) || this.valueChanged(product -> HotelProductHelper.calculatePenaltyEquivalentAmount((HotelProduct)product, (boolean)true)) || this.vatChanged || this.product.getStatus() == ProductStatus.REQUEST && this.resultProduct.getStatus() != ProductStatus.REQUEST;
    }

    private <T> boolean valueChanged(Function<HotelProduct, T> getter) {
        T newValue;
        T oldValue = getter.apply(this.product);
        return !MiscUtil.equals(oldValue, newValue = getter.apply(this.resultProduct));
    }

    private void resell() throws Exception {
        HotelProduct refund = this.buildRefundProduct();
        BookingHelper.addProduct((Reservation)this.product.getReservation(), (BaseProduct)refund);
        HotelsReservationHelper.relateProducts(this.product, refund);
        this.addInsertMessage("\u0432\u043e\u0437\u0432\u0440\u0430\u0442");
        BookingHelper.addProduct((Reservation)this.product.getReservation(), (BaseProduct)this.newProduct);
        HotelsReservationHelper.relateProducts(refund, this.newProduct);
        HotelsHelper.updateProductSystemNumber(this.newProduct);
        this.addInsertMessage("\u043d\u043e\u0432\u0430\u044f \u043f\u0440\u043e\u0434\u0430\u0436\u0430");
    }

    private HotelProduct buildRefundProduct() throws Exception {
        HotelProduct result = HotelProductHelper.clone((HotelProduct)this.product, (boolean)false);
        result.setStatus(ProductStatus.REFUND);
        result.setChecked(false);
        result.setContractRulesApplied(false);
        result.setIssueDate(new Date());
        result.setCurrencyRateDate(this.product.currencyRateDate());
        HotelProductVatFiller.updateVat((HotelProduct)result);
        HotelProductHelper.updateFops((HotelProduct)result);
        return result;
    }

    private void updateCommission() {
        String caption = "\u043a\u043e\u043c\u0438\u0441\u0441\u0438\u044f";
        boolean commissionChanged = this.updateObject(caption, this.resultProduct, this.newProduct, HotelProduct::getHotelAggrCommission, HotelProduct::setHotelAggrCommission, (com, newCom) -> {
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u0441\u0443\u043c\u043c\u0430"), com, newCom, HotelProductCommission::getEquivalentAmount, (oldObj, newObj) -> {
                oldObj.setEquivalentAmount(newObj.getEquivalentAmount());
                oldObj.setAmount(newObj.getAmount());
            }, this.updateCommissionValidator());
            return result |= this.update(this.concatCaption(caption, "\u043f\u0440\u043e\u0446\u0435\u043d\u0442"), com, newCom, HotelProductCommission::getPercentage, (oldObj, newObj) -> oldObj.setPercentage(newObj.getPercentage()), this.updateCommissionValidator());
        });
        if (commissionChanged) {
            HotelsReservationHelper.updateVendorContractRelationCommission(this.resultProduct, this.resultProduct.getHotelAggrCommission());
        }
    }

    private void updateProviderData() {
        String caption = "\u0441\u0442\u0440\u0430\u043d\u0430 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430";
        this.updateObject(caption, this.resultProduct, this.newProduct, HotelProduct::getCountryProviderData, HotelProduct::setCountryProviderData, this.getProviderDictDataUpdater(caption));
        caption = "\u0433\u043e\u0440\u043e\u0434 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430";
        this.updateObject(caption, this.resultProduct, this.newProduct, HotelProduct::getCityProviderData, HotelProduct::setCityProviderData, this.getProviderDictDataUpdater(caption));
    }

    private BiFunction<HotelProviderDictData, HotelProviderDictData, Boolean> getProviderDictDataUpdater(String caption) {
        return (providerData, newProviderData) -> {
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u043a\u043e\u0434 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430"), providerData, newProviderData, HotelProviderDictData::getSystemCode, (oldObj, newObj) -> oldObj.setSystemCode(newObj.getSystemCode()));
            result |= this.update(this.concatCaption(caption, "\u043a\u043e\u0434 \u043f\u0440\u043e\u0432\u0430\u0439\u0434\u0435\u0440\u0430"), providerData, newProviderData, HotelProviderDictData::getProviderCode, (oldObj, newObj) -> oldObj.setProviderCode(newObj.getProviderCode()));
            return result |= this.update(this.concatCaption(caption, "\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), providerData, newProviderData, HotelProviderDictData::getProviderName, (oldObj, newObj) -> oldObj.setProviderName(newObj.getProviderName()));
        };
    }

    private void updateCancellationPolicy() {
        this.update("\u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0442\u0435\u043a\u0443\u0449\u0435\u0439 \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043e\u0442\u043c\u0435\u043d\u044b", HotelProduct::getCancellableNow, arg_0 -> ((HotelProduct)this.resultProduct).setCancellableNow(arg_0));
        this.update("\u043f\u0440\u0438\u0437\u043d\u0430\u043a \u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e\u0441\u0442\u0438 \u043e\u0442\u043c\u0435\u043d\u044b", HotelProduct::isCancellable, arg_0 -> ((HotelProduct)this.resultProduct).setCancellable(arg_0));
        this.update("\u0442\u0435\u043a\u0441\u0442 \u043e\u0442\u043c\u0435\u043d\u044b", HotelProduct::getCancellationPolicyText, arg_0 -> ((HotelProduct)this.resultProduct).setCancellationPolicyText(arg_0));
        this.update("\u0441\u0440\u043e\u043a \u0431\u0435\u0441\u043f\u043b\u0430\u0442\u043d\u043e\u0439 \u043e\u0442\u043c\u0435\u043d\u044b", HotelProduct::getFreeCancellationTerm, arg_0 -> ((HotelProduct)this.resultProduct).setFreeCancellationTerm(arg_0));
        this.updateList(this.resultProduct, this.newProduct, HotelProduct::getCancellationCharges, this::getCancellationChargeCaption, this::isSameCancellationCharge, (charge, newCharge) -> {
            String caption = this.getCancellationChargeCaption((CancellationCharge)newCharge);
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u043d\u0435 \u0434\u043e\u0441\u0442\u0443\u043f\u043d\u043e \u0447\u0435\u0440\u0435\u0437 API"), charge, newCharge, CancellationCharge::getNotAvailableViaAPI, (oldObj, newObj) -> oldObj.setNotAvailableViaAPI(newObj.getNotAvailableViaAPI()));
            result |= this.updateCancellationPenalty((CancellationCharge)charge, (CancellationCharge)newCharge, this.concatCaption(caption, "\u0448\u0442\u0440\u0430\u0444"));
            return result |= this.update(this.concatCaption(caption, "\u043e\u043f\u0438\u0441\u0430\u043d\u0438\u0435"), charge, newCharge, CancellationCharge::getPolicyText, (oldObj, newObj) -> oldObj.setPolicyText(newObj.getPolicyText()));
        });
    }

    private String getCancellationChargeCaption(CancellationCharge charge) {
        return "\u043f\u0435\u0440\u0438\u043e\u0434 \u043e\u0442\u043c\u0435\u043d\u044b " + HotelProductUpdater.toString(charge.getStartDate()) + "-" + HotelProductUpdater.toString(charge.getEndDate());
    }

    private boolean isSameCancellationCharge(CancellationCharge charge1, CancellationCharge charge2) {
        return HotelProductUpdater.equals(charge1, charge2, CancellationCharge::getStartDate) && HotelProductUpdater.equals(charge1, charge2, CancellationCharge::getEndDate);
    }

    private boolean updateCancellationPenalty(CancellationCharge charge, CancellationCharge newCharge, String caption) {
        return this.updateObject(caption, charge, newCharge, CancellationCharge::getPenalty, CancellationCharge::setPenalty, (penalty, newPenalty) -> {
            boolean result = false;
            return result |= this.update(this.concatCaption(caption, "\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), penalty, newPenalty, RateMoney::getMoney, (oldObj, newObj) -> oldObj.setMoney(newObj.getMoney()));
        });
    }

    private void updateAdditionalServices() {
        boolean mofified = this.updateList(this.resultProduct, this.newProduct, HotelProduct::getAdditionalServices, this::getAdditionalServiceCaption, this::isSameAdditionalService, (service, newService) -> {
            String caption = this.getAdditionalServiceCaption((AdditionalService)newService);
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), service, newService, AdditionalService::getName, (oldObj, newObj) -> oldObj.setName(newObj.getName()));
            result |= this.update(this.concatCaption(caption, "\u043a\u043e\u043b\u0438\u0447\u0435\u0441\u0442\u0432\u043e"), service, newService, AdditionalService::getCount, (oldObj, newObj) -> oldObj.setCount(newObj.getCount()));
            result |= this.update(this.concatCaption(caption, "\u0441\u0442\u0430\u0442\u0443\u0441"), service, newService, AdditionalService::getStatus, (oldObj, newObj) -> oldObj.setStatus(newObj.getStatus()));
            result |= this.update(this.concatCaption(caption, "\u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430 \u0432 \u0442\u0430\u0440\u0438\u0444"), service, newService, AdditionalService::isIncludedInTariff, (oldObj, newObj) -> oldObj.setIncludedInTariff(newObj.isIncludedInTariff()));
            result |= this.update(this.concatCaption(caption, "\u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u044c"), service, newService, AdditionalService::getEquivalentAmount, (oldObj, newObj) -> {
                oldObj.setEquivalentAmount(newObj.getEquivalentAmount());
                oldObj.setBaseAmount(newObj.getBaseAmount());
            });
            result |= this.update(this.concatCaption(caption, "\u0441\u0443\u043c\u043c\u0430 \u041d\u0414\u0421"), service, newService, AdditionalService::getEquivalentVatAmount, (oldObj, newObj) -> {
                oldObj.setEquivalentVatAmount(newObj.getEquivalentVatAmount());
                this.vatChanged = true;
            });
            return result |= this.update(this.concatCaption(caption, "\u0441\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421"), service, newService, AdditionalService::getEquivalentVatRate, (oldObj, newObj) -> {
                oldObj.setEquivalentVatRate(newObj.getEquivalentVatRate());
                this.vatChanged = true;
            });
        });
        this.needUpdateFops |= mofified;
    }

    private String getAdditionalServiceCaption(AdditionalService service) {
        String result = "\u0434\u043e\u043f. \u0443\u0441\u043b\u0443\u0433\u0430 " + service.getType() + " " + service.getName();
        if (TextUtil.nonBlank((String)service.getCode())) {
            result = result + " (" + service.getCode() + ")";
        }
        return result;
    }

    private boolean isSameAdditionalService(AdditionalService service1, AdditionalService service2) {
        if (!HotelProductUpdater.equals(service1, service2, AdditionalService::getType)) {
            return false;
        }
        if (!HotelProductUpdater.equals(service1, service2, AdditionalService::getCode)) {
            return false;
        }
        return !TextUtil.isBlank((String)service1.getCode()) || HotelProductUpdater.equals(service1, service2, AdditionalService::getName);
    }

    private void updateRooms() {
        this.updateList(this.resultProduct, this.newProduct, HotelProduct::getRooms, this::getRoomCaption, (r1, r2) -> HotelsReservationHelper.isSameRoom(r1, r2, this.alternativelyEquals), (room, newRoom) -> {
            String caption = this.getRoomCaption((Room)newRoom);
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u0441\u0438\u0433\u043d\u0430\u0442\u0443\u0440\u0430"), room, newRoom, Room::getSignature, (oldObj, newObj) -> oldObj.setSignature(newObj.getSignature()));
            result |= this.update(this.concatCaption(caption, "\u043d\u0430\u0438\u043c\u0435\u043d\u043e\u0432\u0430\u043d\u0438\u0435"), room, newRoom, Room::getRoomName, (oldObj, newObj) -> oldObj.setRoomName(newObj.getRoomName()));
            result |= this.update(this.concatCaption(caption, "\u0434\u0430\u0442\u0430 \u0437\u0430\u0435\u0437\u0434\u0430"), room, newRoom, Room::getCheckInDate, (oldObj, newObj) -> oldObj.setCheckInDate(newObj.getCheckInDate()));
            result |= this.update(this.concatCaption(caption, "\u0434\u0430\u0442\u0430 \u0432\u044b\u0435\u0437\u0434\u0430"), room, newRoom, Room::getCheckOutDate, (oldObj, newObj) -> oldObj.setCheckOutDate(newObj.getCheckOutDate()));
            result |= this.update(this.concatCaption(caption, "\u0432\u0440\u0435\u043c\u044f \u0437\u0430\u0435\u0437\u0434\u0430"), room, newRoom, Room::getCheckInTime, (oldObj, newObj) -> oldObj.setCheckInTime(newObj.getCheckInTime()));
            result |= this.update(this.concatCaption(caption, "\u0432\u0440\u0435\u043c\u044f \u0432\u044b\u0435\u0437\u0434\u0430"), room, newRoom, Room::getCheckOutTime, (oldObj, newObj) -> oldObj.setCheckOutTime(newObj.getCheckOutTime()));
            result |= this.update(this.concatCaption(caption, "\u043a\u043e\u043b-\u0432\u043e \u043c\u0435\u0441\u0442"), room, newRoom, Room::getNumberOfPeople, (oldObj, newObj) -> oldObj.setNumberOfPeople(newObj.getNumberOfPeople()));
            result |= this.update(this.concatCaption(caption, "\u0442\u0438\u043f \u043d\u043e\u043c\u0435\u0440\u0430"), room, newRoom, Room::getRoomSize, (oldObj, newObj) -> oldObj.setRoomSize(newObj.getRoomSize()));
            result |= this.update(this.concatCaption(caption, "c \u041d\u0414\u0421"), room, newRoom, Room::getVat, (oldObj, newObj) -> oldObj.setVat(newObj.getVat()), this.updateVatValidator((Room)room, (Room)newRoom));
            result |= this.update(this.concatCaption(caption, "\u0441\u0442\u0430\u0432\u043a\u0430 \u041d\u0414\u0421"), room, newRoom, Room::getEquivVatRate, (oldObj, newObj) -> {
                oldObj.setEquivVatRate(newObj.getEquivVatRate());
                this.vatChanged = true;
            }, this.updateVatValidator((Room)room, (Room)newRoom));
            result |= this.update(this.concatCaption(caption, "\u0441\u0443\u043c\u043c\u0430 \u041d\u0414\u0421"), room, newRoom, Room::getEquivalentVatPrice, (oldObj, newObj) -> {
                oldObj.setEquivalentVatPrice(newObj.getEquivalentVatPrice());
                oldObj.setVatAmount(newObj.getVatAmount());
                this.vatChanged = true;
            }, this.updateVatValidator((Room)room, (Room)newRoom));
            result |= this.update(this.concatCaption(caption, "\u044d\u043a\u0432. \u0442\u0430\u0440\u0438\u0444 \u0437\u0430 \u043d\u043e\u0447\u044c"), room, newRoom, Room::getEquivalentRate, (oldObj, newObj) -> oldObj.setEquivalentRate(newObj.getEquivalentRate()));
            result |= this.update(this.concatCaption(caption, "\u0442\u0430\u0440\u0438\u0444 \u0437\u0430 \u043d\u043e\u0447\u044c"), room, newRoom, Room::getBaseRate, (oldObj, newObj) -> oldObj.setBaseRate(newObj.getBaseRate()), val -> !MoneyHelper.isZero((Money)val));
            result |= this.update(this.concatCaption(caption, "\u0442\u0430\u0440\u0438\u0444"), room, newRoom, Room::getEquivalentPrice, (oldObj, newObj) -> {
                oldObj.setEquivalentPrice(newObj.getEquivalentPrice());
                oldObj.setBasePrice(newObj.getBasePrice());
            }, val -> !MiscUtil.isZero((BigDecimal)val, (boolean)true));
            result |= this.updateMeal((Room)room, (Room)newRoom, this.concatCaption(caption, "\u043f\u0438\u0442\u0430\u043d\u0438\u0435"));
            result |= this.update(this.concatCaption(caption, "\u043f\u0440\u043e\u0434\u0430\u0436\u0430 \u0441\u043e \u0448\u0442\u0440\u0430\u0444\u043e\u043c"), room, newRoom, Room::isSellWithPenalty, (oldObj, newObj) -> oldObj.setSellWithPenalty(newObj.isSellWithPenalty()));
            return result |= this.updateDailyRates((Room)room, (Room)newRoom, this.concatCaption(caption, "\u0441\u0443\u0442\u043e\u0447\u043d\u044b\u0435 \u0442\u0430\u0440\u0438\u0444\u044b"));
        });
    }

    private boolean updateDailyRates(Room room, Room newRoom, String caption) {
        if (!room.getDailyRates().isEmpty() && newRoom.getDailyRates().stream().map(DailyRate::getRate).allMatch(MoneyHelper::isZero)) {
            return false;
        }
        boolean result = this.updateList(room, newRoom, Room::getDailyRates, this::getDailyRatesCaption, this::isSameDailyRate, (dailyRate, newDailyRate) -> {
            boolean r = false;
            String startDate = HotelProductUpdater.toString(dailyRate.getStartDate());
            String endDate = HotelProductUpdater.toString(dailyRate.getEndDate());
            r |= this.update(this.concatCaption(caption, String.format("\u0442\u0430\u0440\u0438\u0444 c %s \u0434\u043e %s", startDate, endDate)), dailyRate, newDailyRate, DailyRate::getRate, (oldObj, newObj) -> oldObj.setRate(newObj.getRate()), val -> !MoneyHelper.isZero((Money)val));
            r |= this.update(this.concatCaption(caption, String.format("\u043d\u0430\u0446\u0435\u043d\u043a\u0430 c %s \u0434\u043e %s", startDate, endDate)), dailyRate, newDailyRate, DailyRate::getSurcharge, (oldObj, newObj) -> oldObj.setSurcharge(newObj.getSurcharge()), val -> !MoneyHelper.isZero((Money)val));
            return r |= this.update(this.concatCaption(caption, String.format("\u043d\u0430\u043b\u043e\u0433 c %s \u0434\u043e %s", startDate, endDate)), dailyRate, newDailyRate, DailyRate::getTax, (oldObj, newObj) -> oldObj.setTax(newObj.getTax()), val -> !MoneyHelper.isZero((Money)val));
        });
        CollectionUtil.sort((List)room.getDailyRates(), Comparator.comparing(DailyRate::getStartDate));
        return result;
    }

    private String getDailyRatesCaption(DailyRate dailyRate) {
        return String.format("\u0441\u0443\u0442\u043e\u0447\u043d\u044b\u0439 \u0442\u0430\u0440\u0438\u0444 c %s \u0434\u043e %s", HotelProductUpdater.toString(dailyRate.getStartDate()), HotelProductUpdater.toString(dailyRate.getEndDate()));
    }

    private boolean isSameDailyRate(DailyRate dailyRate1, DailyRate dailyRate2) {
        return HotelProductUpdater.equals(dailyRate1, dailyRate2, DailyRate::getStartDate) && HotelProductUpdater.equals(dailyRate1, dailyRate2, DailyRate::getEndDate);
    }

    private <T> Function<T, Boolean> updateVatValidator(Room room, Room newRoom) {
        switch (this.newProduct.getProvider()) {
            case OSTROVOK: {
                return val -> !MiscUtil.isZero((BigDecimal)newRoom.getEquivalentVatPrice(), (boolean)true);
            }
            case A_AND_A: {
                return val -> !BigDecimal.ZERO.equals(room.getEquivalentVatPrice()) && newRoom.getEquivalentVatPrice() != null;
            }
        }
        return val -> true;
    }

    private <T> Function<T, Boolean> updateCommissionValidator() {
        return val -> this.newProduct.getStatus() != ProductStatus.REJECT && (!this.isRefund(this.newProduct) || MiscUtil.isZero((BigDecimal)this.getHotelAggrCommissionAmount(this.product), (boolean)true) || !MiscUtil.isZero((BigDecimal)this.getHotelAggrCommissionAmount(this.newProduct), (boolean)true));
    }

    private BigDecimal getHotelAggrCommissionAmount(HotelProduct product) {
        return product.getHotelAggrCommission() == null ? null : product.getHotelAggrCommission().getEquivalentAmount();
    }

    private boolean isRefund(HotelProduct product) {
        return product.getStatus() == ProductStatus.REFUND || product.getNextProduct() != null && product.getNextProduct().getStatus() == ProductStatus.REFUND;
    }

    private boolean updateMeal(Room room, Room newRoom, String caption) {
        return this.updateObject(caption, room, newRoom, Room::getMeal, Room::setMeal, (meal, newMeal) -> {
            boolean result = false;
            result |= this.update(this.concatCaption(caption, "\u043a\u043e\u0434"), meal, newMeal, Meal::getCode, (oldObj, newObj) -> oldObj.setCode(newObj.getCode()));
            result |= this.update(this.concatCaption(caption, "\u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), meal, newMeal, Meal::getCaption, (oldObj, newObj) -> oldObj.setCaption(newObj.getCaption()));
            result |= this.update(this.concatCaption(caption, "\u0431\u0430\u0437\u043e\u0432\u044b\u0439 \u043a\u043e\u0434"), meal, newMeal, Meal::getBaseCode, (oldObj, newObj) -> oldObj.setBaseCode(newObj.getBaseCode()));
            return result |= this.update(this.concatCaption(caption, "\u0431\u0430\u0437\u043e\u0432\u043e\u0435 \u043d\u0430\u0437\u0432\u0430\u043d\u0438\u0435"), meal, newMeal, Meal::getBaseCaption, (oldObj, newObj) -> oldObj.setBaseCaption(newObj.getBaseCaption()));
        });
    }

    private String getRoomCaption(Room room) {
        return "\u043d\u043e\u043c\u0435\u0440 " + room.getRoomName() + "(" + HotelsReservationHelper.getRoomId(room) + ")";
    }

    private void updatePenalties() {
        this.updateList(this.resultProduct, this.newProduct, HotelProduct::getPenalties, this::getPenaltyCaption, this::isSamePenalty, (penalty, newPenalty) -> {
            String caption = this.getPenaltyCaption((Penalty)newPenalty);
            boolean result = false;
            return result |= this.update(this.concatCaption(caption, "\u0437\u043d\u0430\u0447\u0435\u043d\u0438\u0435"), penalty, newPenalty, Penalty::getEquivalentAmount, (oldObj, newObj) -> {
                oldObj.setEquivalentAmount(newObj.getEquivalentAmount());
                oldObj.setBaseAmount(newObj.getBaseAmount());
                oldObj.setEquivalentVatAmount(newObj.getEquivalentVatAmount());
            });
        });
    }

    private String getPenaltyCaption(Penalty penalty) {
        return "\u0448\u0442\u0440\u0430\u0444 " + penalty.getCode();
    }

    private boolean isSamePenalty(Penalty penalty1, Penalty penalty2) {
        return HotelProductUpdater.equals(penalty1, penalty2, Penalty::getCode);
    }

    void updateTravellers() {
        Room room = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom(this.resultProduct));
        List productTravellers = this.resultProduct.getTravellers();
        ArrayList missing = new ArrayList(productTravellers);
        boolean corteosReservation = this.resultProduct.getReservation().getType() == ReservationType.CORTEOS;
        for (int i = 0; i < this.newProduct.getTravellers().size(); ++i) {
            PassengerTypeReference resultPassengerTypeRef;
            Traveller newTraveller = (Traveller)this.newProduct.getTravellers().get(i);
            String newTravellerUid = newTraveller.getUid();
            PassengerTypeReference newPassengerTypeRef = this.findPassengerTypeRef(newTravellerUid, this.newProduct.getTravellersPassengerTypes());
            if (newPassengerTypeRef == null) {
                throw Xeption.forDeveloper((String)"unsupported case: PassengerTypeReference is null", (Object[])new Object[0]);
            }
            String caption = this.getTravellerCaption(newTraveller);
            Traveller traveller = (Traveller)CollectionUtil.find((Collection)productTravellers, (Object)newTraveller, HotelProductUpdater::isSameTraveller);
            if (traveller == null) {
                if (corteosReservation && productTravellers.size() > i && productTravellers.get(i) != null) {
                    PassengerTypeReference resultPassengerTypeRef2 = this.findPassengerTypeRef(((Traveller)productTravellers.get(i)).getUid(), this.resultProduct.getTravellersPassengerTypes());
                    if (resultPassengerTypeRef2 != null) continue;
                    newPassengerTypeRef.setTravellerUid(((Traveller)productTravellers.get(i)).getUid());
                    this.resultProduct.getTravellersPassengerTypes().add(newPassengerTypeRef);
                    this.addInsertMessage(this.concatCaption(caption, "\u0422\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430"));
                    this.changed = true;
                    continue;
                }
                productTravellers.add(newTraveller);
                room.getRoomTravellersUids().add(newTravellerUid);
                this.addInsertMessage(caption);
                this.resultProduct.getTravellersPassengerTypes().add(newPassengerTypeRef);
                this.changed = true;
                continue;
            }
            missing.remove(traveller);
            String travellerUid = traveller.getUid();
            if (!MiscUtil.equals((Object)travellerUid, (Object)newTravellerUid)) {
                this.replaceTravellerData(this.newProduct, newTraveller, traveller);
                this.replaceTravellerData(this.newProduct.getNextProduct(), newTraveller, traveller);
                newTraveller.setUid(travellerUid);
            }
            if ((resultPassengerTypeRef = this.findPassengerTypeRef(travellerUid, this.resultProduct.getTravellersPassengerTypes())) != null) continue;
            this.resultProduct.getTravellersPassengerTypes().add(newPassengerTypeRef);
            this.addInsertMessage(this.concatCaption(caption, "\u0422\u0438\u043f \u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430"));
            this.changed = true;
        }
        if (!corteosReservation) {
            for (Traveller missingTraveller : missing) {
                productTravellers.remove(missingTraveller);
                this.resultProduct.getTravellersPassengerTypes().removeIf(tpt -> MiscUtil.equals((Object)missingTraveller.getUid(), (Object)tpt.getTravellerUid()));
                room.getRoomTravellersUids().remove(missingTraveller.getUid());
                if (this.resultProduct.getStatisticalData() != null) {
                    this.resultProduct.getStatisticalData().getTravellerCostCodes().removeIf(tcc -> MiscUtil.equals((Object)missingTraveller, (Object)tcc.getTraveller()));
                }
                this.addDeleteMessage(this.getTravellerCaption(missingTraveller));
                this.changed = true;
            }
        }
    }

    private void replaceTravellerData(HotelProduct product, Traveller replacedTraveller, Traveller traveller) {
        if (product != null) {
            String replacedTravellerUid = replacedTraveller.getUid();
            String travellerUid = traveller.getUid();
            PassengerTypeReference passengerTypeRef = Objects.requireNonNull(this.findPassengerTypeRef(replacedTravellerUid, product.getTravellersPassengerTypes()));
            Room room = Objects.requireNonNull(HotelsReservationHelper.getFirstRoom(product));
            passengerTypeRef.setTravellerUid(travellerUid);
            room.getRoomTravellersUids().remove(replacedTravellerUid);
            room.getRoomTravellersUids().add(travellerUid);
            if (product.getStatisticalData() != null) {
                for (TravellerCostCodes travellerCostCode : product.getStatisticalData().getTravellerCostCodes()) {
                    if (!MiscUtil.equals((Object)replacedTraveller, (Object)travellerCostCode.getTraveller())) continue;
                    travellerCostCode.setTraveller(traveller);
                }
            }
        }
    }

    private PassengerTypeReference findPassengerTypeRef(String travellerUid, List<PassengerTypeReference> travellersPassengerTypes) {
        return travellersPassengerTypes.stream().filter(tpt -> MiscUtil.equals((Object)travellerUid, (Object)tpt.getTravellerUid())).findFirst().orElse(null);
    }

    private String getTravellerCaption(Traveller traveller) {
        return "\u043f\u0443\u0442\u0435\u0448\u0435\u0441\u0442\u0432\u0435\u043d\u043d\u0438\u043a " + traveller.getName();
    }

    static boolean isSameTraveller(Traveller tr1, Traveller tr2) {
        if (MiscUtil.equals((Object)tr1.getPassenger(), (Object)tr2.getPassenger(), (boolean)false)) {
            return true;
        }
        Passport psp1 = tr1.getPassport();
        Passport psp2 = tr2.getPassport();
        if (psp1 != null || psp2 != null) {
            return HotelProductUpdater.isSamePassport(psp1, psp2);
        }
        if (!HotelProductUpdater.equals(tr1, tr2, tr -> HotelProductUpdater.toLowerCase(tr.getName()))) {
            return false;
        }
        return HotelProductUpdater.equals(tr1, tr2, Traveller::getBirthday);
    }

    private static boolean isSamePassport(Passport psp1, Passport psp2) {
        return HotelProductUpdater.equals(psp1, psp2, psp -> HotelProductUpdater.toLowerCase(psp.getLastName())) && HotelProductUpdater.equals(psp1, psp2, psp -> HotelProductUpdater.toLowerCase(psp.getFirstName())) && HotelProductUpdater.equalsOrValue2isNull(psp1, psp2, Passport::getNumber) && HotelProductUpdater.equalsOrValue2isNull(psp1, psp2, Passport::getType) && HotelProductUpdater.equalsOrValue2isNull(psp1, psp2, Passport::getBirthday);
    }

    private boolean isRoomsChanged() {
        boolean result = false;
        if (!CollectionUtil.equals((Collection)this.resultProduct.getRooms(), (Collection)this.newProduct.getRooms(), (r1, r2) -> HotelsReservationHelper.isSameRoom(r1, r2, this.alternativelyEquals), (boolean)false)) {
            return true;
        }
        for (Room newRoom : this.newProduct.getRooms()) {
            Room room = (Room)CollectionUtil.find((Collection)this.resultProduct.getRooms(), (Object)newRoom, (r1, r2) -> HotelsReservationHelper.isSameRoom(r1, r2, this.alternativelyEquals));
            if (room == null) {
                return true;
            }
            result |= !MiscUtil.equals((Object)newRoom.getRoomName(), (Object)room.getRoomName());
        }
        return result;
    }

    private void updateEssentialInfoData(boolean hotelChanged) {
        if (hotelChanged) {
            this.updateEssentialInfoDataList(true);
            return;
        }
        if (this.isRoomsChanged()) {
            EssentialInfoData newAmenities = this.newProduct.getEssentialInfoData().stream().filter(data -> data.getType() == EssentialInfoDataType.ROOM_AMENITIES).findFirst().orElse(null);
            EssentialInfoData resultAmenities = this.resultProduct.getEssentialInfoData().stream().filter(data -> data.getType() == EssentialInfoDataType.ROOM_AMENITIES).findFirst().orElse(null);
            if (newAmenities == null) {
                if (resultAmenities != null && this.resultProduct.getEssentialInfoData().remove(resultAmenities)) {
                    this.addDeleteMessage(this.getEssentialInfoDataCaption(resultAmenities));
                }
                return;
            }
            if (resultAmenities == null) {
                this.resultProduct.getEssentialInfoData().add(newAmenities);
                this.addInsertMessage(this.getEssentialInfoDataCaption(newAmenities));
                return;
            }
            this.updateList(resultAmenities, newAmenities, EssentialInfoData::getInfoValue, info -> this.concatCaption(this.getEssentialInfoDataCaption(newAmenities), (String)info), MiscUtil::equals, (info, newInfo) -> false);
            return;
        }
        this.updateEssentialInfoDataList(false);
    }

    private void updateEssentialInfoDataList(boolean deleteOriginValues) {
        this.updateList(this.resultProduct, this.newProduct, HotelProduct::getEssentialInfoData, this::getEssentialInfoDataCaption, this::isSameEssentialInfoData, (data, newData) -> {
            String caption = this.getEssentialInfoDataCaption((EssentialInfoData)newData);
            boolean result = false;
            return result |= this.updateList(data, newData, EssentialInfoData::getInfoValue, info -> this.concatCaption(caption, (String)info), MiscUtil::equals, (info, newInfo) -> false, deleteOriginValues);
        }, deleteOriginValues);
    }

    private boolean isSameEssentialInfoData(EssentialInfoData data1, EssentialInfoData data2) {
        return MiscUtil.equals((Object)data1.getType(), (Object)data2.getType());
    }

    private String getEssentialInfoDataCaption(EssentialInfoData data) {
        return "\u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043e\u0442 \u043f\u043e\u0441\u0442\u0430\u0432\u0449\u0438\u043a\u0430 \u0441 \u0442\u0438\u043f\u043e\u043c: " + (data.getType() != null ? data.getType().name() : "?");
    }

    private static String toLowerCase(String str) {
        return str == null ? null : str.toLowerCase();
    }

    private <O, T> boolean updateObject(String caption, O oldObj, O newObj, Function<O, T> getter, BiConsumer<O, T> setter, BiFunction<T, T, Boolean> updater) {
        T oldValue = getter.apply(oldObj);
        T newValue = getter.apply(newObj);
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null) {
            setter.accept(oldObj, newValue);
            this.addInsertMessage(caption);
            this.changed = true;
            return true;
        }
        if (newValue == null) {
            setter.accept(oldObj, newValue);
            this.addDeleteMessage(caption);
            this.changed = true;
            return true;
        }
        return updater.apply(oldValue, newValue);
    }

    private <O, T> boolean updateList(O oldObj, O newObj, Function<O, Collection<T>> getter, Function<T, String> getCaption, CollectionUtil.Equator<T, T> equator, BiFunction<T, T, Boolean> updater) {
        return this.updateList(oldObj, newObj, getter, getCaption, equator, updater, true);
    }

    private <O, T> boolean updateList(O oldObj, O newObj, Function<O, Collection<T>> getter, Function<T, String> getCaption, CollectionUtil.Equator<T, T> equator, BiFunction<T, T, Boolean> updater, boolean deleteOriginValues) {
        boolean result = false;
        String caption = null;
        Collection<T> origin = getter.apply(oldObj);
        Collection<T> newList = getter.apply(newObj);
        ArrayList<T> missing = new ArrayList<T>(origin);
        for (T newValue : newList) {
            String valueCaption = this.concatCaption(caption, getCaption.apply(newValue));
            Object oldValue = CollectionUtil.find(missing, newValue, equator);
            if (oldValue == null) {
                origin.add(newValue);
                this.addInsertMessage(valueCaption);
                this.changed = true;
                result = true;
                continue;
            }
            missing.remove(oldValue);
            result |= updater.apply(oldValue, newValue).booleanValue();
        }
        if (deleteOriginValues) {
            for (Object missingValue : missing) {
                origin.remove(missingValue);
                this.addDeleteMessage(this.concatCaption(caption, getCaption.apply(missingValue)));
                this.changed = true;
                result = true;
            }
        }
        return result;
    }

    private <T> boolean update(String fieldCaption, Function<HotelProduct, T> getter, Consumer<T> setter) {
        return this.update(fieldCaption, getter, setter, Objects::nonNull);
    }

    private <T> boolean update(String fieldCaption, Function<HotelProduct, T> getter, Consumer<T> setter, Function<T, Boolean> valueValidator) {
        return this.update(fieldCaption, this.resultProduct, this.newProduct, getter, (oldObj, newObj) -> setter.accept(getter.apply((HotelProduct)newObj)), valueValidator);
    }

    private <O, T> boolean update(String caption, O oldObj, O newObj, Function<O, T> getter, BiConsumer<O, O> setter) {
        return this.update(caption, oldObj, newObj, getter, setter, Objects::nonNull);
    }

    private <O, T> boolean update(String caption, O oldObj, O newObj, Function<O, T> getter, BiConsumer<O, O> setter, Function<T, Boolean> valueValidator) {
        T newValue;
        T oldValue = getter.apply(oldObj);
        if (!HotelProductUpdater.equals(oldValue, newValue = getter.apply(newObj))) {
            if (!valueValidator.apply(newValue).booleanValue()) {
                return false;
            }
            setter.accept(oldObj, newObj);
            this.addUpdateMessage(caption, oldValue, newValue);
            this.changed = true;
            return true;
        }
        return false;
    }

    private <T> void addUpdateMessage(String caption, T oldValue, T newValue) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append(HotelProductUpdater.toString(oldValue)).append("->").append(HotelProductUpdater.toString(newValue));
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    static String toString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Date) {
            return HotelProductUpdater.dateToString((Date)value);
        }
        return value.toString();
    }

    private static String dateToString(Date date) {
        return DF.format(date);
    }

    private static <T> boolean equals(T o1, T o2, Function<T, ?> getter) {
        return HotelProductUpdater.equals(getter.apply(o1), getter.apply(o2));
    }

    private static <T> boolean equalsOrValue2isNull(T o1, T o2, Function<T, ?> getter) {
        Object val2 = getter.apply(o2);
        return val2 == null || HotelProductUpdater.equals(getter.apply(o1), val2);
    }

    private static <T> boolean equals(T o1, T o2) {
        if (o1 == null && o2 == null) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof Money) {
            Money m1 = (Money)o1;
            Money m2 = (Money)o2;
            return MiscUtil.equals((Object)m1.getValue(), (Object)m2.getValue()) && MiscUtil.equals((Object)m1.getCurrency(), (Object)m2.getCurrency());
        }
        return MiscUtil.equals(o1, o2);
    }

    private <T> void addInsertMessage(String caption) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append("\u0434\u043e\u0431\u0430\u0432\u043b\u0435\u043d\u043e");
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    private <T> void addDeleteMessage(String caption) {
        StringBuilder sb = this.createProductCaptionsStringBuilder(caption);
        sb.append(": ").append("\u0443\u0434\u0430\u043b\u0435\u043d\u043e");
        this.messages.add(MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)sb.toString(), (Object[])new Object[0]));
    }

    private StringBuilder createProductCaptionsStringBuilder(String caption) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u041f\u0440\u043e\u0434\u0443\u043a\u0442 ").append(HotelsReservationHelper.getCaption(this.resultProduct));
        if (TextUtil.nonBlank((String)caption)) {
            sb.append("/").append(caption);
        }
        return sb;
    }

    private String concatCaption(String caption, String add) {
        return Stream.of(caption, add).filter(TextUtil::nonBlank).collect(Collectors.joining("/"));
    }
}

