/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.InvocationContext;
import com.gridnine.hotels.web.ws.LoadReservationQuery;
import com.gridnine.hotels.web.ws.ReservationID;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.server.hotels2.ibus.HotelsAggregatorRequestData;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;

public class LoadReservationRequestBuilder
extends BaseProcessor {
    private static final String METHOD = "loadReservation";

    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_REQUEST_DATA, (Object)this.buildRequestData(reservation));
    }

    private HotelsAggregatorRequestData buildRequestData(Reservation reservation) {
        HotelProduct firstProduct = HotelsReservationHelper.getFirstProduct(reservation);
        ReservationID reservationID = HotelsHelper.buildReservationID(reservation, Boolean.TRUE);
        if (reservationID == null) {
            throw Xeption.forDeveloper((String)"invalid reservation identification data", (Object[])new Object[0]);
        }
        LoadReservationQuery wsParams = new LoadReservationQuery();
        wsParams.setProvider(HotelsBaseHelper.convertProviderToGds(firstProduct.getProvider()));
        wsParams.setDictionaryLanguages(HotelsHelper.buildDefaultDictionaryLanguages());
        wsParams.setReservationID(reservationID);
        InvocationContext context = new InvocationContext();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(context);
        objects.add(wsParams);
        return new HotelsAggregatorRequestData(objects, METHOD, context);
    }
}

