/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.hotels.web.ws.LoadReservationResponse;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ContractRelationAdditionalServicesDetalization;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceData;
import com.gridnine.xtrip.common.model.booking.ContractRelationServiceDataDetalization;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.TravellerCostCodes;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.server.hotels2.HotelsTestBase;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.importBooking.HotelReservationBuilder;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.CorrectHotelReservationProcessor;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.UpdateBookingFileTravellersProcessor;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.UpdateHotelReservationProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.test.XModelAssert;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.Assert;
import org.junit.Test;

public class SyncBookingTest
extends HotelsTestBase {
    private final HotelReservationBuilder buildProcessor = new HotelReservationBuilder();
    private final UpdateHotelReservationProcessor updateProcessor = new UpdateHotelReservationProcessor();
    private final CorrectHotelReservationProcessor correctProcessor = new CorrectHotelReservationProcessor();
    private final UpdateBookingFileTravellersProcessor bookingTravellersProcessor = new UpdateBookingFileTravellersProcessor();

    public void setUp() throws Exception {
        super.setUp();
        LocaleManager.get().setCurrentLocale(LocaleHelper.RU_LOCALE);
    }

    @Test
    public void testCase1() throws Exception {
        this.testScenario("case1");
    }

    @Test
    public void testCase2() throws Exception {
        this.testScenario("case2");
    }

    @Test
    public void testCase3() throws Exception {
        this.testScenario("case3");
    }

    @Test
    public void testCase4() throws Exception {
        this.testScenario("case4");
    }

    @Test
    public void testCase5() throws Exception {
        this.testScenario("case5");
    }

    @Test
    public void testCase6() throws Exception {
        this.testScenario("case6");
    }

    @Test
    public void testCase7() throws Exception {
        this.testScenario("case7");
    }

    @Test
    public void testCase8() throws Exception {
        this.testScenario("case8");
    }

    @Test
    public void testCase9() throws Exception {
        this.testScenario("case9");
    }

    @Test
    public void testCase10() throws Exception {
        this.testScenario("case10");
    }

    @Test
    public void testCase11() throws Exception {
        this.testScenario("case11");
    }

    @Test
    public void testCase12() throws Exception {
        this.testScenario("case12");
    }

    @Test
    public void testResell1() throws Exception {
        this.testScenario("resell1", "d803addf-2538-455f-96b8-0e351417208d");
    }

    @Test
    public void testResell2() throws Exception {
        this.testScenario("resell2", "2184bcfa-b9b0-440a-8ee4-8fa3f94bfb57");
    }

    @Test
    public void testRefund1() throws Exception {
        this.testScenario("refund1");
    }

    @Test
    public void testRefund2() throws Exception {
        this.testScenario("refund2");
    }

    @Test
    public void testRefund3() throws Exception {
        this.testScenario("refund3");
    }

    @Test
    public void testRefund4() throws Exception {
        this.testScenario("refund4", "11773015-b955-40c3-9cfd-9702e7d6f202");
    }

    @Test
    public void testRefund5() throws Exception {
        this.testScenario("refund5");
    }

    @Test
    public void testRefund6() throws Exception {
        this.testScenario("refund6");
    }

    @Test
    public void testRefund7() throws Exception {
        this.testScenario("refund7");
    }

    @Test
    public void testReject1() throws Exception {
        this.testScenario("reject1");
    }

    @Test
    public void testVat1() throws Exception {
        this.testScenario("vat1");
    }

    private void testScenario(String scenario) throws Exception {
        this.testScenario(scenario, null);
    }

    private void testScenario(String scenario, String gdsAccountCtrUid) throws Exception {
        String responseFile = scenario + ".xml";
        String bookingFile = scenario + "_booking.xml";
        String resultFile = scenario + "_result.xml";
        String messagesFile = scenario + "_result_messages.xml";
        LoadReservationResponse response = this.getResponseFromFile(responseFile, LoadReservationResponse.class);
        EntityContainer bookingCtr = new EntityContainer();
        this.loadXSerializable(bookingFile, (XSerializable)bookingCtr);
        MessageContext ctx = new MessageContext();
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE, (Object)response.getReturn());
        ctx.putObject((Enum)IBusMidofficeContextKeys.GDS_ACCOUNT, this.createGdsAccount(gdsAccountCtrUid));
        ctx.putObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT, (Object)this.createSalesContext());
        this.buildProcessor.process(ctx);
        Reservation newReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION, (Object)newReservation);
        ctx.putObject((Enum)IBusMidofficeContextKeys.RESERVATION, ((BookingFile)bookingCtr.getEntity()).getReservations().get(0));
        ctx.putObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE, (Object)bookingCtr);
        this.updateProcessor.process(ctx);
        this.correctProcessor.process(ctx);
        ArrayList actualMessages = new ArrayList(ctx.getMessagesReadOnly());
        this.bookingTravellersProcessor.process(ctx);
        EntityContainer actualCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        BookingFile actual = (BookingFile)actualCtr.getEntity();
        BookingStreamHelper.getProductsStream((BookingFile)actual, HotelProduct.class).forEach(this::checkAdditionalServices);
        BookingStreamHelper.getProductsStream((BookingFile)actual, HotelProduct.class).forEach(this::checkTravellers);
        this.clearSomeFields(actual);
        BookingFile expected = new BookingFile();
        this.loadXSerializable(resultFile, (XSerializable)expected);
        this.clearSomeFields(expected);
        XModelAssert.assertEntityEquals((BaseEntity)expected, (BaseEntity)actual);
        List expectedMessages = this.loadXSerializableList(messagesFile);
        Assert.assertEquals((Object)MessageHelper.toString((Collection)expectedMessages), (Object)MessageHelper.toString(actualMessages));
    }

    private void checkAdditionalServices(HotelProduct hp) {
        List addServices = hp.getAdditionalServices();
        HotelProductHelper.getContractRelations((HotelProduct)hp).stream().map(BaseContractRelationData::getServiceData).map(ContractRelationServiceData::getDetalization).map(ContractRelationServiceDataDetalization::getAdditionalServices).filter(Objects::nonNull).map(ContractRelationAdditionalServicesDetalization::getAdditionalServices).flatMap(Collection::stream).forEach(crAddService -> addServices.stream().filter(as -> MiscUtil.equals((Object)as.getUid(), (Object)crAddService.getSource())).findFirst().orElseThrow(() -> Xeption.forDeveloper((String)"can't find additional service with uid {0}", (Object[])new Object[]{crAddService.getSource()})));
    }

    private void checkTravellers(HotelProduct hp) {
        List uids = hp.getTravellers().stream().map(BaseIdentity::getUid).collect(Collectors.toList());
        ArrayList lostUids = new ArrayList(uids);
        for (PassengerTypeReference tpt : hp.getTravellersPassengerTypes()) {
            if (lostUids.remove(tpt.getTravellerUid())) continue;
            throw Xeption.forDeveloper((String)"TravellersPassengerType has invalid travellerUid", (Object[])new Object[0]);
        }
        if (!lostUids.isEmpty()) {
            throw Xeption.forDeveloper((String)"TravellersPassengerTypes contains not all travellers", (Object[])new Object[0]);
        }
        lostUids = new ArrayList(uids);
        for (Room room : hp.getRooms()) {
            if (!lostUids.containsAll(room.getRoomTravellersUids())) {
                throw Xeption.forDeveloper((String)"RoomTravellersUids has invalid travellerUid", (Object[])new Object[0]);
            }
            lostUids.removeAll(room.getRoomTravellersUids());
        }
        if (!lostUids.isEmpty()) {
            throw Xeption.forDeveloper((String)"RoomTravellersUids contains not all travellers", (Object[])new Object[0]);
        }
        if (hp.getStatisticalData() != null) {
            lostUids = new ArrayList(uids);
            for (TravellerCostCodes tcc : hp.getStatisticalData().getTravellerCostCodes()) {
                if (lostUids.remove(tcc.getTraveller().getUid())) continue;
                throw Xeption.forDeveloper((String)"TravellerCostCode has invalid travellerUid", (Object[])new Object[0]);
            }
        }
    }
}

