/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class UpdateBookingFileTravellersProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityContainer bookingFileCtr = (EntityContainer)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.BOOKING_FILE);
        Boolean changed = (Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED);
        if (BooleanUtils.isNotTrue((Boolean)changed)) {
            return;
        }
        this.updateTravellers((BookingFile)bookingFileCtr.getEntity());
    }

    private void updateTravellers(BookingFile booking) {
        List bookingTravellers = booking.getTravellers();
        ArrayList notUsedTravellers = new ArrayList(bookingTravellers);
        for (BaseProduct bp : BookingHelper.getProducts((BookingFile)booking)) {
            boolean isHotel = bp instanceof HotelProduct;
            for (Traveller productTraveller : GeneralProductHelper.getTravellers((BaseProduct)bp)) {
                if (bookingTravellers.contains(productTraveller)) {
                    notUsedTravellers.remove(productTraveller);
                    continue;
                }
                if (!isHotel) continue;
                bookingTravellers.add(productTraveller);
            }
        }
        for (Traveller notUsedTraveller : notUsedTravellers) {
            bookingTravellers.remove(notUsedTraveller);
        }
    }
}

