/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.HotelProductUpdater;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;

public class UpdateCorteosHotelReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Reservation newReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION);
        boolean dontChangeProductWithShipment = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.SYNC_HOTEL_BOOKINGS_DONT_CHANGE_PRODUCT_WITH_SHIPMENT)));
        String importMessagesText = MessageHelper.toSimpleString((Collection)ctx.getMessagesReadOnly());
        ctx.clearMessages();
        if (TextUtil.nonBlank((String)importMessagesText)) {
            ctx.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0}: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430").parameters(new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}).details(importMessagesText).build());
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        boolean changed = this.updateReservation(reservation, newReservation, dontChangeProductWithShipment, messages);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED, (Object)changed);
        ctx.addMessages(messages);
    }

    private boolean updateReservation(Reservation reservation, Reservation newReservation, boolean dontChangeProductWithShipment, List<Message> messages) throws Exception {
        boolean changed = false;
        List<HotelProduct> oldProducts = HotelsReservationHelper.getFinalProducts(reservation);
        List<HotelProduct> newProducts = HotelsReservationHelper.getFinalProducts(newReservation);
        for (HotelProduct newProduct : newProducts) {
            HotelProduct product = oldProducts.size() == 1 ? oldProducts.get(0) : oldProducts.stream().filter(oldProduct -> {
                Room oldRoom = (Room)CollectionUtil.head((Iterable)oldProduct.getRooms());
                Room newRoom = (Room)CollectionUtil.head((Iterable)newProduct.getRooms());
                if (oldRoom == null || newRoom == null || !MiscUtil.isSameDay((Date)oldRoom.getCheckInDate(), (Date)newRoom.getCheckInDate()) || !MiscUtil.isSameDay((Date)oldRoom.getCheckOutDate(), (Date)newRoom.getCheckOutDate())) {
                    return false;
                }
                Traveller oldTraveller = (Traveller)CollectionUtil.head((Iterable)oldProduct.getTravellers());
                Traveller newTraveller = (Traveller)CollectionUtil.head((Iterable)newProduct.getTravellers());
                return oldTraveller != null && newTraveller != null && TextUtil.isSame((String)oldTraveller.getName(), (String)newTraveller.getName(), (boolean)true);
            }).findFirst().orElseThrow(() -> Xeption.forEndUser((String)("\u041d\u0435 \u0443\u0434\u0430\u043b\u043e\u0441\u044c \u043d\u0430\u0439\u0442\u0438 \u043f\u043e\u0434\u0445\u043e\u0434\u044f\u0449\u0438\u0439 \u043f\u0440\u043e\u0434\u0443\u043a\u0442 \u0432 Corteos \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 \u0438\u0437 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430 " + ProductHandler.of((BaseProduct)newProduct).generateProductName((BaseProduct)newProduct)), (Object[])new Object[0]));
            EntityReference agent = product.getCashier();
            if (product.getStatisticalData() == null) {
                product.setStatisticalData(new StatisticalData());
            }
            ArrayList travellerCostCodes = new ArrayList(product.getStatisticalData().getTravellerCostCodes());
            boolean updated = new HotelProductUpdater(product, newProduct, messages).setDontChangeProductWithShipment(dontChangeProductWithShipment).update();
            product.setReservation(reservation);
            if (agent != null) {
                product.setCashier(agent);
            }
            if (!travellerCostCodes.isEmpty()) {
                product.getStatisticalData().getTravellerCostCodes().clear();
                product.getStatisticalData().getTravellerCostCodes().addAll(travellerCostCodes);
            }
            if (updated) {
                changed = true;
            }
            oldProducts.remove(product);
        }
        reservation.getGdsNameInfo().getSystemInfos().clear();
        reservation.getGdsNameInfo().getSystemInfos().addAll(newReservation.getGdsNameInfo().getSystemInfos());
        return changed;
    }
}

