/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.syncBooking;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.helpers.vat.hotel.HotelProductVatFiller;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsReservationHelper;
import com.gridnine.xtrip.server.hotels2.ibus.syncBooking.HotelProductUpdater;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.BooleanUtils;

public class UpdateHotelReservationProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        Reservation reservation = (Reservation)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.RESERVATION);
        Reservation newReservation = (Reservation)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION);
        boolean dontChangeProductWithShipment = BooleanUtils.isTrue((Boolean)((Boolean)ctx.getObject((Enum)IBusHotelsContextKeys.SYNC_HOTEL_BOOKINGS_DONT_CHANGE_PRODUCT_WITH_SHIPMENT)));
        String importMessagesText = MessageHelper.toSimpleString((Collection)ctx.getMessagesReadOnly());
        ctx.clearMessages();
        if (TextUtil.nonBlank((String)importMessagesText)) {
            ctx.addMessage(MessagesHelper.MessageBuilder.of((MessageType)MessageType.MESSAGE).key("\u0411\u0440\u043e\u043d\u0438\u0440\u043e\u0432\u0430\u043d\u0438\u0435 {0}: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u043a\u0430 \u043e\u0442\u0432\u0435\u0442\u0430 \u0430\u0433\u0440\u0435\u0433\u0430\u0442\u043e\u0440\u0430").parameters(new Object[]{CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)}).details(importMessagesText).build());
        }
        ArrayList<Message> messages = new ArrayList<Message>();
        boolean changed = this.updateReservation(reservation, newReservation, dontChangeProductWithShipment, messages);
        ctx.putObject((Enum)IBusHotelsContextKeys.HOTELS_RESERVATION_CHANGED, (Object)changed);
        ctx.addMessages(messages);
    }

    private boolean updateReservation(Reservation reservation, Reservation newReservation, boolean dontChangeProductWithShipment, List<Message> messages) throws Exception {
        boolean changed = false;
        List<HotelProduct> oldProducts = HotelsReservationHelper.getFinalProducts(reservation);
        List<HotelProduct> newProducts = HotelsReservationHelper.getFinalProducts(newReservation);
        this.updateTravellerProfiles(oldProducts, newProducts, (EntityReference<Organization>)reservation.getBookingFile().getCustomerProfile());
        ArrayList<HotelProduct> addedProducts = new ArrayList<HotelProduct>();
        for (HotelProduct newProduct : newProducts) {
            HotelProduct product = HotelsReservationHelper.findProduct(oldProducts, newProduct);
            if (product == null) {
                BookingHelper.addProduct((Reservation)reservation, (BaseProduct)newProduct);
                HotelsHelper.updateProductSystemNumber(newProduct);
                messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}", (Object[])new Object[]{HotelsReservationHelper.getCaption(newProduct)}));
                if (newProduct.getStatus() == ProductStatus.REFUND) {
                    HotelProduct sale = newProduct.getPreviousProduct();
                    sale.setSystemNumber(newProduct.getSystemNumber());
                    BookingHelper.addProduct((Reservation)reservation, (BaseProduct)sale);
                    addedProducts.add(sale);
                }
                addedProducts.add(newProduct);
                changed = true;
                continue;
            }
            boolean updated = new HotelProductUpdater(product, newProduct, messages).setDontChangeProductWithShipment(dontChangeProductWithShipment).update();
            if (updated) {
                changed = true;
            }
            oldProducts.remove(product);
        }
        for (HotelProduct oldProduct : oldProducts) {
            List roomIds = oldProduct.getRooms().stream().map(HotelsReservationHelper::getRoomId).filter(Objects::nonNull).collect(Collectors.toList());
            if (oldProduct.getStatus() != ProductStatus.SELL) {
                throw Xeption.forDeveloper((String)"\u0414\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} ({1}) \u043d\u0435 \u043f\u0440\u0438\u0448\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435.", (Object[])new Object[]{HotelsReservationHelper.getCaption(oldProduct), roomIds});
            }
            HotelProduct refund = new HotelProduct();
            try {
                HotelProductHelper.copy((HotelProduct)oldProduct, (HotelProduct)refund, (boolean)false);
            }
            catch (Exception e) {
                throw Xeption.forDeveloper((String)"failed copy hotel product", (Throwable)e, (Object[])new Object[0]);
            }
            refund.setStatus(ProductStatus.REFUND);
            HotelsReservationHelper.relateProducts(oldProduct, refund);
            reservation.getProducts().add(refund);
            messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0414\u043e\u0431\u0430\u0432\u043b\u0435\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {0}, \u0442\u0430\u043a \u043a\u0430\u043a \u043d\u0435 \u043f\u0440\u0438\u0448\u043b\u0438 \u0434\u0430\u043d\u043d\u044b\u0435 \u0434\u043b\u044f \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {1} ({2})", (Object[])new Object[]{HotelsReservationHelper.getCaption(refund), HotelsReservationHelper.getCaption(oldProduct), roomIds}));
            HotelProduct relatedProduct = this.findRelatedProduct(refund, addedProducts);
            if (relatedProduct != null) {
                HotelProduct newRefund = relatedProduct.getNextProduct();
                if (newRefund != null) {
                    if (!newRefund.getPenalties().isEmpty()) {
                        refund.getPenalties().addAll(newRefund.getPenalties());
                        messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u0423 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {0} \u043e\u0431\u043d\u043e\u0432\u043b\u0435\u043d\u0430 \u0438\u043d\u0444\u043e\u0440\u043c\u0430\u0446\u0438\u044f \u043f\u043e \u0448\u0442\u0440\u0430\u0444\u0430\u043c \u0438\u0437 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0430 {1}", (Object[])new Object[]{HotelsReservationHelper.getCaption(refund), HotelsReservationHelper.getCaption(newRefund)}));
                    }
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041f\u0440\u043e\u0434\u0443\u043a\u0442\u044b {0}, {1} \u0443\u0434\u0430\u043b\u0435\u043d\u044b, \u0442\u0430\u043a \u043a\u0430\u043a \u0443\u0436\u0435 \u0441\u0443\u0449\u0435\u0441\u0442\u0432\u0443\u044e\u0442 \u0430\u043d\u0430\u043b\u043e\u0433\u0438\u0447\u043d\u044b\u0435 {2}, {3}", (Object[])new Object[]{HotelsReservationHelper.getCaption(relatedProduct), HotelsReservationHelper.getCaption(newRefund), HotelsReservationHelper.getCaption(oldProduct), HotelsReservationHelper.getCaption(refund)}));
                    reservation.getProducts().remove(relatedProduct);
                    reservation.getProducts().remove(newRefund);
                } else {
                    HotelsReservationHelper.relateProducts(refund, relatedProduct);
                    messages.add(SystemHelper.createMessage((MessageType)MessageType.MESSAGE, (String)"\u041a \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u0443 {0} \u043f\u0440\u0438\u0432\u044f\u0437\u0430\u043d \u043f\u0440\u043e\u0434\u0443\u043a\u0442 {1}", (Object[])new Object[]{HotelsReservationHelper.getCaption(refund), HotelsReservationHelper.getCaption(relatedProduct)}));
                    new HotelProductUpdater(refund, relatedProduct, new ArrayList<Message>()).updateTravellers();
                }
            }
            HotelProductVatFiller.updateVat((HotelProduct)refund);
            HotelProductHelper.updateFops((HotelProduct)refund);
            changed = true;
        }
        return changed;
    }

    protected void updateTravellerProfiles(List<HotelProduct> oldProducts, List<HotelProduct> newProducts, EntityReference<Organization> clientRef) {
    }

    private HotelProduct findRelatedProduct(HotelProduct refundProduct, List<HotelProduct> addedProducts) {
        List sameProducts = addedProducts.stream().filter(hp -> hp.getStatus() == ProductStatus.SELL).filter(hp -> this.hasSameTravellers(refundProduct, (HotelProduct)hp)).collect(Collectors.toList());
        return sameProducts.size() == 1 ? (HotelProduct)sameProducts.get(0) : null;
    }

    private boolean hasSameTravellers(HotelProduct hpOld, HotelProduct hpNew) {
        ArrayList travellersOld = new ArrayList(hpOld.getTravellers());
        ArrayList travellersNew = new ArrayList(hpNew.getTravellers());
        Iterator itNew = travellersNew.iterator();
        while (itNew.hasNext()) {
            Traveller travellerNew = (Traveller)itNew.next();
            Traveller travellerOld = (Traveller)CollectionUtil.find(travellersOld, (Object)travellerNew, HotelProductUpdater::isSameTraveller);
            if (travellerOld == null) {
                return false;
            }
            itNew.remove();
            travellersOld.remove(travellerOld);
        }
        return travellersOld.isEmpty() && travellersNew.isEmpty();
    }
}

