/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.tasks;

import com.gridnine.hotels.web.ws.GeoLocationExtInfo;
import com.gridnine.hotels.web.ws.TranslationEntry;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.util.GeoDistanceUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Hotels2TasksHelper {
    public static void addMessageToCallback(LongRunningTaskCallback callback, String message, Object ... parameters) {
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.MESSAGE, (String)message, (Object[])parameters));
    }

    public static void addWarningToCallback(LongRunningTaskCallback callback, String message) {
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)message, (Object[])new Object[0]));
    }

    public static void addErrorToCallback(LongRunningTaskCallback callback, String message, Throwable e, Object ... parameters) {
        callback.addEvent(null, MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)message, (Throwable)e, (Object[])parameters));
    }

    public static String getGeoLocationCodePrefix(LocationType locationType) {
        if (locationType == LocationType.CITY) {
            return null;
        }
        if (locationType == LocationType.AIRPORT) {
            return "airport";
        }
        if (locationType == LocationType.STATION) {
            return "station";
        }
        if (locationType == LocationType.REGION) {
            return "region";
        }
        if (locationType == LocationType.DISTRICT) {
            return "dictrict";
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static GeoLocation findGeoLocationByParams(GeoLocationExtInfo locationInfo, GeoLocationExtInfo parentLocationInfo, LocationType type, String countryCode) {
        if (locationInfo.getTranslations().isEmpty()) {
            return null;
        }
        names = locationInfo.getTranslations().stream().map((Function<TranslationEntry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lcom/gridnine/hotels/web/ws/TranslationEntry;)Ljava/lang/String;)()).collect(Collectors.toList());
        parentTranslations = parentLocationInfo != null ? parentLocationInfo.getTranslations().stream().map((Function<TranslationEntry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Lcom/gridnine/hotels/web/ws/TranslationEntry;)Ljava/lang/String;)()).collect(Collectors.toList()) : new ArrayList<String>();
        namesParts = new HashSet<String>();
        geoLocationVariant = null;
        for (String name : names) {
            if (TextUtil.isBlank((String)name)) continue;
            split = name.split("[()]");
            namesParts.add(split[0].trim());
            if (split.length <= 1) continue;
            parentTranslations.add(split[1].trim());
            namesParts.add(name);
        }
        filteredLocations = DictionaryCache.get().search(GeoLocation.class, DictSearchCriterion.eq((String)GeoLocation.Property.type.name(), (Object)type)).stream().filter((Predicate<GeoLocation>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findGeoLocationByParams$0(java.lang.String com.gridnine.xtrip.common.model.dict.GeoLocation ), (Lcom/gridnine/xtrip/common/model/dict/GeoLocation;)Z)((String)countryCode)).collect(Collectors.toList());
        for (GeoLocation location : filteredLocations) {
            if (location.getTranslations().values().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findGeoLocationByParams$1(java.lang.String ), (Ljava/lang/String;)Z)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(namesParts))) ** GOTO lbl-1000
            if (location.getSpellVariants().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$findGeoLocationByParams$2(java.lang.String ), (Ljava/lang/String;)Z)()).anyMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, contains(java.lang.Object ), (Ljava/lang/String;)Z)(namesParts))) lbl-1000:
            // 2 sources

            {
                v0 = true;
            } else {
                v0 = false;
            }
            if (!(isMatched = v0) || !Hotels2TasksHelper.isSameGeoLocationCoordinates(locationInfo, location) || !Hotels2TasksHelper.isSameParent(location, parentTranslations)) continue;
            if (geoLocationVariant == null) {
                geoLocationVariant = location;
                continue;
            }
            IncidentsLog.reportStackTrace((String)String.format("Found more than 1 geo locations for hotel aggregator location. Aggregator value: %s (%s) [%s];", new Object[]{locationInfo.getLocation().getCaption(), locationInfo.getLocation().getCode(), locationInfo.getLocation().getCountry().getCode()}));
            return null;
        }
        return geoLocationVariant;
    }

    private static boolean isSameParent(GeoLocation location, List<String> parentTranslations) {
        if (!parentTranslations.isEmpty() && location.getParent() != null) {
            GeoLocation parentGeoLocation = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
            return parentTranslations.stream().filter(tr -> !TextUtil.isBlank((String)tr)).anyMatch(val -> parentGeoLocation.getTranslations().values().contains(val)) || parentTranslations.stream().filter(tr -> !TextUtil.isBlank((String)tr)).anyMatch(val -> parentGeoLocation.getCodeVariants().values().contains(val));
        }
        return true;
    }

    private static boolean isSameGeoLocationCoordinates(GeoLocationExtInfo locationInfo, GeoLocation geoLocation) {
        if (locationInfo.getLocation() != null) {
            Double longitude = locationInfo.getLocation().getLongitude();
            Double latitude = locationInfo.getLocation().getLatitude();
            if (!(longitude == null || latitude == null || longitude == 0.0 && latitude == 0.0 || geoLocation.getLongitude() == 0.0 && geoLocation.getLatitude() == 0.0)) {
                double distance = GeoDistanceUtil.distance((double)latitude, (double)longitude, (double)geoLocation.getLatitude(), (double)geoLocation.getLongitude(), (char)'K');
                return distance < 10.0;
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$findGeoLocationByParams$2(String val) {
        return !TextUtil.isBlank((String)val);
    }

    private static /* synthetic */ boolean lambda$findGeoLocationByParams$1(String val) {
        return !TextUtil.isBlank((String)val);
    }

    private static /* synthetic */ boolean lambda$findGeoLocationByParams$0(String countryCode, GeoLocation location) {
        return MiscUtil.equals((Object)location.getCountry().getCode(), (Object)countryCode);
    }
}

