/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.tasks.SyncHotelBookings;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.server.ibus.components.DebugData;
import com.gridnine.xtrip.server.ibus.components.DebugHandler;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.log4j.LogManager;
import org.slf4j.LoggerFactory;

public class SyncBookingFilesDebugHandler
implements DebugHandler {
    private static final long serialVersionUID = -1536008867847747749L;
    private static final FastDateFormat DTF = FastDateFormat.getInstance((String)"yyyy-MM-dd-HH-mm-ss-SSS");
    private static final FastDateFormat FOLDER_DF = FastDateFormat.getInstance((String)"yyyy/MM/dd");

    public void configure(Map<String, String> properties) {
    }

    public boolean isTraceData(String processorId, MessageContext ctx) {
        return false;
    }

    public boolean isDebugDataDisabled(MessageContext ctx) {
        return !this.isDebugEnabled();
    }

    private boolean isDebugEnabled() {
        return LogManager.getLogger(SyncBookingFilesDebugHandler.class).isDebugEnabled();
    }

    public void save(DebugData data, MessageContext ctx) throws Exception {
        if (!this.isDebugEnabled()) {
            return;
        }
        Date date = new Date();
        File folder = new File(Environment.getTempFolder(), "ibus-syncHotels/" + FOLDER_DF.format(date));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        String fileName = String.format("%s-%s.xml", data.getRouteId().substring(data.getRouteId().lastIndexOf(":") + 1), DTF.format(date));
        try {
            FileUtils.writeByteArrayToFile((File)new File(folder, fileName), (byte[])data.buildDebugInfo(true).getBytes());
        }
        catch (Exception e) {
            try {
                if (e instanceof FileNotFoundException) {
                    Thread.sleep(1000L);
                    FileUtils.writeByteArrayToFile((File)new File(folder, fileName), (byte[])data.buildDebugInfo(true).getBytes());
                }
            }
            catch (Exception e2) {
                LoggerFactory.getLogger(this.getClass()).error("unable to save traces to " + fileName, (Throwable)e2);
            }
        }
    }
}

