/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.tasks.SyncHotelBookings;

import com.gridnine.xtrip.common.hotels2.helper.CommonHotelHelper;
import com.gridnine.xtrip.common.hotels2.model.HotelsSynchronizationTaskConfiguration;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.MainHotelProductIndex;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.server.hotels2.ibus.tasks.Hotels2TasksHelper;
import com.gridnine.xtrip.server.ibus.components.BaseTargetsProvider;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class SyncBookingFilesProvider
extends BaseTargetsProvider<EntityReference<BookingFile>> {
    public Collection<EntityReference<BookingFile>> getTargets(MessageContext ctx) throws Exception {
        LongRunningTaskCallback callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        HotelsSynchronizationTaskConfiguration configuration = (HotelsSynchronizationTaskConfiguration)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CONFIGURATION);
        SearchQuery query = new SearchQuery();
        List criterions = query.getCriteria().getCriterions();
        criterions.add(SearchCriterion.isNotEmpty((String)MainHotelProductIndex.Property.gdsAccount.name()));
        criterions.add(SearchCriterion.not((SearchCriterion)SearchCriterion.eq((String)MainHotelProductIndex.Property.provider.name(), (Object)HotelProvider.INTERNAL)));
        criterions.add(SearchCriterion.ge((String)MainHotelProductIndex.Property.hotelCheckOutDate.name(), (Object)new Date()));
        criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)MainHotelProductIndex.Property.excludedFromAutoSync.name(), null), SearchCriterion.eq((String)MainHotelProductIndex.Property.excludedFromAutoSync.name(), (Object)Boolean.FALSE)}));
        criterions.add(SearchCriterion.not((SearchCriterion)SearchCriterion.in((String)MainHotelProductIndex.Property.status.name(), (Object[])CommonHotelHelper.IGNORE_SYNC_STATUSES.toArray())));
        if (configuration.isRequested()) {
            criterions.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)MainHotelProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.REQUEST), SearchCriterion.eq((String)MainHotelProductIndex.Property.hasAdditionalServiceOnRequest.name(), (Object)Boolean.TRUE)}));
        } else {
            criterions.add(SearchCriterion.eq((String)MainHotelProductIndex.Property.reservationStatus.name(), (Object)ReservationStatus.ISSUED));
            criterions.add(SearchCriterion.not((SearchCriterion)SearchCriterion.eq((String)MainHotelProductIndex.Property.hasAdditionalServiceOnRequest.name(), (Object)Boolean.TRUE)));
        }
        query.getPreferredProperties().add(MainHotelProductIndex.Property.bookingNumber.name());
        List indexes = EntityStorage.get().search(MainHotelProductIndex.class, query).getData();
        Set<EntityReference<BookingFile>> bookingFiles = indexes.stream().map(MainHotelProductIndex::getSource).collect(Collectors.toSet());
        Hotels2TasksHelper.addMessageToCallback(callback, "\u041d\u0430\u0439\u0434\u0435\u043d\u043e {0} \u0437\u0430\u043a\u0430\u0437\u043e\u0432", bookingFiles.size());
        return bookingFiles;
    }
}

