/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.tasks.getCountries;

import com.gridnine.hotels.web.ws.CodeEntry;
import com.gridnine.hotels.web.ws.CodeSystem;
import com.gridnine.hotels.web.ws.CountryDictionary;
import com.gridnine.hotels.web.ws.CountryInfo;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.tasks.Hotels2TasksHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.stream.Collectors;

public class GetCountriesResponseProcessor
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        CountryDictionary response = (CountryDictionary)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        LongRunningTaskCallback callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        this.processCountries(response.getCountries(), callback);
    }

    private void processCountries(CountryDictionary.Countries aggregatorCountries, LongRunningTaskCallback callback) throws Exception {
        if (aggregatorCountries == null) {
            Hotels2TasksHelper.addMessageToCallback(callback, "No countries received from aggregator", new Object[0]);
            callback.updateProgress((byte)100);
            return;
        }
        int updatedCountries = 0;
        for (int i = 0; i < aggregatorCountries.getCountry().size(); ++i) {
            if (callback.isToBeStopped()) {
                Hotels2TasksHelper.addMessageToCallback(callback, "Task is interrupted", new Object[0]);
                return;
            }
            CountryInfo countryInfo = (CountryInfo)aggregatorCountries.getCountry().get(i);
            Country country = this.searchMidofficeCountry(countryInfo);
            if (country == null) {
                IncidentsLog.reportStackTrace((String)String.format("Missing country in dictionary: Codes: %s; Names: %s", countryInfo.getCodes().stream().map(codeEntry -> codeEntry.getSystem().name() + ":" + codeEntry.getCode()).collect(Collectors.joining(", ")), countryInfo.getTranslations().stream().map(translationEntry -> translationEntry.getLang() + ":" + translationEntry.getValue()).collect(Collectors.joining(", "))));
                continue;
            }
            boolean isUpdated = this.updateMidofficeCountry(country, countryInfo, callback);
            if (isUpdated) {
                ++updatedCountries;
            }
            byte progress = (byte)(100 * i / aggregatorCountries.getCountry().size());
            if (i % 10 != 0) continue;
            callback.updateProgress(progress);
        }
        String message = String.format("Countries synchronization finished, total countries: %s, updated countries: %s", aggregatorCountries.getCountry().size(), updatedCountries);
        Hotels2TasksHelper.addMessageToCallback(callback, message, new Object[0]);
    }

    private Country searchMidofficeCountry(CountryInfo countryInfo) {
        for (CodeEntry entry : countryInfo.getCodes()) {
            DictionaryReference<Country> countryRef = HotelsBaseHelper.resolveNativeCode(Country.class, entry.getCode());
            Country resolve = (Country)DictHelper.resolve(countryRef);
            if (resolve == null) continue;
            return resolve;
        }
        return null;
    }

    private boolean updateMidofficeCountry(Country country, CountryInfo countryInfo, LongRunningTaskCallback callback) throws Exception {
        String newCode = countryInfo.getCodes().stream().filter(codeEntry -> codeEntry.getSystem() == CodeSystem.SYSTEM).map(CodeEntry::getCode).findFirst().orElse(null);
        if (TextUtil.isBlank((String)newCode)) {
            String message = String.format("%s doesn't have old aggregator code", this.countryToString(countryInfo));
            Hotels2TasksHelper.addWarningToCallback(callback, message);
        } else {
            String currCode = (String)country.getCodeVariants().get(com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name());
            if (!newCode.equals(currCode)) {
                if (TextUtil.nonBlank((String)currCode)) {
                    String message = String.format("%s had old aggregator code %s, new code = %s. Aggregator country: %s", country, currCode, newCode, this.countryToString(countryInfo));
                    Hotels2TasksHelper.addWarningToCallback(callback, message);
                }
                country.getCodeVariants().put(com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name(), newCode);
                country.setDataSource("HotelTask-getCountries");
                DictionaryStorage.get().save((BaseDictionary)country);
                return true;
            }
        }
        return false;
    }

    private String countryToString(CountryInfo country) {
        String result = country.getTranslations().stream().map(translation -> translation.getLang() + ": " + translation.getValue()).collect(Collectors.joining("; "));
        if (!country.getCodes().isEmpty()) {
            result = result + " (";
            result = result + country.getCodes().stream().map(code -> code.getSystem().name() + ": " + code.getCode()).collect(Collectors.joining("; "));
            result = result + ")";
        }
        return result;
    }
}

