/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.ibus.tasks.getGeoLocations;

import com.gridnine.hotels.web.ws.CodeEntry;
import com.gridnine.hotels.web.ws.CodeSystem;
import com.gridnine.hotels.web.ws.GeoLocationDictionary;
import com.gridnine.hotels.web.ws.GeoLocationExtInfo;
import com.gridnine.hotels.web.ws.GeoLocationInfo;
import com.gridnine.hotels.web.ws.TranslationEntry;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.system.IBusStandardContextKeys;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsBaseHelper;
import com.gridnine.xtrip.server.hotels2.ibus.tasks.Hotels2TasksHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.model.ibus.LongRunningTaskCallback;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GetGeoLocationsResponseProcessor
extends BaseProcessor {
    private LongRunningTaskCallback callback;
    private static final List<LocationType> supportedLocationTypes = Arrays.asList(LocationType.CITY, LocationType.AIRPORT, LocationType.DISTRICT, LocationType.REGION, LocationType.STATION);
    private static final List<com.gridnine.xtrip.common.model.dict.CodeSystem> supportedCodeSystems = Arrays.asList(com.gridnine.xtrip.common.model.dict.CodeSystem.IATA, com.gridnine.xtrip.common.model.dict.CodeSystem.CRT, com.gridnine.xtrip.common.model.dict.CodeSystem.ISO, com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR);

    public void process(MessageContext ctx) throws Exception {
        GeoLocationDictionary response = (GeoLocationDictionary)ctx.getMandatoryObject((Enum)IBusHotelsContextKeys.HOTELS_AGGREGATOR_RESPONSE);
        this.callback = (LongRunningTaskCallback)ctx.getMandatoryObject((Enum)IBusStandardContextKeys.LONG_RUNNING_TASK_CALLBACK);
        this.processGeoLocations(response.getGeolocations());
    }

    private void processGeoLocations(GeoLocationDictionary.Geolocations locations) {
        if (locations == null) {
            Hotels2TasksHelper.addMessageToCallback(this.callback, "No locations received from aggregator", new Object[0]);
            this.callback.updateProgress((byte)100);
            return;
        }
        int totalCountUnsupported = 0;
        for (int i = 0; i < locations.getGeolocation().size(); ++i) {
            if (this.callback.isToBeStopped()) {
                Hotels2TasksHelper.addMessageToCallback(this.callback, "Task is interrupted", new Object[0]);
                return;
            }
            GeoLocationInfo locationInfo = (GeoLocationInfo)locations.getGeolocation().get(i);
            if (locationInfo.getLocation().getLocation() == null || locationInfo.getLocation().getLocation().getCountry() == null) continue;
            try {
                LocationType type = HotelsBaseHelper.convertGeoLocationTypeFromGds(locationInfo.getLocation().getLocation().getType());
                if (!supportedLocationTypes.contains(type)) {
                    Hotels2TasksHelper.addWarningToCallback(this.callback, String.format("Geo location with unsupported type - %s", locationInfo.getLocation().getLocation().getCaption()));
                    ++totalCountUnsupported;
                    continue;
                }
                boolean isHotelLocation = locationInfo.isHotelLocation();
                GeoLocation result = this.processGeoLocation(locationInfo, isHotelLocation, type);
                if (result != null) {
                    this.handleGeoLocationParent(locationInfo, result, isHotelLocation);
                    result.setDataSource("HotelTask-processGeoLocations");
                    DictionaryStorage.get().save((BaseDictionary)result);
                }
            }
            catch (Exception e) {
                Hotels2TasksHelper.addErrorToCallback(this.callback, "Failed to process location info " + locationInfo.getLocation().getLocation().getCaption(), e, new Object[0]);
            }
            byte progress = (byte)(100 * i / locations.getGeolocation().size());
            if (i % 10 != 0) continue;
            this.callback.updateProgress(progress);
        }
        String msg = String.format("\u0421\u0438\u043d\u0445\u0440\u043e\u043d\u0438\u0437\u0430\u0446\u0438\u044f \u0433\u0435\u043e\u0433\u0440\u0430\u0444\u0438\u0447\u0435\u0441\u043a\u0438\u0445 \u043f\u0443\u043d\u043a\u0442\u043e\u0432 \u0437\u0430\u0432\u0435\u0440\u0448\u0435\u043d\u0430: \u043e\u0431\u0440\u0430\u0431\u043e\u0442\u0430\u043d\u043e: %d, \u043f\u0440\u043e\u043f\u0443\u0449\u0435\u043d\u043e: %d", locations.getGeolocation().size() - totalCountUnsupported, totalCountUnsupported);
        Hotels2TasksHelper.addMessageToCallback(this.callback, msg, new Object[0]);
    }

    private GeoLocation processGeoLocation(GeoLocationInfo locationInfo, boolean isHotelLocation, LocationType type) {
        DictionaryReference<Country> country = HotelsBaseHelper.getDictReference(Country.class, locationInfo.getLocation().getLocation().getCountry().getCode());
        GeoLocation location = this.resolveGeoLocation(locationInfo.getLocation(), locationInfo.getFilteredParent(), type);
        if (location != null) {
            if (this.isGeoLocationUpdate(location, country)) {
                this.updateGeoLocation(locationInfo.getLocation(), location, isHotelLocation, type, country);
                return location;
            }
            return null;
        }
        return this.createGeoLocationFromAggregatorData(locationInfo.getLocation(), type, isHotelLocation, country);
    }

    private GeoLocation createGeoLocationFromAggregatorData(GeoLocationExtInfo locationInfo, LocationType type, boolean isHotelLocation, DictionaryReference<Country> country) {
        if (type == LocationType.AIRPORT) {
            IncidentsLog.reportStackTrace((String)String.format("Missing airport %s (%s) in dictionary", locationInfo.getLocation().getCaption(), locationInfo.getLocation().getCode()));
            return null;
        }
        GeoLocation location = new GeoLocation();
        location.getCodeVariants().putAll(locationInfo.getCodes().stream().filter(entry -> supportedCodeSystems.contains(HotelsBaseHelper.convertCodeSystemFromGds(entry.getSystem()))).collect(Collectors.toMap(entry -> HotelsBaseHelper.convertCodeSystemFromGds(entry.getSystem()).name(), CodeEntry::getCode)));
        String code = DictHelper.getCodeVariant((BaseDictionary)location, supportedCodeSystems);
        String codePrefix = Hotels2TasksHelper.getGeoLocationCodePrefix(type);
        if (codePrefix != null) {
            code = codePrefix + " " + code;
        }
        location.setCode(code);
        location.setType(type);
        location.setCountry(country);
        location.setLatitude(locationInfo.getLocation().getLatitude());
        location.setLongitude(locationInfo.getLocation().getLongitude());
        GetGeoLocationsResponseProcessor.updateTranslations(locationInfo, location);
        if (isHotelLocation) {
            location.setHotelLocation(AppConfiguration.get().isOnlineGdsEnabled());
        }
        String locationName = location.getTranslations().values().stream().findFirst().orElse("No name");
        Hotels2TasksHelper.addMessageToCallback(this.callback, String.format("Created new geo location with params: Name: %s (%s) Country: %s, Lat: %s, Long: %s", locationName, location.getCode(), location.getCountry(), location.getLatitude(), location.getLongitude()), new Object[0]);
        return location;
    }

    private void handleGeoLocationParent(GeoLocationInfo locationInfo, GeoLocation location, boolean isHotelLocation) throws Exception {
        if (location.getParent() != null || locationInfo.getFilteredParent() == null) {
            return;
        }
        GeoLocationExtInfo parentInfo = locationInfo.getFilteredParent();
        LocationType parentType = HotelsBaseHelper.convertGeoLocationTypeFromGds(parentInfo.getLocation().getType());
        if (supportedLocationTypes.contains(parentType)) {
            GeoLocation parentLocation = this.resolveGeoLocation(parentInfo, null, parentType);
            if (parentLocation == null) {
                DictionaryReference<Country> country = HotelsBaseHelper.resolveNativeCode(Country.class, parentInfo.getLocation().getCountry().getCode());
                parentLocation = Objects.requireNonNull(this.createGeoLocationFromAggregatorData(parentInfo, parentType, isHotelLocation, country));
                parentLocation.setDataSource("HotelTask-handleGeoLocationParent");
                DictionaryStorage.get().save((BaseDictionary)parentLocation);
            }
            if (location.getCountry() == null || location.getCountry().equals((Object)parentLocation.getCountry())) {
                location.setParent((DictionaryReference)parentLocation.toReference());
            } else {
                String msg = String.format("country of location code=%s (in midoffice) is %s and doesn't match country of it's parent (from aggregator) - %s(%s)", location.getCode(), location.getCountry().getCaption(), parentInfo.getLocation().getCountry().getCode(), parentInfo.getLocation().getCountry().getCodeSystem());
                IncidentsLog.reportStackTrace((String)msg);
                Hotels2TasksHelper.addWarningToCallback(this.callback, msg);
            }
        } else {
            Hotels2TasksHelper.addWarningToCallback(this.callback, String.format("Geo location with unsupported type - %s", parentInfo.getLocation().getCaption()));
        }
    }

    private void updateCityCode(GeoLocationExtInfo locationInfo, GeoLocation location) {
        CodeEntry codeEntry = locationInfo.getCodes().stream().filter(entry -> entry.getSystem() == CodeSystem.SYSTEM).findFirst().orElse(null);
        if (codeEntry != null && !TextUtil.isBlank((String)codeEntry.getCode())) {
            String oldValue = (String)location.getCodeVariants().get(com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name());
            if (!codeEntry.getCode().equals(oldValue)) {
                String locationName = location.getTranslations().values().stream().findFirst().orElse("No name");
                Hotels2TasksHelper.addMessageToCallback(this.callback, String.format("Updated code for location %s (%s). Old value: %s, new value: %s", locationName, location.getType(), oldValue, codeEntry.getCode()), new Object[0]);
                location.getCodeVariants().put(com.gridnine.xtrip.common.model.dict.CodeSystem.HOTEL_AGGREGATOR.name(), codeEntry.getCode());
            }
        }
    }

    public static void updateTranslations(GeoLocationExtInfo locationInfo, GeoLocation location) {
        if (locationInfo.getTranslations() != null) {
            for (TranslationEntry entry : locationInfo.getTranslations()) {
                String currValue;
                Locale locale;
                String language = entry.getLang();
                String value = entry.getValue();
                if (TextUtil.isBlank((String)language) || TextUtil.isBlank((String)value) || (locale = LocaleUtil.createNormalizedLocale((Locale)LocaleHelper.parse((String)entry.getLang()))) == null || !TextUtil.isBlank((String)(currValue = (String)MiscUtil.findByLocale((Map)location.getTranslations(), (Locale)locale)))) continue;
                location.getTranslations().put(locale, value);
            }
        }
    }

    private void updateGeoLocation(GeoLocationExtInfo locationInfo, GeoLocation location, boolean isHotelLocation, LocationType type, DictionaryReference<Country> country) {
        if (country != null && location.getCountry() == null) {
            location.setCountry(country);
        }
        if (type == LocationType.CITY) {
            this.updateCityCode(locationInfo, location);
        }
        if (0.0 == location.getLatitude() && 0.0 == location.getLongitude()) {
            location.setLatitude(locationInfo.getLocation().getLatitude());
            location.setLongitude(locationInfo.getLocation().getLongitude());
        }
        if (isHotelLocation) {
            location.setHotelLocation(AppConfiguration.get().isOnlineGdsEnabled());
        }
        GetGeoLocationsResponseProcessor.updateTranslations(locationInfo, location);
    }

    private boolean isGeoLocationUpdate(GeoLocation location, DictionaryReference<Country> country) {
        if (location.getCountry() != null && country != null && !location.getCountry().equals(country)) {
            String msg = String.format("Country in location %s not equals country in hotels aggregator: Location value : %s, Hotels aggregator value: %s", DictHelper.getTranslation((BaseDictionary)location, (Locale)LocaleHelper.EN_LOCALE, (boolean)false), location.getCountry().getCaption(), country.getCaption());
            IncidentsLog.reportStackTrace((String)msg);
            Hotels2TasksHelper.addWarningToCallback(this.callback, msg);
            return false;
        }
        return true;
    }

    private GeoLocation resolveGeoLocation(GeoLocationExtInfo locationInfo, GeoLocationExtInfo parentLocationInfo, LocationType type) {
        List codeEntries = locationInfo.getCodes();
        GeoLocation locationVariant = null;
        for (CodeEntry entry : codeEntries) {
            DictionaryReference<GeoLocation> reference = HotelsBaseHelper.resolveNativeCode(GeoLocation.class, entry.getCode());
            GeoLocation location = (GeoLocation)DictHelper.resolve(reference);
            if (location == null || location.getType() != type) continue;
            if (locationVariant == null) {
                locationVariant = location;
                continue;
            }
            if (locationVariant == location) continue;
            IncidentsLog.reportStackTrace((String)String.format("Found more than 1 locations for codes from hotel aggregator location: %s, codes: [%s]", locationInfo.getLocation().getCaption(), locationInfo.getCodes().stream().map(codeEntry -> codeEntry.getSystem() + ":" + codeEntry.getCode()).collect(Collectors.joining(", "))));
            return null;
        }
        return locationVariant != null ? locationVariant : this.searchGeoLocationByFields(locationInfo, parentLocationInfo, type);
    }

    private GeoLocation searchGeoLocationByFields(GeoLocationExtInfo locationInfo, GeoLocationExtInfo parentLocationInfo, LocationType type) {
        String countryCode = locationInfo.getLocation().getCountry().getCode();
        GeoLocation geoLocationVariant = Hotels2TasksHelper.findGeoLocationByParams(locationInfo, parentLocationInfo, type, countryCode);
        if (geoLocationVariant != null) {
            String locationName = geoLocationVariant.getTranslations().values().stream().findFirst().orElse("No name");
            Hotels2TasksHelper.addMessageToCallback(this.callback, String.format("Found similar location. Name: %s (%s), Country code: %s, Lat: %s, Long: %s Aggregator location params: Name: %s, Country code: %s, Lat: %s, Long: %s", locationName, geoLocationVariant.getCode(), geoLocationVariant.getCountry().getCode(), geoLocationVariant.getLatitude(), geoLocationVariant.getLongitude(), locationInfo.getLocation().getCaption(), countryCode, locationInfo.getLocation().getLatitude(), locationInfo.getLocation().getLongitude()), new Object[0]);
        }
        return geoLocationVariant;
    }
}

