/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.providers;

import com.gridnine.xtrip.common.hotels2.HotelAggregatorSettings;
import com.gridnine.xtrip.common.hotels2.model.BaseHotelParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelCard;
import com.gridnine.xtrip.common.hotels2.model.SearchHotelsParameters;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.aggregator.HotelAggregatorProvider;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProvider;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.Hotel;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.hotels2.ibus.helpers.HotelsHelper;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.licence2.AppConfiguration;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class HotelAggregatorServerProvider
implements HotelAggregatorProvider {
    private static final Integer DEFAULT_LIMIT = 50;

    public boolean isAggregatorEnable() {
        if (!AppConfiguration.get().isOnlineGdsEnabled()) {
            return false;
        }
        EntityContainer<HotelAggregatorSettings> settingsCtr = HotelsHelper.getHotelAggregatorSettings();
        return ((HotelAggregatorSettings)settingsCtr.getEntity()).isEnabled();
    }

    public Hotel searchHotelByAggregatorCode(String aggregatorCode, HotelProvider provider) {
        if (TextUtil.isBlank((String)aggregatorCode)) {
            return null;
        }
        if (provider != null && provider != HotelProvider.INTERNAL) {
            throw Xeption.forDeveloper((String)"expected INTERNAL provider", (Object[])new Object[0]);
        }
        return this.searchHotelByProviderCode(aggregatorCode, HotelProvider.INTERNAL);
    }

    public Hotel searchHotelByProviderCode(String providerCode, HotelProvider provider) {
        if (TextUtil.isBlank((String)providerCode) || provider == null) {
            return null;
        }
        HashMap<String, BaseHotelParameters> data = new HashMap<String, BaseHotelParameters>();
        BaseHotelParameters params = new BaseHotelParameters();
        params.setHotelNumber(providerCode);
        params.setProvider(provider);
        data.put(IBusHotelsContextKeys.HOTELS_BASE_HOTEL_PARAMS.name(), params);
        try {
            IntegrationBusFacade.get().processRouteSync("hotels2:get-hotel:get-hotel-route", data);
            HotelCard hotelCard = (HotelCard)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_CARD.name());
            Hotel result = HotelsHelper.convertToHotel(hotelCard);
            return result;
        }
        catch (Throwable t) {
            throw Xeption.forDeveloper((String)"error of search hotel with code {0} of provider {1}", (Throwable)t, (Object[])new Object[]{providerCode, provider});
        }
    }

    public List<Hotel> searchHotels(HotelProvider provider, DictionaryReference<Country> countryReference, DictionaryReference<GeoLocation> locationReference, String namePattern, Integer limit, Integer offset) {
        if (provider == null) {
            return Collections.emptyList();
        }
        namePattern = TextUtil.nonBlank((String)namePattern) ? namePattern.trim() : null;
        if (limit == null) {
            limit = DEFAULT_LIMIT;
        }
        countryReference = HotelAggregatorServerProvider.haveHotelAggregatorCode(countryReference) ? countryReference : null;
        locationReference = HotelAggregatorServerProvider.haveHotelAggregatorCode(locationReference) ? locationReference : null;
        try {
            SearchHotelsParameters params = new SearchHotelsParameters();
            params.setProvider(provider);
            params.setCountry(countryReference);
            params.setLocation(locationReference);
            params.setNamePattern(namePattern);
            params.setLimit(limit);
            params.setOffset(offset);
            HashMap<String, SearchHotelsParameters> data = new HashMap<String, SearchHotelsParameters>();
            data.put(IBusHotelsContextKeys.HOTELS_SEARCH_HOTELS_PARAMS.name(), params);
            IntegrationBusFacade.get().processRouteSync("hotels2:search-hotels:search-hotels-route", data);
            List hotels = (List)data.get(IBusHotelsContextKeys.HOTELS_HOTEL_SUMMARY_LIST.name());
            return hotels.stream().filter(Objects::nonNull).map(HotelsHelper::convertToHotel).filter(Objects::nonNull).collect(Collectors.toList());
        }
        catch (Throwable t) {
            String message = String.format("error of search hotel with provider %s, country %s, location %s, name pattern %s, limit %s and offset %s", provider, countryReference, locationReference, namePattern, limit, offset);
            throw Xeption.forDeveloper((String)message, (Throwable)t, (Object[])new Object[0]);
        }
    }

    static boolean haveHotelAggregatorCode(DictionaryReference<? extends BaseDictionary> ref) {
        if (ref == null) {
            return false;
        }
        BaseDictionary dict = DictionaryCache.get().resolveReference(ref);
        return dict != null && dict.getCodeVariants().containsKey(CodeSystem.HOTEL_AGGREGATOR.name());
    }
}

