/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.hotels2.tasks;

import com.gridnine.xtrip.common.hotels2.model.GetGeoLocationLogsParameters;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogs;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogsDeletedItem;
import com.gridnine.xtrip.common.hotels2.model.HotelAggregatorGeoLocationLogsMovedItem;
import com.gridnine.xtrip.common.hotels2.model.SynchronizeGeoLocationModificationsTaskConfiguration;
import com.gridnine.xtrip.common.l10n.model.L10nMessage;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.server.hotels2.ibus.IBusHotelsContextKeys;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.tasks.LongRunningTask;
import com.gridnine.xtrip.server.model.tasks.standard.BaseLongRunningTask;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.Date;
import java.util.HashMap;
import org.w3c.dom.Element;

public class SynchronizeGeoLocationModificationsTask
extends BaseLongRunningTask<SynchronizeGeoLocationModificationsTaskConfiguration> {
    private Date startDate;
    private Date endDate;

    public void configure(SynchronizeGeoLocationModificationsTaskConfiguration configuration) throws Exception {
        this.startDate = configuration.getStartDate();
        this.endDate = configuration.getEndDate();
    }

    public L10nMessage getDescription() {
        return L10nResourcesManager.createL10nMessage((String)"SynchronizeGeoLocationModificationsTask", (Object[])new Object[0]);
    }

    public void toXML(Element elm) throws Exception {
        XHelper.writeDate((Element)elm, (String)"startDate", (Date)this.startDate);
        XHelper.writeDate((Element)elm, (String)"endDate", (Date)this.endDate);
    }

    public void fromXML(Element elm) throws Exception {
        this.startDate = XHelper.readDate((Element)elm, (String)"startDate");
        this.endDate = XHelper.readDate((Element)elm, (String)"endDate");
    }

    protected void doJob(LongRunningTask.EventsCallback callback) throws Exception {
        GetGeoLocationLogsParameters params = new GetGeoLocationLogsParameters();
        params.setStartDate(this.startDate);
        params.setEndDate(this.endDate);
        HashMap<String, GetGeoLocationLogsParameters> data = new HashMap<String, GetGeoLocationLogsParameters>();
        data.put(IBusHotelsContextKeys.HOTELS_GET_GEOLOCATION_LOGS_PARAMS.name(), params);
        IntegrationBusFacade.get().processRouteSync("hotels2:get-geolocation-logs:get-logs-route", data);
        HotelAggregatorGeoLocationLogs logs = (HotelAggregatorGeoLocationLogs)data.get(IBusHotelsContextKeys.HOTELS_GET_GEOLOCATION_LOGS_RESULT.name());
        for (HotelAggregatorGeoLocationLogsMovedItem movedItem : logs.getMoved()) {
            for (GeoLocation geoLocation : DictionaryCache.get().lookup(GeoLocation.class, movedItem.getSystemCode(), new String[]{CodeSystem.HOTEL_AGGREGATOR.name()})) {
                geoLocation.getCodeVariants().put(CodeSystem.HOTEL_AGGREGATOR.name(), movedItem.getTargetSystemCode());
                geoLocation.setDataSource("SynchronizeGeoLocationModificationsTask");
                geoLocation.setVersionNotes("change hotel aggregator code");
                DictionaryStorage.get().save((BaseDictionary)geoLocation);
            }
        }
        for (HotelAggregatorGeoLocationLogsDeletedItem deletedItem : logs.getDeleted()) {
            for (GeoLocation geoLocation : DictionaryCache.get().lookup(GeoLocation.class, deletedItem.getSystemCode(), new String[]{CodeSystem.HOTEL_AGGREGATOR.name()})) {
                geoLocation.getCodeVariants().remove(CodeSystem.HOTEL_AGGREGATOR.name());
                if (!geoLocation.getCodeVariants().isEmpty()) {
                    geoLocation.setDataSource("SynchronizeGeoLocationModificationsTask");
                    geoLocation.setVersionNotes("delete hotel aggregator code");
                    DictionaryStorage.get().save((BaseDictionary)geoLocation);
                    callback.addEvent(null, SystemHelper.createMessage((MessageType)MessageType.WARNING, (String)String.format("\u0413\u0435\u043e\u043b\u043e\u043a\u0430\u0446\u0438\u044f \u0441 \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u043a\u0430\u0442\u043e\u0440\u043e\u043c %s \u043d\u0435 \u0431\u044b\u043b\u0430 \u0443\u0434\u0430\u043b\u0435\u043d\u0430, \u0442\u0430\u043a \u043a\u0430\u043a \u0435\u0441\u0442\u044c \u043a\u043e\u0434\u044b \u0432 \u0434\u0440\u0443\u0433\u0438\u0445 \u0441\u0438\u0441\u0442\u0435\u043c\u0430\u0445", geoLocation.getCode()), (Object[])new Object[0]));
                    continue;
                }
                DictionaryStorage.get().delete((BaseDictionary)geoLocation);
            }
        }
    }
}

