/*
 * Decompiled with CFR 0.152.
 */
package IBECORP1520;

import IBECORP1520.MOMRailwayStationsDictionaryReader;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public class InMobDataMapper {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    private static final File citiesJSON = new File("/home/tereschenkov/IBE RZD/InMobDictionaries/Cities.json");
    private static final File nodesJSON = new File("/home/tereschenkov/IBE RZD/InMobDictionaries/TransportNodes.json");
    private static final File log = new File("/home/tereschenkov/IBE RZD/InMobDictionaries/log.txt");
    private static final File logNoGeo = new File("/home/tereschenkov/IBE RZD/InMobDictionaries/logNoGeo.txt");
    @JsonProperty(value="Cities")
    private List<City> cities;
    @JsonProperty(value="TransportNodes")
    private List<TransportNode> nodes;
    private List<GeoLocation> geolocations = MOMRailwayStationsDictionaryReader.getGeolocations();

    public static void main(String[] args) throws Exception {
        InMobDataMapper reader = (InMobDataMapper)MAPPER.readValue(citiesJSON, InMobDataMapper.class);
        ArrayList<String> mainCitiesStation = new ArrayList<String>();
        HashMap<String, String> cityToAirCode = new HashMap<String, String>();
        HashMap<String, String> railToAirCode = new HashMap<String, String>();
        for (City city : reader.cities) {
            if (!TextUtil.isBlank((String)city.codeExpress)) {
                mainCitiesStation.add(city.codeExpress);
            }
            if (!TextUtil.isBlank((String)city.codeExpress) && !TextUtil.isBlank((String)city.code)) {
                railToAirCode.put(city.codeExpress, city.code);
            }
            if (TextUtil.isBlank((String)city.cityCode) || TextUtil.isBlank((String)city.code)) continue;
            cityToAirCode.put(city.cityCode, city.code);
        }
        reader = (InMobDataMapper)MAPPER.readValue(nodesJSON, InMobDataMapper.class);
        for (TransportNode node : reader.nodes) {
            if (!node.type.equals("Airport") || TextUtil.isBlank((String)node.cityCode) || TextUtil.isBlank((String)node.code)) continue;
            cityToAirCode.putIfAbsent(node.cityCode, node.code);
        }
        MOMRailwayStationsDictionaryReader.update(reader.mapStations(cityToAirCode, reader.mapMainCityStations(railToAirCode), mainCitiesStation));
    }

    private Optional<GeoLocation> getGeolocationReference(String code) {
        Optional<GeoLocation> first = this.geolocations.stream().filter(gl -> gl.getType().equals((Object)LocationType.CITY)).filter(gl -> gl.getCodeVariants().get("IATA") != null && ((String)gl.getCodeVariants().get("IATA")).equals(code) || gl.getCodeVariants().get("CRT") != null && ((String)gl.getCodeVariants().get("CRT")).equals(code)).findFirst();
        if (first.isPresent()) {
            return first;
        }
        return this.geolocations.stream().filter(gl -> gl.getCodeVariants().get("IATA") != null && ((String)gl.getCodeVariants().get("IATA")).equals(code) || gl.getCodeVariants().get("CRT") != null && ((String)gl.getCodeVariants().get("CRT")).equals(code)).findFirst();
    }

    private List<RailwayStation> mapMainCityStations(Map<String, String> railToAirCode) throws Exception {
        return MOMRailwayStationsDictionaryReader.getStations().stream().peek(st -> {
            String airCode = (String)railToAirCode.get(st.getCode());
            if (airCode != null) {
                this.getGeolocationReference(airCode).ifPresent(loc -> st.setGeoLocation((DictionaryReference)new GeoLocationReference(loc.getCode(), loc.toString(LocaleUtil.LOCALE_RU))));
                if (st.getGeoLocation() != null) {
                    st.setMainCityStation(Boolean.valueOf(true));
                }
            }
        }).collect(Collectors.toList());
    }

    private List<RailwayStation> mapStations(Map<String, String> cityToAirCode, List<RailwayStation> stations, List<String> mainStations) throws Exception {
        AtomicInteger counterLog = new AtomicInteger();
        AtomicInteger counterLogNoGeo = new AtomicInteger();
        FileOutputStream logger = new FileOutputStream(log);
        FileOutputStream loggerNoGeo = new FileOutputStream(logNoGeo);
        ArrayList<RailwayStation> railwayStations = new ArrayList<RailwayStation>();
        for (RailwayStation st : stations) {
            Optional<TransportNode> rs = this.nodes.stream().filter(n -> n.type.equals("RailwayStation")).filter(n -> n.code.equals(st.getCode())).findFirst();
            rs.ifPresent(r -> {
                st.setRating(Integer.valueOf(Integer.parseInt(r.popularity)));
                st.setByDefault(Boolean.valueOf(r.isActive));
                if (st.getByDefault() == null) {
                    st.setByDefault(Boolean.valueOf(false));
                }
                if (st.getMainCityStation() == null) {
                    st.setMainCityStation(Boolean.valueOf(false));
                }
                if (r.cityCode.equals("0")) {
                    return;
                }
                String airCode = (String)cityToAirCode.get(r.cityCode);
                if (airCode != null) {
                    if (st.getGeoLocation() == null) {
                        this.getGeolocationReference(airCode).ifPresent(loc -> {
                            loc = loc.getParent() == null ? loc : this.getGeolocationReference(loc.getParent().getCode()).get();
                            st.setGeoLocation((DictionaryReference)new GeoLocationReference(loc.getCode(), loc.toString(LocaleUtil.LOCALE_RU)));
                        });
                    }
                    if (!st.getMainCityStation().booleanValue()) {
                        st.setMainCityStation(Boolean.valueOf(mainStations.contains(st.getCode())));
                    }
                }
            });
            try {
                if (st.getGeoLocation() != null) {
                    ((OutputStream)logger).write(((String)((RailwayStationVendorCard)st.getVendorCards().get(0)).getTranslations().getValues().get(LocaleUtil.LOCALE_RU) + " (" + st.getCode() + ")  -->  " + st.getGeoLocation().getCaption() + " (" + st.getGeoLocation().getCode() + ")    \u041f\u043e\u0435\u0437\u0434 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f? " + st.getByDefault() + " \u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0430?: " + st.getMainCityStation() + " \u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c: " + st.getRating() + "\n").getBytes());
                    counterLog.getAndIncrement();
                } else {
                    ((OutputStream)loggerNoGeo).write(((String)((RailwayStationVendorCard)st.getVendorCards().get(0)).getTranslations().getValues().get(LocaleUtil.LOCALE_RU) + " (" + st.getCode() + ") \u041f\u043e\u0435\u0437\u0434 \u043e\u0441\u0442\u0430\u043d\u0430\u0432\u043b\u0438\u0432\u0430\u0435\u0442\u0441\u044f? " + st.getByDefault() + " \u0413\u043b\u0430\u0432\u043d\u0430\u044f \u0441\u0442\u0430\u043d\u0446\u0438\u044f \u0433\u043e\u0440\u043e\u0434\u0430?: " + st.getMainCityStation() + " \u041f\u043e\u043f\u0443\u043b\u044f\u0440\u043d\u043e\u0441\u0442\u044c: " + st.getRating() + "\n").getBytes());
                    counterLogNoGeo.getAndIncrement();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    ((OutputStream)logger).close();
                    ((OutputStream)loggerNoGeo).close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            railwayStations.add(st);
        }
        ((OutputStream)logger).write(("Total: " + counterLog.get()).getBytes());
        ((OutputStream)logger).close();
        ((OutputStream)loggerNoGeo).write(("Total: " + counterLogNoGeo.get()).getBytes());
        ((OutputStream)loggerNoGeo).close();
        return railwayStations;
    }

    static class TransportNode {
        @JsonProperty(value="CityId")
        String cityCode;
        @JsonProperty(value="Code")
        String code;
        @JsonProperty(value="Type")
        String type;
        @JsonProperty(value="PopularityIndex")
        String popularity;
        @JsonProperty(value="IsActive")
        boolean isActive;

        TransportNode() {
        }
    }

    static class City {
        @JsonProperty(value="CityId")
        String cityCode;
        @JsonProperty(value="Code")
        String code;
        @JsonProperty(value="ExpressCode")
        String codeExpress;

        City() {
        }
    }
}

