/*
 * Decompiled with CFR 0.152.
 */
package IBECORP1520;

import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStationVendorCard;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.UUIDGenerator;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class MOMRailwayStationsDictionaryReader {
    private static final String RAILWAY_DICTIONARY_URL = "config/server/setup/dict/com.gridnine.xtrip.common.model.dict.railway.RailwayStation.xml";
    private static final String RAILWAY_UPDATED_DICTIONARY_URL = "/home/tereschenkov/IBE RZD/InMobDictionaries/UpdatedStations.xml";
    private static final String GEOLOCATION_DICTIONARY_URL = "config/server/setup/dict/com.gridnine.xtrip.common.model.dict.GeoLocation.xml";

    public static List<RailwayStation> getStations(String url) throws Exception {
        Element root = MOMRailwayStationsDictionaryReader.getRootElement(new File(url));
        ArrayList<RailwayStation> stations = new ArrayList<RailwayStation>();
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            RailwayStation dict = (RailwayStation)RailwayStation.class.newInstance();
            dict.fromXML(objElm);
            if (TextUtil.isBlank((String)dict.getUid())) {
                dict.setUid(UUIDGenerator.generate((boolean)true).toString());
            }
            MOMRailwayStationsDictionaryReader.updateCards(dict);
            stations.add(dict);
        }
        return stations;
    }

    static List<RailwayStation> getStations() throws Exception {
        return MOMRailwayStationsDictionaryReader.getStations(RAILWAY_DICTIONARY_URL);
    }

    static List<GeoLocation> getGeolocations() throws Exception {
        Element root = MOMRailwayStationsDictionaryReader.getRootElement(new File(GEOLOCATION_DICTIONARY_URL));
        ArrayList<GeoLocation> locations = new ArrayList<GeoLocation>();
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            GeoLocation dict = (GeoLocation)GeoLocation.class.newInstance();
            dict.fromXML(objElm);
            locations.add(dict);
        }
        return locations;
    }

    static void update(List<RailwayStation> stations) throws Exception {
        File file = new File(RAILWAY_UPDATED_DICTIONARY_URL);
        try (FileOutputStream strm = new FileOutputStream(file);){
            Document result = DocumentBuilderHelper.newDocument();
            result.appendChild(result.createElement("objects"));
            Element rootElm = result.getDocumentElement();
            rootElm.setAttribute("totalCount", Integer.toString(stations.size()));
            for (RailwayStation st : stations) {
                XHelper.writeObject((Element)rootElm, (String)"object", (Object)st);
            }
            XUtil.newTransformer().transform(new DOMSource(result), new StreamResult(strm));
        }
    }

    public static Element getRootElement(File file) throws IOException, SAXException {
        Element root;
        try (InputStream strm = IoUtil.getResourceInputStream((File)file);){
            root = DocumentBuilderHelper.parse((InputSource)XUtil.createSource((InputStream)strm)).getDocumentElement();
        }
        return root;
    }

    private static void updateCards(RailwayStation station) {
        if (station.getVendorCards().isEmpty()) {
            return;
        }
        MOMRailwayStationsDictionaryReader.updateFromCards(station);
    }

    public static void updateFromCards(RailwayStation station) {
        MOMRailwayStationsDictionaryReader.clear(station);
        for (RailwayStationVendorCard vendorCard : MOMRailwayStationsDictionaryReader.getSortedVendorCards(station)) {
            MOMRailwayStationsDictionaryReader.updateFromCard(station, vendorCard);
        }
        MOMRailwayStationsDictionaryReader.removeRepeatedSpellVariants(station);
    }

    private static List<RailwayStationVendorCard> getSortedVendorCards(RailwayStation station) {
        return station.getVendorCards().stream().filter(Objects::nonNull).sorted(Comparator.comparingInt(s -> s.getType().ordinal())).collect(Collectors.toList());
    }

    private static void updateFromCard(RailwayStation station, RailwayStationVendorCard card) {
        if (card.getCountry() != null) {
            station.setCountry(card.getCountry());
        }
        if (card.getRoute() != null) {
            station.setRoute(card.getRoute());
        }
        for (Map.Entry translation : card.getTranslations().getValues().entrySet()) {
            if (translation.getKey() == null || TextUtil.isBlank((String)((String)translation.getValue()))) continue;
            if (station.getTranslations().containsKey(translation.getKey())) {
                station.getSpellVariants().add(station.getTranslations().get(translation.getKey()));
            }
            station.getTranslations().put(translation.getKey(), translation.getValue());
        }
        for (Map.Entry shortName : card.getShortNames().getValues().entrySet()) {
            if (shortName.getKey() == null || TextUtil.isBlank((String)((String)shortName.getValue()))) continue;
            if (station.getShortNames().containsKey(shortName.getKey())) {
                station.getSpellVariants().add(station.getShortNames().get(shortName.getKey()));
            }
            station.getShortNames().put(shortName.getKey(), shortName.getValue());
        }
        station.getSpellVariants().addAll(card.getSpellVariants());
    }

    private static void clear(RailwayStation station) {
        station.setCountry(null);
        station.setRoute(null);
        station.getTranslations().clear();
        station.getShortNames().clear();
        station.getSpellVariants().clear();
    }

    private static void removeRepeatedSpellVariants(RailwayStation station) {
        ArrayList spellVariants = new ArrayList(station.getSpellVariants());
        station.getSpellVariants().clear();
        for (String spellVariant : spellVariants) {
            if (CollectionUtil.contains(station.getTranslations().values(), (Object)spellVariant, (s1, s2) -> TextUtil.isSame((String)s1, (String)s2, (boolean)true)) || CollectionUtil.contains((Collection)station.getSpellVariants(), (Object)spellVariant, (s1, s2) -> TextUtil.isSame((String)s1, (String)s2, (boolean)true))) continue;
            station.getSpellVariants().add(spellVariant);
        }
    }
}

