/*
 * Decompiled with CFR 0.152.
 */
package XTR11540;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.File;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ImDictionaryReader {
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    public static final String USER_DIR = System.getProperty("user.dir");
    public static final String USER_HOME = System.getProperty("user.home");
    private static final String DIR_DICT = USER_HOME + "/Projects/midoffice/ibecorp/plugins/com.gridnine.xtrip.server.ibecorp.config/config/setup-ibecorp-config/dict";
    public static final String COUNTRY_DICTIONARY_URL = DIR_DICT + "/com.gridnine.xtrip.common.model.dict.Country.xml";
    public static final String GEOLOCATION_DICTIONARY_URL = DIR_DICT + "/com.gridnine.xtrip.common.model.dict.GeoLocation.xml";
    public static final String RAILWAY_STATION_URL = DIR_DICT + "/com.gridnine.xtrip.common.model.dict.railway.RailwayStation.xml";
    private File stationsJSON;
    private File citiesJSON;
    private File countriesJSON;
    private File regionsJSON;
    private String folderUrl;
    private String reportTemplatePath;
    @JsonProperty(value="TransportNodes")
    private List<JsonStation> stations;
    @JsonProperty(value="Cities")
    private List<JsonCity> cities;
    @JsonProperty(value="Regions")
    private List<JsonRegion> regions;
    @JsonProperty(value="Countries")
    private List<JsonCountry> countries;

    public String getFolderUrl() {
        return this.folderUrl;
    }

    public String getReportTemplatePath() {
        return this.reportTemplatePath;
    }

    public ImDictionaryReader() {
    }

    public ImDictionaryReader(String stationsFileName, String citiesFileName, String countriesFileName, String regionsFileName, String folderUrlName) {
        this.stationsJSON = new File(folderUrlName + "/" + stationsFileName);
        this.citiesJSON = new File(folderUrlName + "/" + citiesFileName);
        this.countriesJSON = new File(folderUrlName + "/" + countriesFileName);
        this.regionsJSON = new File(folderUrlName + "/" + regionsFileName);
        this.folderUrl = USER_DIR + "/" + folderUrlName;
        this.reportTemplatePath = USER_DIR + "/" + folderUrlName + "/%s.txt";
    }

    List<JsonStation> getStations() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.stationsJSON, ImDictionaryReader.class);
        return new ArrayList<JsonStation>(reader.stations);
    }

    List<JsonRegion> getRegions() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.regionsJSON, ImDictionaryReader.class);
        return new ArrayList<JsonRegion>(reader.regions);
    }

    List<JsonCity> getCities() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.citiesJSON, ImDictionaryReader.class);
        return new ArrayList<JsonCity>(reader.cities);
    }

    List<JsonCountry> getCountries() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.countriesJSON, ImDictionaryReader.class);
        return new ArrayList<JsonCountry>(reader.countries);
    }

    Map<String, String> getCityIdToCountryMap() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.citiesJSON, ImDictionaryReader.class);
        HashMap<String, String> cityToCountryMap = new HashMap<String, String>();
        for (JsonCity city : reader.cities) {
            cityToCountryMap.put(city.id, city.countryId);
        }
        return cityToCountryMap;
    }

    Map<String, String> getCityGuidToCountryMap() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.citiesJSON, ImDictionaryReader.class);
        HashMap<String, String> cityToCountryMap = new HashMap<String, String>();
        for (JsonCity city : reader.cities) {
            cityToCountryMap.put(city.guid, city.countryId);
        }
        return cityToCountryMap;
    }

    Map<String, String> getRegionToCountryMap() throws IOException {
        ImDictionaryReader reader = (ImDictionaryReader)MAPPER.readValue(this.regionsJSON, ImDictionaryReader.class);
        HashMap<String, String> regionToCountryMap = new HashMap<String, String>();
        for (JsonRegion region : reader.regions) {
            regionToCountryMap.put(region.id, region.countryId);
        }
        return regionToCountryMap;
    }

    Map<String, String> getCityToCodeMap() throws IOException {
        return this.getCities().stream().filter(v -> TextUtil.nonBlank((String)v.code)).collect(Collectors.toMap(k -> k.id, v -> v.code));
    }

    Map<String, String> getCityToLngNameRu() throws IOException {
        return this.getCities().stream().collect(Collectors.toMap(k -> k.id, v -> v.nameRu));
    }

    Map<String, String> getCityToLngNameEn() throws IOException {
        return this.getCities().stream().collect(Collectors.toMap(k -> k.id, v -> v.nameEn));
    }

    Map<String, String> getCityToExpressCodeMap() throws IOException {
        return this.getCities().stream().filter(v -> TextUtil.nonBlank((String)v.expressCode)).collect(Collectors.toMap(k -> k.id, v -> v.expressCode));
    }

    static class JsonCountry {
        @JsonProperty(value="CountryId")
        String id;
        @JsonProperty(value="Alpha2Code")
        String code;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="IsActive")
        boolean isActive;
        @JsonProperty(value="Updated")
        Timestamp updated;

        JsonCountry() {
        }
    }

    static class JsonRegion {
        @JsonProperty(value="RegionId")
        String id;
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="IsoCode")
        String isoCode;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="IsActive")
        boolean isActive;
        @JsonProperty(value="Updated")
        Timestamp updated;

        JsonRegion() {
        }
    }

    static class JsonCity {
        @JsonProperty(value="CityId")
        String id;
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="RegionId")
        String regionId;
        @JsonProperty(value="SysCode")
        String sysCode;
        @JsonProperty(value="ExpressCode")
        String expressCode;
        @JsonProperty(value="Code")
        String code;
        @JsonProperty(value="Guid")
        String guid;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="PopularityIndex")
        String popularityIndex;
        @JsonProperty(value="IsActive")
        boolean isActive;
        @JsonProperty(value="Updated")
        Timestamp updated;

        JsonCity() {
        }
    }

    static class JsonStation {
        @JsonProperty(value="TransportNodeId")
        String transportNodeId;
        @JsonProperty(value="CountryId")
        String countryId;
        @JsonProperty(value="RegionId")
        String regionId;
        @JsonProperty(value="CityId")
        String cityId;
        @JsonProperty(value="Code")
        String code;
        @JsonProperty(value="Guid")
        String guid;
        @JsonProperty(value="NameRu")
        String nameRu;
        @JsonProperty(value="NameEn")
        String nameEn;
        @JsonProperty(value="Type")
        String type;
        @JsonProperty(value="PopularityIndex")
        String popularity;
        @JsonProperty(value="Description")
        String description;
        @JsonProperty(value="IsActive")
        boolean isActive;
        @JsonProperty(value="IsVisible")
        boolean isVisible;
        @JsonProperty(value="IsSuburban")
        boolean isSuburban;
        @JsonProperty(value="Updated")
        Timestamp updated;
        @JsonProperty(value="UtcTimeOffset")
        String utcTimeOffset;

        JsonStation() {
        }
    }
}

