/*
 * Decompiled with CFR 0.152.
 */
package XTR11540;

import IBECORP1520.MOMRailwayStationsDictionaryReader;
import XTR11540.ImDictionaryReader;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.server.railway.test.RailwayTestBase;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.junit.Test;
import org.w3c.dom.Element;

public class UpdateBusStations
extends RailwayTestBase {
    static int stations = 0;
    static int citys = 0;
    static int citysEn = 0;
    static int citysRu = 0;
    static int railwayStations = 0;
    static int railwayStationsIm = 0;
    private static Map<String, String> CIS_COUNTRIES_ID_TO_CODE_MAP_IM;
    private static Map<String, Country> MOM_CODE_COUNTRY_MAP;
    private static Map<String, RailwayStation> MOM_EXPRESS_CODE_STATION_MAP;
    private static Map<String, GeoLocation> MOM_CODE_SITY_MAP;
    private static Map<String, String> CITY_CODE_MAP_IM;
    private static Map<String, String> CITY_EXPRESS_CODE_MAP_IM;
    Map<String, GeoLocation> MOM_LNG_SITY_NAME = new HashMap<String, GeoLocation>();
    Map<String, String> SITY_LNG_NAME_RU;
    Map<String, String> SITY_LNG_NAME_EN;

    @Test
    public void testStations() throws Exception {
        ImDictionaryReader reader = new ImDictionaryReader("TransportNodes.json", "Cities.json", "Countries.json", "Regions.json", "source-test/XTR11540/ImDictBus");
        List<ImDictionaryReader.JsonStation> imAllStations = reader.getStations();
        List<ImDictionaryReader.JsonCountry> imAllCountries = reader.getCountries();
        List<Country> countryMOM = UpdateBusStations.getDictionary(ImDictionaryReader.COUNTRY_DICTIONARY_URL, Country.class);
        MOM_CODE_COUNTRY_MAP = countryMOM.stream().collect(Collectors.toMap(BaseDictionary::getCode, v -> v));
        CIS_COUNTRIES_ID_TO_CODE_MAP_IM = UpdateBusStations.getCisIdToCodeMap(reader);
        List<RailwayStation> railwayStationMOM = UpdateBusStations.getDictionary(ImDictionaryReader.RAILWAY_STATION_URL, RailwayStation.class);
        MOM_EXPRESS_CODE_STATION_MAP = railwayStationMOM.stream().collect(Collectors.toMap(BaseDictionary::getCode, v -> v));
        CITY_EXPRESS_CODE_MAP_IM = reader.getCityToExpressCodeMap();
        List<GeoLocation> cityMOM = this.getTypeGeoLocation(UpdateBusStations.getDictionary(ImDictionaryReader.GEOLOCATION_DICTIONARY_URL, GeoLocation.class), LocationType.CITY);
        MOM_CODE_SITY_MAP = cityMOM.stream().collect(Collectors.toMap(k -> {
            String code = (String)k.getCodeVariants().get("IATA");
            if (TextUtil.nonBlank((String)code)) {
                return code;
            }
            code = (String)k.getCodeVariants().get("CRT");
            if (TextUtil.nonBlank((String)code)) {
                return code;
            }
            return null;
        }, v -> v, (n1, n2) -> n1));
        CITY_CODE_MAP_IM = reader.getCityToCodeMap();
        cityMOM.forEach(city -> city.getTranslations().values().forEach(lang -> this.MOM_LNG_SITY_NAME.put((String)lang, (GeoLocation)city)));
        this.SITY_LNG_NAME_RU = reader.getCityToLngNameRu();
        this.SITY_LNG_NAME_EN = reader.getCityToLngNameEn();
        this.actualizeStationCountry(imAllStations, reader);
        List<BusStation> newStations = imAllStations.stream().map(item -> this.createBusStation((ImDictionaryReader.JsonStation)item, (Map<String, String>)new HashMap<String, String>())).filter(Objects::nonNull).collect(Collectors.toList());
        System.out.println("stations: " + stations + ", citys: " + citys + ", citysRu: " + citysRu + ", citysEn: " + citysEn + ", railwayStations: " + railwayStations + ", railwayStationsIm: " + railwayStationsIm);
        this.editXmlDict(this.writeDictionary(newStations, "stations", reader), "BusStation", reader);
    }

    @Test
    public void testStationsIBECORP7141() throws Exception {
        ImDictionaryReader reader = new ImDictionaryReader("ImDictBus/TransportNodes.json", "ImDictBus/Cities.json", "ImDictBus/Countries.json", "ImDictBus/Regions.json", "source-test/IBECORP7141");
        List<ImDictionaryReader.JsonStation> imAllStations = reader.getStations();
        List<Country> countryMOM = UpdateBusStations.getDictionary(ImDictionaryReader.COUNTRY_DICTIONARY_URL, Country.class);
        MOM_CODE_COUNTRY_MAP = countryMOM.stream().collect(Collectors.toMap(BaseDictionary::getCode, v -> v));
        CIS_COUNTRIES_ID_TO_CODE_MAP_IM = UpdateBusStations.getCisIdToCodeMap(reader);
        List<RailwayStation> railwayStationMOM = UpdateBusStations.getDictionary(ImDictionaryReader.RAILWAY_STATION_URL, RailwayStation.class);
        MOM_EXPRESS_CODE_STATION_MAP = railwayStationMOM.stream().collect(Collectors.toMap(BaseDictionary::getCode, v -> v));
        CITY_EXPRESS_CODE_MAP_IM = reader.getCityToExpressCodeMap();
        List<GeoLocation> cityMOM = this.getTypeGeoLocation(UpdateBusStations.getDictionary(ImDictionaryReader.GEOLOCATION_DICTIONARY_URL, GeoLocation.class), LocationType.CITY);
        MOM_CODE_SITY_MAP = cityMOM.stream().collect(Collectors.toMap(k -> {
            String code = (String)k.getCodeVariants().get("IATA");
            if (TextUtil.nonBlank((String)code)) {
                return code;
            }
            code = (String)k.getCodeVariants().get("CRT");
            if (TextUtil.nonBlank((String)code)) {
                return code;
            }
            return null;
        }, v -> v, (n1, n2) -> n1));
        CITY_CODE_MAP_IM = reader.getCityToCodeMap();
        cityMOM.forEach(city -> city.getTranslations().values().forEach(lang -> this.MOM_LNG_SITY_NAME.put((String)lang, (GeoLocation)city)));
        this.SITY_LNG_NAME_RU = reader.getCityToLngNameRu();
        this.SITY_LNG_NAME_EN = reader.getCityToLngNameEn();
        this.actualizeStationCountry(imAllStations, reader);
        Map<String, String> existMomCodes = this.getExistMomBusStationCodes();
        List<BusStation> newStations = imAllStations.stream().map(item -> this.createBusStation((ImDictionaryReader.JsonStation)item, existMomCodes)).filter(Objects::nonNull).collect(Collectors.toList());
        this.editXmlDict(this.writeDictionary(newStations, "stations", reader), "NewBusStation", reader);
    }

    private Map<String, String> getExistMomBusStationCodes() throws Exception {
        HashMap<String, String> result = new HashMap<String, String>();
        Element root = MOMRailwayStationsDictionaryReader.getRootElement(new File(ImDictionaryReader.USER_HOME + "/Projects/midoffice/ibecorp/plugins/com.gridnine.xtrip.server.ibecorp/source-test/IBECORP7141/ExistBusStation.xml"));
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            Element[] codeVariants;
            String code = XmlUtil.getValue((Element)objElm, (String)"code");
            for (Element codeVariant : codeVariants = XmlUtil.getElements((Element)objElm, (String)"codeVariants")) {
                result.put(XmlUtil.getValue((Element)codeVariant, (String)"item"), code);
            }
        }
        return result;
    }

    private List<GeoLocation> getTypeGeoLocation(List<GeoLocation> dictionary, LocationType type) {
        return dictionary.stream().filter(Objects::nonNull).filter(geoLocation -> type.equals((Object)geoLocation.getType())).collect(Collectors.toList());
    }

    private Collection<? extends Country> updateCountry(List<Country> country, List<ImDictionaryReader.JsonCountry> imAllCountries) {
        List collect = country.stream().map(BaseDictionary::getCode).collect(Collectors.toList());
        return imAllCountries.stream().filter(jsonCountry -> !collect.contains(jsonCountry.code) && TextUtil.nonBlank((String)jsonCountry.nameRu) && TextUtil.nonBlank((String)jsonCountry.nameEn)).distinct().map(jsonCountry -> new Country((ImDictionaryReader.JsonCountry)jsonCountry){
            final /* synthetic */ ImDictionaryReader.JsonCountry val$jsonCountry;
            {
                this.val$jsonCountry = jsonCountry;
                this.setCode(this.val$jsonCountry.code);
                this.getTranslations().put(LocaleUtil.LOCALE_RU, this.val$jsonCountry.nameRu);
                this.getTranslations().put(LocaleUtil.LOCALE_EN, this.val$jsonCountry.nameEn);
                this.getCodeVariants().put("IATA", this.val$jsonCountry.code);
            }
        }).collect(Collectors.toList());
    }

    private File writeDictionary(List<BusStation> stations, String fileName, ImDictionaryReader reader) {
        String count = String.format("(%d)", stations.size());
        File file = new File(String.format(reader.getReportTemplatePath(), fileName + count));
        try (FileOutputStream output = new FileOutputStream(file);){
            ((OutputStream)output).write(XSUtil.toString(stations).getBytes());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return file;
    }

    private void editXmlDict(File file, String newFileName, ImDictionaryReader reader) {
        File log = new File(reader.getFolderUrl() + "/" + newFileName + ".xml");
        try (FileOutputStream output = new FileOutputStream(log);){
            Files.newBufferedReader(file.toPath()).lines().filter(line -> !line.contains("<uid>") && !line.contains("<notUpdatable>") && !line.contains("<created>") && !line.contains("<modified>") && !line.contains("<createdBy>") && !line.contains("<modifiedBy>")).forEach(line -> {
                try {
                    output.write((line + "\n").getBytes());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T extends BaseDictionary> List<T> getDictionary(String dir, Class<T> clazz) throws Exception {
        Element root = MOMRailwayStationsDictionaryReader.getRootElement(new File(dir));
        ArrayList<BaseDictionary> locations = new ArrayList<BaseDictionary>();
        for (Element objElm : XmlUtil.getElements((Element)root, (String)"object")) {
            BaseDictionary dict = (BaseDictionary)clazz.newInstance();
            dict.fromXML(objElm);
            locations.add(dict);
        }
        return locations;
    }

    private void actualizeStationCountry(List<ImDictionaryReader.JsonStation> stations, ImDictionaryReader reader) throws IOException {
        Map<String, String> imRegionToCountryMap = reader.getRegionToCountryMap();
        stations.stream().filter(st -> "0".equals(st.countryId) && !"0".equals(st.regionId)).forEach(st -> {
            st.countryId = imRegionToCountryMap.getOrDefault(st.regionId, "0");
        });
        Map<String, String> imCityIdToCountryMap = reader.getCityIdToCountryMap();
        stations.stream().filter(st -> "0".equals(st.countryId) && !"0".equals(st.cityId)).forEach(st -> {
            st.countryId = imCityIdToCountryMap.getOrDefault(st.cityId, "0");
        });
    }

    private static Map<String, String> getCisIdToCodeMap(ImDictionaryReader reader) throws IOException {
        List<ImDictionaryReader.JsonCountry> imAllCountries = reader.getCountries();
        HashMap<String, String> cisIdToCodeMap = new HashMap<String, String>();
        imAllCountries.forEach(c -> cisIdToCodeMap.put(c.id, c.code));
        return cisIdToCodeMap;
    }

    private BusStation createBusStation(ImDictionaryReader.JsonStation station, Map<String, String> existMomCodes) {
        if (!existMomCodes.isEmpty() && (existMomCodes.containsKey(station.code) || existMomCodes.containsValue(station.transportNodeId))) {
            return null;
        }
        ++stations;
        BusStation busStation = new BusStation();
        busStation.setCode(station.transportNodeId);
        busStation.getCodeVariants().put("INMOB", station.code);
        if (TextUtil.nonBlank((String)station.nameRu)) {
            busStation.getTranslations().put(LocaleUtil.LOCALE_RU, station.nameRu);
        }
        if (TextUtil.nonBlank((String)station.nameEn)) {
            busStation.getTranslations().put(LocaleUtil.LOCALE_EN, station.nameEn);
        }
        busStation.setActive(station.isActive);
        busStation.setVisible(station.isVisible);
        if (!station.countryId.equals("0")) {
            busStation.setCountry((DictionaryReference)MOM_CODE_COUNTRY_MAP.get(CIS_COUNTRIES_ID_TO_CODE_MAP_IM.get(station.countryId)).toReference());
        }
        if (!station.cityId.equals("0")) {
            GeoLocation sity;
            String lng;
            String expressCode;
            GeoLocation sity2;
            this.additionInfoForBusStations(station, busStation);
            String code = CITY_CODE_MAP_IM.get(station.cityId);
            if (TextUtil.nonBlank((String)code) && Objects.nonNull(sity2 = MOM_CODE_SITY_MAP.get(code)) && MiscUtil.equals((Object)sity2.getCountry(), (Object)busStation.getCountry())) {
                ++citys;
                busStation.setCity((DictionaryReference)sity2.toReference());
            }
            if (TextUtil.nonBlank((String)(expressCode = CITY_EXPRESS_CODE_MAP_IM.get(station.cityId)))) {
                RailwayStation railwayStation = MOM_EXPRESS_CODE_STATION_MAP.get(expressCode);
                if (Objects.nonNull(railwayStation) && MiscUtil.equals((Object)railwayStation.getCountry(), (Object)busStation.getCountry())) {
                    busStation.setRailwayStation((DictionaryReference)railwayStation.toReference());
                    ++railwayStations;
                }
                ++railwayStationsIm;
            }
            if (busStation.getCity() == null && TextUtil.nonBlank((String)(lng = this.SITY_LNG_NAME_RU.get(station.cityId))) && Objects.nonNull(sity = this.MOM_LNG_SITY_NAME.get(lng)) && MiscUtil.equals((Object)sity.getCountry(), (Object)busStation.getCountry())) {
                ++citysRu;
                ++citys;
                busStation.setCity((DictionaryReference)sity.toReference());
            }
            if (busStation.getCity() == null && TextUtil.nonBlank((String)(lng = this.SITY_LNG_NAME_EN.get(station.cityId))) && Objects.nonNull(sity = this.MOM_LNG_SITY_NAME.get(lng)) && MiscUtil.equals((Object)sity.getCountry(), (Object)busStation.getCountry())) {
                ++citysEn;
                ++citys;
                busStation.setCity((DictionaryReference)sity.toReference());
            }
        }
        return busStation;
    }

    private void additionInfoForBusStations(ImDictionaryReader.JsonStation station, BusStation busStation) {
        String lngEn;
        busStation.setImCityId(station.cityId);
        String lngRu = this.SITY_LNG_NAME_RU.get(station.cityId);
        if (TextUtil.nonBlank((String)lngRu)) {
            L10nStringHelper.setValue((L10nString)busStation.getCityName(), (String)lngRu, (Locale)LocaleUtil.LOCALE_RU);
        }
        if (TextUtil.nonBlank((String)(lngEn = this.SITY_LNG_NAME_EN.get(station.cityId)))) {
            L10nStringHelper.setValue((L10nString)busStation.getCityName(), (String)lngEn, (Locale)LocaleUtil.LOCALE_EN);
        }
    }
}

