/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp;

import com.gridnine.xtrip.common.ibecorp.rzd.RzdCommonHelper;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RailService;
import com.gridnine.xtrip.common.ibecorp.rzd.model.RzdTariff;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.midoffice.helper.CodeTranslator;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.railway.CompartmentType;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.BlankCategory;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayRoute;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.profile.Validator;
import com.gridnine.xtrip.common.railway.model.helpers.CommonRailwayHelper;
import com.gridnine.xtrip.common.railway.model.helpers.RailwayProductHelper;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.LocaleUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.ibecorp.model.cabinet.RailProductProxy;
import com.gridnine.xtrip.server.ibecorp.ufs.model.domain.SeatType;
import com.gridnine.xtrip.server.storage.DictionaryStorage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RzdHelper {
    private static final String ORG_RZD_CODE = "RZD";
    private static final Logger log = LoggerFactory.getLogger(RzdHelper.class);
    private static final CodeTranslator codeTranslator = new CodeTranslator(new String[]{CodeSystem.INMOB.name(), CodeSystem.EXPRESS.name()});
    private static final Map<CompartmentType, SeatType> ufsCompartmentTypeMap = new HashMap<CompartmentType, SeatType>();
    private static final Map<RailService, String> railServiceMap = new HashMap<RailService, String>();
    private static final String RZD_EMPTY_VALUE = "-";

    public static SeatType convertCompartmentTypeToUfs(CompartmentType value) {
        return ufsCompartmentTypeMap.get(value);
    }

    public static RailService getRailServiceByProviderCode(String providerCode) {
        RailService railService = (RailService)CollectionUtil.getKeyByValue(railServiceMap, (Object)providerCode);
        if (railService == null) {
            IncidentsLog.reportStackTrace((String)("Missing Rail service with provider code: " + providerCode));
        }
        return railService;
    }

    public static EntityReference<Organization> getRzdOrganization(GdsName gds) {
        EntityReference blankOwnerRef = CommonRailwayHelper.getBlankOwner((GdsName)gds);
        if (blankOwnerRef != null) {
            return blankOwnerRef;
        }
        EntityContainer ecOrg = EntityStorage.get().resolve(new EntityReference("organization-blankowner-RZD-9et6h2", Organization.class, null));
        if (ecOrg != null) {
            return ecOrg.toReference();
        }
        Organization org = new Organization();
        org.setCode(ORG_RZD_CODE);
        org.getShortName().getValues().put(new Locale("ru", "RU"), "\u041e\u0410\u041e \"\u0420\u0416\u0414\"");
        org.getFullName().getValues().put(new Locale("ru", "RU"), "\u041e\u0442\u043a\u0440\u044b\u0442\u043e\u0435 \u0430\u043a\u0446\u0438\u043e\u043d\u0435\u0440\u043d\u043e\u0435 \u043e\u0431\u0449\u0435\u0441\u0442\u0432\u043e \"\u0420\u043e\u0441\u0441\u0438\u0439\u0441\u043a\u0438\u0435 \u0436\u0435\u043b\u0435\u0437\u043d\u044b\u0435 \u0434\u043e\u0440\u043e\u0433\u0438\"");
        org.getTypes().add(OrganizationType.BLANK_OWNER);
        EntityContainer ctr = EntityContainer.create((BaseEntity)org);
        ctr.setUid("organization-blankowner-RZD-9et6h2");
        EntityStorage.get().save(ctr, false);
        return ctr.toReference();
    }

    public static DictionaryReference<RailwayStation> getStationRefByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        CodeTranslator translator = new CodeTranslator(new String[]{CodeSystem.EXPRESS.name()});
        return translator.resolveNativeCode(RailwayStation.class, code, false);
    }

    public static Validator findValidator(EntityReference<SalesPoint> salesPointRef, EntityReference<Organization> agencyRef, EntityReference<Organization> blankOwnerRef, EntityReference<Organization> supplierRef) {
        if (salesPointRef == null || agencyRef == null || blankOwnerRef == null || supplierRef == null) {
            return null;
        }
        EntityContainer ecSalesPoint = EntityStorage.get().resolve(salesPointRef);
        if (ecSalesPoint == null) {
            log.warn("can't resolve SalesPoint for Reference " + salesPointRef);
            return null;
        }
        for (Validator validator : ((SalesPoint)ecSalesPoint.getEntity()).getValidators()) {
            if (!agencyRef.equals((Object)validator.getAgency()) || !blankOwnerRef.equals((Object)validator.getBlankOwner()) || !supplierRef.equals((Object)validator.getSupplier())) continue;
            return validator;
        }
        return null;
    }

    public static DictionaryReference<BlankType> getBlankType(String code) throws Exception {
        BlankType blankType = (BlankType)DictionaryCache.get().findByCode(BlankType.class, code);
        if (blankType != null) {
            return blankType.toReference();
        }
        blankType = new BlankType();
        blankType.setCode(code);
        blankType.setName(code);
        blankType.setBlankOwner(RzdHelper.findFirstOrganizationByCode(ORG_RZD_CODE));
        blankType.setBlankCategory(BlankCategory.ETICKET);
        blankType.setCouponsCount(1);
        blankType.setProductCategory(ProductCategory.AIR);
        blankType.setDataSource("RzdHelper-getBlankType");
        DictionaryStorage.get().save((BaseDictionary)blankType);
        return blankType.toReference();
    }

    private static EntityReference<Organization> findFirstOrganizationByCode(String code) {
        List<OrganizationIndex> indexes = RzdHelper.findOrganizationsByCode(code);
        return indexes.isEmpty() ? null : indexes.get(0).getSource();
    }

    private static List<OrganizationIndex> findOrganizationsByCode(String code) {
        if (TextUtil.isBlank((String)code)) {
            return Collections.emptyList();
        }
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)OrganizationIndex.Property.code.name(), (Object)code));
        List indexes = EntityStorage.get().search(OrganizationIndex.class, query).getData();
        if (indexes.size() == 0) {
            return Collections.emptyList();
        }
        return indexes;
    }

    public static void writeFullTrainNumber(RailwaySegment segment, String fullTrainNumber) {
        if (fullTrainNumber == null) {
            return;
        }
        Matcher matcher = Pattern.compile("^\\d+").matcher(fullTrainNumber);
        if (matcher.find()) {
            String trainNumber = matcher.group();
            String slot = fullTrainNumber.substring(matcher.end());
            if (!TextUtil.isBlank((String)trainNumber)) {
                segment.setTrainNumber(trainNumber);
            }
            if (!TextUtil.isBlank((String)slot)) {
                segment.setSlot(slot);
            }
        } else {
            segment.setTrainNumber(fullTrainNumber);
        }
    }

    public static String modifyNameForGds(String name) {
        return RzdHelper.modifyNameForGds(name, false);
    }

    public static String modifyNameForGds(String name, boolean isMiddleName) {
        if (isMiddleName) {
            if (RZD_EMPTY_VALUE.equals(name)) {
                return name;
            }
            if (TextUtil.isBlank((String)name)) {
                return RZD_EMPTY_VALUE;
            }
        }
        return TextUtil.isBlank((String)name) ? name : name.replaceAll(" ", "");
    }

    public static String getEmptyValue() {
        return RZD_EMPTY_VALUE;
    }

    public static <D extends BaseDictionary> D findByCodeExt(Class<D> cls, String code) {
        Set lookup = DictionaryCache.get().lookup(cls, code, new String[0]);
        return (D)(lookup.isEmpty() ? null : (BaseDictionary)lookup.iterator().next());
    }

    public static DictionaryReference<RailwayRoute> getRoute(String code, String logInfo) {
        RailwayRoute route;
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        int ind = code.indexOf("/");
        String realCode = code;
        if (ind != -1) {
            realCode = code.substring(ind + 1);
        }
        if ((route = RzdHelper.findByCodeExt(RailwayRoute.class, realCode = realCode.trim())) == null) {
            log.error(String.format("can't find RailwayRoute with code %s (realCode=%s) for %s", code, realCode, logInfo));
            return null;
        }
        return route.toReference();
    }

    public static DictionaryReference<RailwayCarrier> getCarrier(String code) {
        return RzdHelper.getCarrier(code, null, null);
    }

    public static DictionaryReference<RailwayCarrier> getCarrier(String code, String logInfo) {
        return RzdHelper.getCarrier(code, null, logInfo);
    }

    public static DictionaryReference<RailwayCarrier> getCarrier(String code, String carrierInn, String logInfo) {
        RailwayCarrier railwayCarrier;
        if (TextUtil.isBlank((String)code)) {
            return null;
        }
        DictionaryReference carrier = codeTranslator.resolveNativeCode(RailwayCarrier.class, code, false, true);
        if (carrier == null) {
            log.error(String.format("can't find RailwayCarrier with code %s for %s", code, logInfo));
            return null;
        }
        if (!TextUtil.isBlank((String)carrierInn) && !carrierInn.equals((railwayCarrier = (RailwayCarrier)DictionaryCache.get().resolveReference(carrier)).getInn())) {
            try {
                railwayCarrier.setInn(carrierInn);
                railwayCarrier.setDataSource("RzdHelper-getCarrier");
                DictionaryStorage.get().save((BaseDictionary)railwayCarrier);
            }
            catch (Exception e) {
                log.error(String.format("can't save RailwayCarrier with inn %s for code %s", carrierInn, code), (Throwable)e);
            }
        }
        return carrier;
    }

    public static DictionaryReference<Principal> getPrincipal(String principalInn, String principalPhoneNumber) {
        return RzdHelper.getPrincipal(principalInn, principalPhoneNumber, null, null);
    }

    public static DictionaryReference<Principal> getPrincipalForKz(String principalBin, String serialNumber) {
        return RzdHelper.getPrincipal(null, null, principalBin, serialNumber);
    }

    private static DictionaryReference<Principal> getPrincipal(String principalInn, String principalPhoneNumber, String principalBin, String serialNumber) {
        Principal principal;
        if (TextUtil.isBlank((String)principalInn) && TextUtil.isBlank((String)principalBin)) {
            return null;
        }
        DictSearchCriterion criterion = TextUtil.nonBlank((String)principalInn) ? DictSearchCriterion.eq((String)Principal.Property.registrationId.name(), (Object)principalInn) : DictSearchCriterion.eq((String)Principal.Property.bin.name(), (Object)principalBin);
        Set principals = DictionaryCache.get().search(Principal.class, criterion);
        if (principals.size() > 1) {
            log.error(String.format("More than one principal have been found for (registrationId, bin) = (%s, %s)", principalInn, principalBin));
        }
        if ((principal = (Principal)principals.stream().findFirst().orElse(null)) != null) {
            boolean changed = false;
            if (TextUtil.nonBlank((String)principalPhoneNumber) && !principalPhoneNumber.equals(principal.getPhone())) {
                principal.setPhone(principalPhoneNumber);
                changed = true;
            }
            if (TextUtil.nonBlank((String)serialNumber) && !serialNumber.equals(principal.getVatSeriesNumber())) {
                principal.setVatSeriesNumber(serialNumber);
                changed = true;
            }
            if (changed) {
                try {
                    principal.setDataSource("RzdHelper-getPrincipal");
                    DictionaryStorage.get().save((BaseDictionary)principal);
                }
                catch (Exception e) {
                    log.error(String.format("can't save Principal with (inn, bin) = (%s, %s)", principalInn, principalBin), (Throwable)e);
                }
            }
        }
        return DictHelper.toReference((BaseDictionary)principal);
    }

    public static DictionaryReference<Principal> createPrincipal(String principalInn, String principalName, String principalPhoneNumber) {
        return RzdHelper.createPrincipal(principalInn, principalName, principalPhoneNumber, null, null);
    }

    public static DictionaryReference<Principal> createPrincipalForKz(String principalName, String principalBin, String serialNumber) {
        return RzdHelper.createPrincipal(null, principalName, null, principalBin, serialNumber);
    }

    private static DictionaryReference<Principal> createPrincipal(String principalInn, String principalName, String principalPhoneNumber, String principalBin, String serialNumber) {
        if (TextUtil.isBlank((String)principalName)) {
            return null;
        }
        if (TextUtil.isBlank((String)principalInn) && TextUtil.isBlank((String)principalBin)) {
            return null;
        }
        Principal principal = new Principal();
        principal.setCode(principalName);
        principal.setRegistrationId(principalInn);
        principal.setPhone(principalPhoneNumber);
        principal.getTranslations().put(LocaleUtil.LOCALE_RU, principalName);
        principal.setBin(principalBin);
        principal.setVatSeriesNumber(serialNumber);
        try {
            principal.setDataSource("RzdHelper-createPrincipal");
            DictionaryStorage.get().save((BaseDictionary)principal);
        }
        catch (Exception e) {
            log.error(String.format("can't save Principal with inn %s", principalInn), (Throwable)e);
            return null;
        }
        return DictHelper.toReference((BaseDictionary)principal);
    }

    public static <T> Map<T, Traveller> buildPassportTravellersMap(List<MiscUtil.Pair<T, Passport>> passports, List<Traveller> travellers) {
        HashMap result = new HashMap();
        ArrayList unusedElements = new ArrayList(passports);
        for (Traveller traveller : travellers) {
            Passport passport = traveller.getPassport();
            String number = passport.getNumber();
            if (unusedElements.isEmpty()) break;
            List elements = unusedElements.stream().filter(it -> TextUtil.isSame((String)((Passport)it.getSecond()).getNumber(), (String)number, (boolean)true) && ((Passport)it.getSecond()).getType().equals((Object)passport.getType())).collect(Collectors.toList());
            if (elements.isEmpty()) {
                throw Xeption.forDeveloper((String)"can't find traveller with passportNumber {0} in reservation system response {1}", (Object[])new Object[]{number, passports.stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toList())});
            }
            if (elements.size() == 1) {
                RzdHelper.addAndPopElement(result, unusedElements, traveller, (MiscUtil.Pair)elements.get(0));
                continue;
            }
            List elementsByName = elements.stream().filter(pp -> 0 == StrictMath.abs(((Passport)pp.getSecond()).getLastName().compareToIgnoreCase(RzdHelper.modifyNameForGds(passport.getLastName()))) + StrictMath.abs(((Passport)pp.getSecond()).getFirstName().compareToIgnoreCase(RzdHelper.modifyNameForGds(passport.getFirstName())))).collect(Collectors.toList());
            if (elementsByName.isEmpty()) {
                throw Xeption.forDeveloper((String)"can't find traveller with passportNumber {0} in reservation system response {1}. No travellers match by name", (Object[])new Object[]{number, elements.stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toList())});
            }
            if (elementsByName.size() == 1) {
                RzdHelper.addAndPopElement(result, unusedElements, traveller, (MiscUtil.Pair)elementsByName.get(0));
                continue;
            }
            List<MiscUtil.Pair> elementsByBirth = elementsByName.stream().filter(it -> ((Passport)it.getSecond()).getBirthday().equals(passport.getBirthday())).collect(Collectors.toList());
            if (elementsByBirth.isEmpty()) {
                throw Xeption.forDeveloper((String)"can't find traveller with passportNumber {0} in reservation system response {1}. No traveller matches by birthday", (Object[])new Object[]{number, elementsByName.stream().map(MiscUtil.Pair::getSecond).collect(Collectors.toList())});
            }
            if (elementsByBirth.size() == 1) {
                RzdHelper.addAndPopElement(result, unusedElements, traveller, (MiscUtil.Pair)elementsByBirth.get(0));
                continue;
            }
            if (passports.size() > travellers.size()) {
                elementsByBirth.forEach(element -> RzdHelper.addAndPopElement(result, unusedElements, traveller, element));
                continue;
            }
            RzdHelper.addAndPopElement(result, unusedElements, traveller, (MiscUtil.Pair)elementsByBirth.get(0));
        }
        return result;
    }

    public static Traveller findTravellerByPassport(Passport passport, List<Traveller> travellers) {
        for (Traveller traveller : travellers) {
            if (!RzdCommonHelper.isSamePassports((Passport)passport, (Passport)traveller.getPassport(), (boolean)true)) continue;
            return traveller;
        }
        return null;
    }

    private static <T> void addAndPopElement(Map<T, Traveller> result, ArrayList<MiscUtil.Pair<T, Passport>> unusedElements, Traveller traveller, MiscUtil.Pair<T, Passport> element) {
        result.put(element.getFirst(), traveller);
        unusedElements.remove(element);
    }

    public static <T extends RailProductProxy> T getCommonRailProductProxy(RailwayProduct product, Traveller traveller, Class<T> class1) throws Exception {
        RailProductProxy t = (RailProductProxy)class1.newInstance();
        t.setPassengerType(RailwayProductHelper.getPassengerType((RailwayProduct)product, (Traveller)traveller));
        t.setPassengerFio(traveller.getName());
        Locale locale = LocaleManager.get().getCurrentLocale();
        t.setPassengerDoc(String.format("%1$s %2$s", RzdCommonHelper.getPassportLabel((PassportType)traveller.getPassport().getType(), (Locale)locale), traveller.getPassport().getNumber()));
        return (T)t;
    }

    public static RzdTariff getProductTariff(RailwayProduct product, Traveller traveller) {
        return RzdCommonHelper.getRzdTariff((RzdTariff)product.getIbecorpTariff(), (DictionaryReference)RailwayProductHelper.getPassengerType((RailwayProduct)product, (Traveller)traveller));
    }

    static {
        railServiceMap.put(RailService.BEDCLOTHES, "Bedclothes");
        railServiceMap.put(RailService.MEAL, "Meal");
        railServiceMap.put(RailService.WIFI, "Wifi");
        railServiceMap.put(RailService.TV, "Tv");
        railServiceMap.put(RailService.HYGIENIC_KIT, "HygienicKit");
        railServiceMap.put(RailService.PRESS, "Press");
        railServiceMap.put(RailService.AIR_CONDITIONING, "AirConditioning");
        railServiceMap.put(RailService.BIO_TOILET, "BioToilet");
        railServiceMap.put(RailService.PLAID, "Plaid");
        railServiceMap.put(RailService.WASHBASIN_IN_COMPARTMENT, "WashbasinInCompartment");
        railServiceMap.put(RailService.SHOWER_IN_COMPARTMENT, "ShowerRoomInCompartment");
        railServiceMap.put(RailService.HYGIENIC_SHOWER, "HygienicShower");
        railServiceMap.put(RailService.SOCKET220V, "Socket220V");
        railServiceMap.put(RailService.SLIPPERS, "Slippers");
        railServiceMap.put(RailService.PETS_CARRIAGE, "PetsCarriage");
        railServiceMap.put(RailService.PLACES_FOR_PASSENGERS_WITH_BABY, "PlacesForPassengerWithBaby");
        railServiceMap.put(RailService.TRANSFER, "Transfer");
        railServiceMap.put(RailService.RESTAURANT_CAR, "RestaurantCarOrBuffet");
        railServiceMap.put(RailService.LUGGAGE_COMPARTMENT, "LuggageCompartment");
        railServiceMap.put(RailService.SHOWER_IN_TRAIN, "ShowerRoomInTrain");
        railServiceMap.put(RailService.SAFE, "Safe");
        railServiceMap.put(RailService.IMPROVED_SERVICES, "ImprovedServices");
        railServiceMap.put(RailService.HIGH_COMFORT_WAITING_ROOM, "HighComfortWaitingRoomServices");
        railServiceMap.put(RailService.INFOTAINMENT_SERVICES, "InfotainmentService");
        railServiceMap.put(RailService.HOT_DRINK, "HotDrink");
        railServiceMap.put(RailService.USB_SOCKET, "UsbSocket");
        ufsCompartmentTypeMap.put(CompartmentType.MEN, SeatType.MALE);
        ufsCompartmentTypeMap.put(CompartmentType.WOMEN, SeatType.FEMALE);
        ufsCompartmentTypeMap.put(CompartmentType.COMMON, SeatType.MIXED);
    }
}

