/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.airlineRules;

import com.gridnine.xtrip.common.gds.rules.airline.BrandedFaresActions;
import com.gridnine.xtrip.common.gds.rules.airline.CommonAirlineRulesEnvironment;
import com.gridnine.xtrip.common.ibecorp.gds.model.OrganizationAirlineSettings;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.meta.EntityType;
import com.gridnine.xtrip.common.meta.MetaRegistry;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.air.Segment;
import com.gridnine.xtrip.common.model.booking.air.SegmentTariff;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.RulesDebugInfoSettings;
import com.gridnine.xtrip.common.model.system.SystemSettingsType;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.server.ibecorp.airlineRules.TestOrganizationCommonAirlineSettingsBuilder;
import com.gridnine.xtrip.server.model.test.ModelTestBase;
import com.gridnine.xtrip.server.model.test.TestBookingFileBuilder;
import java.net.URL;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class CommonArilineRulesApplicationTest
extends ModelTestBase {
    protected List<URL> collectIntegrationBusDescriptions() {
        List urls = super.collectIntegrationBusDescriptions();
        urls.add(((Object)((Object)this)).getClass().getResource("ibus-common-airline-rules-test.xml"));
        return urls;
    }

    protected void configureRulesEnvironment(RulesEnvironment re) {
        super.configureRulesEnvironment(re);
        new CommonAirlineRulesEnvironment().environmentInitialized(re);
    }

    @Test
    public void testRulesApplication() throws Exception {
        EntityContainer<OrganizationAirlineSettings> settingsCtr = new TestOrganizationCommonAirlineSettingsBuilder().agency((EntityReference<Organization>)TestBookingFileBuilder.agency).airlineRule().ruleResult((RuleAction)BrandedFaresActions.BRAND_NAME, "TEST").end().create();
        EntityContainer ctr = new EntityContainer(RulesDebugInfoSettings.class, "RULES_DEBUG_INFO_SETTINGS_UID");
        ((RulesDebugInfoSettings)ctr.getEntity()).setName(((EntityType)MetaRegistry.get().getEntities().get(RulesDebugInfoSettings.class.getName())).getDisplayName());
        ((RulesDebugInfoSettings)ctr.getEntity()).setType(SystemSettingsType.OTHER);
        ((RulesDebugInfoSettings)ctr.getEntity()).setBookingNumbersPattern(".*");
        EntityStorage.get().save(ctr, true);
        OrganizationAirlineSettings airlineSettings = new OrganizationAirlineSettings();
        airlineSettings.setOrganization(TestBookingFileBuilder.agency);
        EntityContainer bookingContainer = new TestBookingFileBuilder().traveller().end().reservation().airProduct().segmentTariff().segment().departureLocation("LED").arriveLocation("DME").end().segment().departureLocation("DME").arriveLocation("FRA").end().end().segmentTariff().segment().departureLocation("FRA").arriveLocation("LED").end().end().vendorContractRelation().fop().end().end().clientContractRelation().fop().end().end().end().end().create();
        this.checkBrand((EntityContainer<BookingFile>)bookingContainer, "TEST");
        EntityStorage.get().delete(settingsCtr);
        settingsCtr = new TestOrganizationCommonAirlineSettingsBuilder().agency((EntityReference<Organization>)TestBookingFileBuilder.agency).airlineRule().ruleResult((RuleAction)BrandedFaresActions.BRAND_NAME, "TEST2").end().create();
        Product prod = (Product)((Reservation)((BookingFile)bookingContainer.getEntity()).getReservations().get(0)).getProducts().get(0);
        prod.setContractRulesApplied(true);
        EntityStorage.get().save(bookingContainer, true);
        this.checkBrand((EntityContainer<BookingFile>)bookingContainer, "TEST");
        prod = (Product)((Reservation)((BookingFile)bookingContainer.getEntity()).getReservations().get(0)).getProducts().get(0);
        prod.setContractRulesApplied(false);
        EntityStorage.get().save(bookingContainer, true);
        this.checkBrand((EntityContainer<BookingFile>)bookingContainer, "TEST2");
    }

    private void checkBrand(EntityContainer<BookingFile> bookingContainer, String test) {
        for (SegmentTariff st : ((Product)((Reservation)((BookingFile)bookingContainer.getEntity()).getReservations().get(0)).getProducts().get(0)).getSegmentTariffs()) {
            for (Segment segment : st.getSegments()) {
                Assert.assertEquals((Object)test, (Object)L10nStringHelper.getValue((L10nString)segment.getFareDetails().getDisplayBrandName(), (Locale)LocaleHelper.EN_LOCALE, (boolean)false));
            }
        }
    }
}

