/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.assets;

import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.ibecorp.assets.PersonPreferencesAsset;
import com.gridnine.xtrip.server.ibecorp.b2b.hotels.SearchRoomType;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class PersonPreferencesAssetData
extends BaseAssetData<PersonPreferencesAsset> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="PersonPreferencesAssetData_modified")
    private Date modified;
    @Column
    private String person;
    @Column
    private String personCaption;
    @Column
    private String searchRoomType;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public PersonPreferencesAsset toAsset(Set<String> preferredProperties) {
        PersonPreferencesAsset result = new PersonPreferencesAsset(this.getUid());
        if (preferredProperties.isEmpty() || preferredProperties.contains(PersonPreferencesAsset.Property.person.name())) {
            result.setPerson((EntityReference<Person>)new EntityReference(this.person, Person.class, this.personCaption));
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains(PersonPreferencesAsset.Property.searchRoomType.name())) {
            result.setSearchRoomType(TextUtil.nonBlank((String)this.searchRoomType) ? SearchRoomType.valueOf((String)this.searchRoomType) : null);
        }
        return result;
    }

    public void fromAsset(PersonPreferencesAsset asset) {
        this.setUid(asset.getUid());
        EntityReference<Person> personValue = asset.getPerson();
        this.person = personValue != null ? personValue.getUid() : null;
        this.personCaption = personValue != null ? personValue.getCaption() : null;
        SearchRoomType searchRoomTypeValue = asset.getSearchRoomType();
        this.searchRoomType = searchRoomTypeValue != null ? searchRoomTypeValue.name() : null;
    }
}

