/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.assets;

import com.gridnine.xtrip.common.model.BaseAsset;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.xml.XHelper;
import com.gridnine.xtrip.common.xml.XSHelper;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Element;

public class SiteUserPreferences
extends BaseAsset {
    private String loginName;
    private String organizationReferenceUid;
    private String salesPointReferenceUid;
    private String organizationReferenceCaption;
    private String salesPointReferenceCaption;
    private PersonType personType;

    public String getSalesPointReferenceUid() {
        return this.salesPointReferenceUid;
    }

    public void setSalesPointReferenceUid(String salesPointReferenceUid) {
        this.salesPointReferenceUid = salesPointReferenceUid;
    }

    public SiteUserPreferences(String uid) {
        super(uid);
    }

    public SiteUserPreferences() {
    }

    public String getLoginName() {
        return this.loginName;
    }

    public void setLoginName(String loginName) {
        this.loginName = loginName;
    }

    public String getOrganizationReferenceUid() {
        return this.organizationReferenceUid;
    }

    public void setOrganizationReferenceUid(String organizationReferenceUid) {
        this.organizationReferenceUid = organizationReferenceUid;
    }

    public String getOrganizationReferenceCaption() {
        return this.organizationReferenceCaption;
    }

    public void setOrganizationReferenceCaption(String organizationReferenceCaption) {
        this.organizationReferenceCaption = organizationReferenceCaption;
    }

    public String getSalesPointReferenceCaption() {
        return this.salesPointReferenceCaption;
    }

    public void setSalesPointReferenceCaption(String salesPointReferenceCaption) {
        this.salesPointReferenceCaption = salesPointReferenceCaption;
    }

    public EntityReference<Organization> getOrganizationReference() {
        if (StringUtils.isBlank((String)this.organizationReferenceUid)) {
            return null;
        }
        return new EntityReference(this.organizationReferenceUid, Organization.class, this.organizationReferenceCaption);
    }

    public EntityReference<SalesPoint> getSalesPointReference() {
        if (StringUtils.isBlank((String)this.salesPointReferenceUid)) {
            return null;
        }
        return new EntityReference(this.salesPointReferenceUid, SalesPoint.class, this.salesPointReferenceCaption);
    }

    public void setOrganizationReference(EntityReference<Organization> reference) {
        this.organizationReferenceUid = reference.getUid();
        this.organizationReferenceCaption = reference.getCaption();
    }

    public PersonType getPersonType() {
        return this.personType;
    }

    public void setPersonType(PersonType personType) {
        this.personType = personType;
    }

    public void fromXML(Element elm) throws Exception {
        super.fromXML(elm);
        this.loginName = XHelper.readString((Element)elm, (String)"loginName");
        this.organizationReferenceUid = XHelper.readString((Element)elm, (String)"organizationReferenceUid");
        this.organizationReferenceCaption = XHelper.readString((Element)elm, (String)"organizationReferenceCaption");
        this.salesPointReferenceUid = XHelper.readString((Element)elm, (String)"salesPointReferenceUid");
        this.salesPointReferenceCaption = XHelper.readString((Element)elm, (String)"salesPointReferenceCaption");
        this.personType = (PersonType)XHelper.readEnum((Element)elm, (String)"personType", PersonType.class);
    }

    public void toXML(Element elm) throws Exception {
        super.toXML(elm);
        XHelper.writeString((Element)elm, (String)"loginName", (String)this.loginName);
        XHelper.writeString((Element)elm, (String)"organizationReferenceUid", (String)this.organizationReferenceUid);
        XHelper.writeString((Element)elm, (String)"organizationReferenceCaption", (String)this.organizationReferenceCaption);
        XHelper.writeString((Element)elm, (String)"salesPointReferenceUid", (String)this.salesPointReferenceUid);
        XHelper.writeString((Element)elm, (String)"salesPointReferenceCaption", (String)this.salesPointReferenceCaption);
        XHelper.writeEnum((Element)elm, (String)"personType", (Enum)this.personType);
    }

    protected boolean readXMLElement(XMLStreamReader reader) throws Exception {
        String tagName = reader.getName().getLocalPart();
        if ("loginName".equals(tagName)) {
            this.loginName = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("organizationReferenceUid".equals(tagName)) {
            this.organizationReferenceUid = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("organizationReferenceCaption".equals(tagName)) {
            this.organizationReferenceCaption = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("salesPointReferenceUid".equals(tagName)) {
            this.salesPointReferenceUid = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("salesPointReferenceCaption".equals(tagName)) {
            this.salesPointReferenceCaption = XSHelper.readString((XMLStreamReader)reader);
            return true;
        }
        if ("personType".equals(tagName)) {
            this.personType = (PersonType)XSHelper.readEnum((XMLStreamReader)reader, PersonType.class);
        }
        return false;
    }

    protected void writeXMLElements(XMLStreamWriter writer) throws Exception {
        XSHelper.writeString((XMLStreamWriter)writer, (String)"loginName", (String)this.loginName);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"organizationReferenceUid", (String)this.organizationReferenceUid);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"organizationReferenceCaption", (String)this.organizationReferenceCaption);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"salesPointReferenceUid", (String)this.salesPointReferenceUid);
        XSHelper.writeString((XMLStreamWriter)writer, (String)"salesPointReferenceCaption", (String)this.salesPointReferenceCaption);
        XSHelper.writeEnum((XMLStreamWriter)writer, (String)"personType", (Enum)this.personType);
    }

    protected void copyFrom(BaseAsset sourceAsset, boolean newUids, Map<String, String> uids) throws Exception {
        SiteUserPreferences sourcePrefs = (SiteUserPreferences)sourceAsset;
        this.loginName = sourcePrefs.loginName;
        this.organizationReferenceUid = sourcePrefs.organizationReferenceUid;
        this.organizationReferenceCaption = sourcePrefs.organizationReferenceCaption;
        this.salesPointReferenceUid = sourcePrefs.salesPointReferenceUid;
        this.salesPointReferenceCaption = sourcePrefs.salesPointReferenceCaption;
        this.personType = sourcePrefs.personType;
    }

    public static enum Property {
        loginName;

    }
}

