/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.assets;

import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Index;

@Entity
public class SiteUserPreferencesData
extends BaseAssetData<SiteUserPreferences> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="SiteUserPreferencesData_modified")
    private Date modified;
    @Column(unique=true, nullable=false)
    @Index(name="SiteUserPreferencesData_loginName")
    private String loginName;
    @Column
    private String organizationReferenceUid;
    @Column
    private String organizationReferenceCaption;
    @Column
    private String salesPointReferenceUid;
    @Column
    private String salesPointReferenceCaption;
    @Column
    private String personType;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public SiteUserPreferences toAsset(Set<String> preferredProperties) throws Exception {
        SiteUserPreferences result = new SiteUserPreferences(this.getUid());
        result.setLoginName(this.loginName);
        result.setOrganizationReferenceUid(this.organizationReferenceUid);
        result.setOrganizationReferenceCaption(this.organizationReferenceCaption);
        result.setSalesPointReferenceUid(this.salesPointReferenceUid);
        result.setSalesPointReferenceCaption(this.salesPointReferenceCaption);
        PersonType pt = StringUtils.isBlank((String)this.personType) ? null : PersonType.valueOf((String)this.personType);
        result.setPersonType(pt);
        return result;
    }

    public void fromAsset(SiteUserPreferences asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.loginName = asset.getLoginName();
        this.organizationReferenceUid = asset.getOrganizationReferenceUid();
        this.organizationReferenceCaption = asset.getOrganizationReferenceCaption();
        this.salesPointReferenceUid = asset.getSalesPointReferenceUid();
        this.salesPointReferenceCaption = asset.getSalesPointReferenceCaption();
        this.personType = asset.getPersonType() == null ? null : asset.getPersonType().name();
    }
}

