/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.assets;

import com.gridnine.xtrip.common.ibecorp.model.UfsGdsAccount;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.ibecorp.assets.UfsTransListAsset;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"gdsAccount", "date"})})
public class UfsTransListAssetData
extends BaseAssetData<UfsTransListAsset> {
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UfsTransListAssetData_modified")
    private Date modified;
    @Column(nullable=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UfsTransListAssetData_date")
    private Date date;
    @Column(nullable=false)
    @Index(name="UfsTransListAssetData_gdsAccount")
    private String gdsAccount;
    @Column
    private String gdsAccountCaption;
    @Lob
    @Column(length=0x40000000)
    private String transactionIds;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public UfsTransListAsset toAsset(Set<String> preferredProperties) throws Exception {
        UfsTransListAsset result = new UfsTransListAsset(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains(UfsTransListAsset.Property.date.name())) {
            result.setDate(MiscUtil.cloneDate((Date)this.date));
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains(UfsTransListAsset.Property.gdsAccount.name())) && TextUtil.nonBlank((String)this.gdsAccount)) {
            result.setGdsAccount((EntityReference<UfsGdsAccount>)new EntityReference(this.gdsAccount, UfsGdsAccount.class, this.gdsAccountCaption));
        }
        if ((preferredProperties.isEmpty() || preferredProperties.contains(UfsTransListAsset.Property.transactionIds.name())) && TextUtil.nonBlank((String)this.transactionIds)) {
            for (String item : this.transactionIds.split("\\|")) {
                if (!TextUtil.nonBlank((String)item)) continue;
                result.getTransactionIds().add(item);
            }
        }
        return result;
    }

    public void fromAsset(UfsTransListAsset asset) throws Exception {
        this.setUid(asset.getUid());
        this.modified = MiscUtil.cloneDate((Date)asset.getModified());
        this.date = MiscUtil.cloneDate((Date)asset.getDate());
        if (asset.getGdsAccount() != null) {
            this.gdsAccount = asset.getGdsAccount().getUid();
            this.gdsAccountCaption = asset.getGdsAccount().getCaption();
        } else {
            this.gdsAccount = null;
            this.gdsAccountCaption = null;
        }
        if (asset.getTransactionIds().isEmpty()) {
            this.transactionIds = "";
        } else {
            StringBuilder buf = new StringBuilder();
            for (String item : asset.getTransactionIds()) {
                buf.append('|');
                buf.append(item);
            }
            buf.append('|');
            this.transactionIds = buf.toString();
        }
    }
}

