/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.assets;

import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.db.storage.model.BaseAssetData;
import com.gridnine.xtrip.server.ibecorp.assets.UserSecurityTokenAsset;
import java.util.Date;
import java.util.Set;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Index;

@Entity
public class UserSecurityTokenAssetData
extends BaseAssetData<UserSecurityTokenAsset> {
    @Temporal(value=TemporalType.TIMESTAMP)
    @Index(name="UserSecurityTokenAssetData_modified")
    private Date modified;
    @Column(unique=true)
    @Index(name="UserSecurityTokenAssetData_personUid")
    private String personUid;
    @Column(length=2048)
    private String googleAuthToken;

    public Date getModified() {
        return this.modified;
    }

    public void setModified(Date date) {
        this.modified = date;
    }

    public void fromAsset(UserSecurityTokenAsset asset) {
        this.setUid(asset.getUid());
        this.modified = asset.getModified();
        this.personUid = asset.getPersonUid();
        this.googleAuthToken = asset.getGoogleAuthToken();
    }

    public UserSecurityTokenAsset toAsset(Set<String> preferredProperties) {
        UserSecurityTokenAsset result = new UserSecurityTokenAsset(this.getUid());
        result.setModified(MiscUtil.cloneDate((Date)this.modified));
        if (preferredProperties.isEmpty() || preferredProperties.contains("personUid")) {
            result.setPersonUid(this.personUid);
        }
        if (preferredProperties.isEmpty() || preferredProperties.contains("googleAuthToken")) {
            result.setGoogleAuthToken(this.googleAuthToken);
        }
        return result;
    }
}

