/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.autocancel;

import com.gridnine.bof.midoffice.helper.MidofficeHelper;
import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.ibecorp.CommonIbecorpHelper;
import com.gridnine.xtrip.common.incidents.IncidentsLog;
import com.gridnine.xtrip.common.lockmanager.LockUtil;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.ReservationStatus;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.parameters.EntityStorageSaveParameters;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.MessageHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.ExceptionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.server.BaseScheduledTask;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationHelper;
import com.gridnine.xtrip.server.ibecorp.notifications.NotificationParameters;
import com.gridnine.xtrip.server.ibecorp.notifications.ReservationFailedCancellingNotificationHepler;
import com.gridnine.xtrip.server.ibecorp.storage.IbeCorpBookingFileIndexRegistryHandler;
import com.gridnine.xtrip.server.ibus.IntegrationBusFacade;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoCancelTask
extends BaseScheduledTask {
    private static final Logger LOG = LoggerFactory.getLogger(AutoCancelTask.class);
    private static final Set<ProductStatus> CANCEL_PRODUCT_STATUSES = EnumSet.of(ProductStatus.VOID, ProductStatus.VOID_BOOKING, ProductStatus.VOID_INTENTION);
    private Date nextFireTime;

    public void configure(Properties properties) {
        this.nextFireTime = (Date)properties.get("nextFireTime");
    }

    public void doJob() {
        Date start = new Date();
        LOG.debug("started auto-cancellation task");
        LOG.debug("starting to cancel expiring bookings");
        SearchQuery sq = this.buildQuery(this.nextFireTime);
        List data = EntityStorage.get().search(BookingFileIndex.class, sq).getData();
        data.sort(Comparator.comparing(BookingFileIndex::getTimelimit));
        LOG.debug(String.format("%s bookings found for cancellation", data.size()));
        for (BookingFileIndex index : data) {
            BookingFile bookingFile;
            EntityContainer<BookingFile> bookingFileCtr = this.getBookingFileCtr(index);
            if (bookingFileCtr == null || (bookingFile = (BookingFile)bookingFileCtr.getEntity()) == null) continue;
            Collection reservations = bookingFile.getReservations().stream().filter(res -> IbeCorpBookingFileIndexRegistryHandler.TIME_LIMIT_RESERVATION_STATUSES.contains(CommonIbecorpHelper.getReservationStatus((Reservation)res))).filter(res -> !res.isFailedCancelling()).filter(res -> res.getGdsNameInfo().getOnlineGdsAccount() != null).filter(res -> MiscUtil.compare((Date)res.getTimeLimit(), (Date)index.getTimelimit()) <= 0).collect(Collectors.toList());
            this.cancelBooking((EntityReference<SMSite>)bookingFile.getSite(), index, reservations);
        }
        Date now = new Date();
        if (this.nextFireTime.before(now)) {
            IncidentsLog.reportStackTrace((String)String.format("AutoCancelTask starting at %s still processing now %s, but nextFireTime %s has come", start, now, this.nextFireTime));
        }
        LOG.debug("finished auto-cancellation task");
    }

    private SearchQuery buildQuery(Date nextFireTime) {
        SearchQuery sq = new SearchQuery();
        List criteria = sq.getCriteria().getCriterions();
        criteria.add(SearchCriterion.or((SearchCriterion[])((SearchCriterion[])IbeCorpBookingFileIndexRegistryHandler.TIME_LIMIT_RESERVATION_STATUSES.stream().map(resStatus -> SearchCriterion.contains((String)BookingFileIndex.Property.reservationStatuses.name(), (Object)resStatus)).toArray(SearchCriterion[]::new))));
        criteria.add(SearchCriterion.or((SearchCriterion[])new SearchCriterion[]{SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), (Object)Boolean.FALSE), SearchCriterion.eq((String)BookingFileIndex.Property.failedCancelling.name(), null)}));
        criteria.add(SearchCriterion.le((String)BookingFileIndex.Property.timelimit.name(), (Object)nextFireTime));
        criteria.add(SearchCriterion.gt((String)BookingFileIndex.Property.timelimit.name(), (Object)MiscUtil.addDaysToDate((Date)nextFireTime, (int)-7)));
        return sq;
    }

    private EntityContainer<BookingFile> getBookingFileCtr(BookingFileIndex index) {
        try {
            return EntityStorage.get().resolve(index.getSource());
        }
        catch (Exception e) {
            LOG.debug(String.format("Unable to load a booking from index [%s], skipping", index.getUid()));
            return null;
        }
    }

    private void cancelBooking(EntityReference<SMSite> siteRef, BookingFileIndex bookingFileIndex, Collection<Reservation> reservations) {
        LOG.debug(String.format("starting auto-cancellation of booking [%s]", bookingFileIndex.getFullNumber()));
        LinkedHashMap<SalesContext, Collection> map = new LinkedHashMap<SalesContext, Collection>();
        for (Reservation reservation : reservations) {
            SalesContext salesContext = SalesContextHandler.get().createSalesContext(reservation);
            map.entrySet().stream().filter(e -> Objects.equals(((SalesContext)e.getKey()).getSalesPoint(), salesContext.getSalesPoint())).map(Map.Entry::getValue).findFirst().orElseGet(() -> {
                ArrayList list = new ArrayList();
                map.put(salesContext, list);
                return list;
            }).add(reservation);
        }
        map.forEach((key, value) -> this.cancelBooking(siteRef, bookingFileIndex, (Collection<Reservation>)value, (SalesContext)key));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelBooking(EntityReference<SMSite> siteRef, BookingFileIndex bookingFileIndex, Collection<Reservation> reservations, SalesContext salesContext) {
        try {
            EntityContainer bookingFileCtr = EntityStorage.get().resolve(bookingFileIndex.getSource());
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("BOOKING_FILE", bookingFileCtr);
            data.put(IBusMidofficeContextKeys.BOOKING_FILE_RESERVATIONS.name(), reservations);
            data.put("SALES_CONTEXT", salesContext);
            List yetCancelledProductUids = reservations.stream().map(Reservation::getProducts).flatMap(Collection::stream).filter(pr -> CANCEL_PRODUCT_STATUSES.contains(GeneralProductHelper.getStatus((BaseProduct)pr))).map(BaseIdentity::getUid).collect(Collectors.toList());
            try {
                ((IntegrationBusFacade)Environment.getPublished(IntegrationBusFacade.class)).getRequestReplyAdapter("midoffice:cancel-booking").processSync(data);
                LOG.info(String.format("booking number [%s] cancelling is finished", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileCtr.getEntity()))));
            }
            finally {
                LockUtil.lock((EntityContainer)bookingFileCtr, bookingFileCtr2 -> {
                    BookingFile bookingFile = (BookingFile)bookingFileCtr2.getEntity();
                    boolean neededSave = false;
                    for (Reservation reservation : MidofficeHelper.getReservations((EntityContainer)bookingFileCtr2, (Collection)reservations)) {
                        if (CommonIbecorpHelper.getReservationStatus((Reservation)reservation) != ReservationStatus.CANCELED) {
                            reservation.setFailedCancelling(true);
                            neededSave = true;
                            if (reservation.getProducts().stream().filter(pr -> !yetCancelledProductUids.contains(pr.getUid())).map(GeneralProductHelper::getStatus).noneMatch(CANCEL_PRODUCT_STATUSES::contains)) continue;
                        }
                        try {
                            EntityReference bookingRef = bookingFileCtr2.toReference();
                            NotificationParameters parameters = new NotificationParameters((EntityReference<Organization>)reservation.getSubagency(), (EntityReference<Organization>)bookingFile.getCustomerProfile(), (EntityReference<SMSite>)bookingFile.getSite(), bookingFile.getCustomer().getPreferredLocale(), bookingRef, SalesContextHandler.get().createSalesContext(reservation));
                            NotificationHelper.sendNotification(() -> NotificationHelper.getCancelReservationNotification(parameters, reservation), bookingRef, true);
                        }
                        catch (Exception e) {
                            String exceptionStackTrace = ExceptionUtil.getExceptionStackTrace((Throwable)e);
                            Message warnMessage = MessageHelper.createWarningMessage((String)("Reservation cancelled notification sending failed, pnr " + CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator((Reservation)reservation)), (String)exceptionStackTrace, (Object[])new Object[0]);
                            SysLogHelper.audit((EntityReference)bookingFileCtr.toReference(), (String)"booking-auto-cancellation", (Message[])new Message[]{warnMessage});
                            LOG.warn("Reservation cancelled notification wasn't send:\n" + exceptionStackTrace);
                        }
                    }
                    if (neededSave) {
                        bookingFileCtr2.getVersionInfo().setDataSource("failed-cancelling");
                        bookingFileCtr2.getVersionInfo().setVersionNotes("some reservations have the status not canceled");
                        EntityStorage.get().save(bookingFileCtr2, true);
                    }
                });
            }
        }
        catch (Exception ex) {
            IncidentsLog.reportException((String)String.format("failed cancelling booking %s", bookingFileIndex.getFullNumber()), (Throwable)ex);
            LOG.error(String.format("failed cancelling booking %s", bookingFileIndex.getFullNumber()), (Throwable)ex);
            try {
                SysLogHelper.audit((EntityReference)bookingFileIndex.getSource(), (String)"failed-cancelling", (Message[])new Message[]{MessageHelper.createExceptonMessage((String)"failed-cancelling", (Throwable)ex, (Object[])new Object[0])});
                ArrayList errors = new ArrayList();
                EntityContainer bookingFileCtr = (EntityContainer)LockUtil.lock((EntityReference)bookingFileIndex.getSource(), ctr -> {
                    if (ctr != null) {
                        errors.addAll(MidofficeHelper.getReservations((BookingFile)((BookingFile)ctr.getEntity()), (Collection)reservations));
                        errors.removeIf(r -> CommonIbecorpHelper.getReservationStatus((Reservation)r) == ReservationStatus.CANCELED);
                        errors.forEach(r -> r.setFailedCancelling(true));
                        ctr.getVersionInfo().setDataSource("failed-cancelling");
                        EntityStorage.get().save(ctr, true, (EntityStorageSaveParameters)new EntityStorageSaveParameters().ignoreInterceptors(true));
                        return ctr;
                    }
                    return null;
                });
                if (bookingFileCtr != null) {
                    LOG.warn(String.format("booking %s is marked as failed cancelled, sending email", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileCtr.getEntity()))));
                    for (Reservation reservation : errors) {
                        MidofficeHelper.sendCustomerEmail((String)ReservationFailedCancellingNotificationHepler.buildFailedCancellingReservationEmailSubject(siteRef, reservation), (String)ReservationFailedCancellingNotificationHepler.buildFailedCancellingReservationEmailBody(siteRef, reservation), (String)ReservationFailedCancellingNotificationHepler.getRecipient(), null, (boolean)false);
                    }
                    LOG.warn(String.format("the failed cancelling email of booking %s is send ", TextUtil.buildFullNumber((CompositeNumber)((CompositeNumber)bookingFileCtr.getEntity()))));
                }
            }
            catch (Exception exp) {
                IncidentsLog.reportException((String)String.format("failed adding a cancelling propertry booking %s", bookingFileIndex.getFullNumber()), (Throwable)exp);
                LOG.error(String.format("failed adding a cancelling propertry booking %s", bookingFileIndex.getFullNumber()), (Throwable)exp);
            }
        }
    }
}

