/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.primeconcept;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthToken;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.fx.rpc.service.AuthServiceImpl;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import java.io.Serializable;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class B2BPrimeConceptAuthInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        try {
            HttpServletRequest request = context.getRequest();
            Cookie[] cookies = request.getCookies();
            if (cookies == null || cookies.length == 0) {
                throw Xeption.forEndUser((String)"user not logged in", (Object[])new Object[0]);
            }
            AuthToken token = null;
            for (Cookie cookie : cookies) {
                if (!"IBECORP_B2B_AUTH_TOKEN_COOKIE".equals(cookie.getName())) continue;
                token = AuthToken.decode((String)cookie.getValue());
                break;
            }
            if (token == null) {
                throw Xeption.forEndUser((String)"user not logged in", (Object[])new Object[0]);
            }
            if (token.isExpired()) {
                request.getSession().invalidate();
                throw Xeption.forEndUser((String)"auth token expired", (Object[])new Object[0]);
            }
            if (!AuthServiceImpl.validateAuthToken((Serializable)((Object)token.getData()))) {
                throw Xeption.forEndUser((String)"authorization failed", (Object[])new Object[0]);
            }
            EntityContainer<Person> authUser = AuthorizationHelper.findProfileByLogin(AuthServiceImpl.extractUserLoginFromToken((Serializable)((Object)token.getData())));
            data.put(IBusIbecorpContextKeys.AUTHORIZED_USER.name(), authUser.toReference());
            data.put(IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER.name(), authUser);
            request.setAttribute("AUTH_DATA", (Object)token.getData());
        }
        catch (Exception e) {
            context.setStatus(403);
            throw e;
        }
    }
}

