/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.primeconcept;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonType;
import com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.model.avia.B2BPrimeConceptClientType;
import com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.model.avia.B2BPrimeConceptSearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class B2BPrimeConceptSalesContextAuthInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        EntityReference authorizedUserRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.AUTHORIZED_USER.name()));
        EntityReference siteRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.SITE.name()));
        EntityContainer authorizedUserCtr = EntityStorage.get().resolve(authorizedUserRef);
        Person authorizedUser = (Person)authorizedUserCtr.getEntity();
        if (!AuthorizationHelper.isValidB2BPersonTypes(authorizedUser)) {
            throw Xeption.forEndUser((String)"User {0} has not valid types {1}", (Object[])new Object[]{authorizedUser, CommonHelper.getEnumsCaptionsJoin(Arrays.stream(PersonType.values()).filter(AuthorizationHelper.VALID_B2B_TYPES_CRITERION).collect(Collectors.toSet()))});
        }
        B2BPrimeConceptSearchFlightsParameters params = (B2BPrimeConceptSearchFlightsParameters)data.get(IBusRestContextKeys.REST_PARAMS.name());
        B2BPrimeConceptClientType clientType = params.getClientType();
        if (clientType == null) {
            throw Xeption.forEndUser((String)"\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u0435\u0442 \u043f\u0430\u0440\u0430\u043c\u0435\u0442\u0440 clientType \u0432 \u0437\u0430\u043f\u0440\u043e\u0441\u0435", (Object[])new Object[0]);
        }
        if (!authorizedUser.getTypes().contains(PersonType.PASSENGER)) {
            throw Xeption.forEndUser((String)"\u041d\u0435\u0432\u043e\u0437\u043c\u043e\u0436\u043d\u043e \u0438\u0434\u0435\u043d\u0442\u0438\u0444\u0438\u0446\u0438\u0440\u043e\u0432\u0430\u0442\u044c \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f, \u043f\u0440\u043e\u0444\u0438\u043b\u044c {0} \u0441\u043e\u0434\u0435\u0440\u0436\u0438\u0442 \u043d\u0435\u0438\u0437\u0432\u0435\u0441\u0442\u043d\u044b\u0439 \u0442\u0438\u043f", (Object[])new Object[]{authorizedUser});
        }
        SalesContext result = AuthorizationHelper.getB2BSalesContextForPrimeConcept(clientType, (EntityReference<SMSite>)siteRef);
        result.setSalesPoint(CommonHelper.getSalesPoint((EntityReference<SMSite>)siteRef));
        data.put(IBusMidofficeContextKeys.SALES_CONTEXT.name(), result);
    }
}

