/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.avia.searchFlights;

import com.gridnine.xtrip.common.gds.model.FlightSearchParameters;
import com.gridnine.xtrip.common.gds.model.RouteSegment;
import com.gridnine.xtrip.common.gds.model.SeatPreferences;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.model.avia.B2BPrimeConceptSearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class B2BPrimeConceptSearchFlightsParametersConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        B2BPrimeConceptSearchFlightsParameters parameters = (B2BPrimeConceptSearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        FlightSearchParameters flightSearchParameters = new FlightSearchParameters();
        flightSearchParameters.setServiceClass(parameters.getClassOfService());
        flightSearchParameters.getPreferredAirlines().addAll(parameters.getPreferredAirlines());
        flightSearchParameters.setSkipConnected(parameters.isDirect());
        flightSearchParameters.setExcludeBaglessFares(parameters.isExcludeBaglessFares());
        flightSearchParameters.setExcludeMultiTicket(!parameters.isMultiTicket());
        flightSearchParameters.getFlightNumbers().addAll(AviaConverterHelper.buildFlightNumbers(parameters.getFlightNumbers()));
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE)));
        flightSearchParameters.getRoute().addAll(parameters.getRoutes().stream().map(fl -> {
            RouteSegment seg = new RouteSegment();
            AviaConverterHelper.populateSegment(minimumDate, fl, seg);
            return seg;
        }).collect(Collectors.toList()));
        List seatPreferences = parameters.getPassengersTypes().entrySet().stream().flatMap(e -> {
            if (DictHelper.getChildPassengerType().equals(e.getKey()) && !parameters.getChildsAge().isEmpty()) {
                return parameters.getChildsAge().stream().map(age -> {
                    SeatPreferences seatPref = new SeatPreferences();
                    seatPref.setPassengerType(DictHelper.getChildPassengerType((int)age));
                    seatPref.setCount(Collections.frequency(parameters.getChildsAge(), age));
                    return seatPref;
                });
            }
            SeatPreferences seatPref = new SeatPreferences();
            seatPref.setPassengerType((DictionaryReference)e.getKey());
            seatPref.setCount(((Integer)e.getValue()).intValue());
            return Stream.of(seatPref);
        }).collect(Collectors.toList());
        flightSearchParameters.getSeats().addAll(seatPreferences);
        ctx.putObject((Enum)IBusGdsContextKeys.FLIGHT_SEARCH_PARAMETERS, (Object)flightSearchParameters);
    }
}

