/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.avia.searchFlights;

import com.gridnine.xtrip.common.gds.model.GdsValidationMessages;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.rest.Validatable;
import com.gridnine.xtrip.common.model.validation.ValidationException;
import com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.model.avia.B2BPrimeConceptSearchFlightsParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaValidationHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsParametersValidationMessages;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.search.CommonSearchParameters;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.web.rest.ValidationHelper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class B2BPrimeConceptSearchFlightsParametersValidator
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        B2BPrimeConceptSearchFlightsParameters parameters = (B2BPrimeConceptSearchFlightsParameters)ctx.getMandatoryObject((Enum)IBusRestContextKeys.REST_PARAMS);
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        Date minimumDate = CommonHelper.getMinimumDate((EntityReference<SMSite>)siteRef);
        if (parameters.getRoutes().isEmpty()) {
            parameters.getValidationContext().getRoutesValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyLegs());
        }
        if (Objects.isNull(parameters.getClassOfService())) {
            parameters.getValidationContext().getClassOfServiceValidationMessages().add(SearchFlightsParametersValidationMessages.getEmptyClassOfService());
        }
        parameters.getRoutes().forEach(route -> AviaValidationHelper.validateRoute(route, minimumDate));
        Map passengers = parameters.getPassengersTypes();
        List passengerTypesWithInvalidCategory = passengers.keySet().stream().filter(type -> !AviaHelper.isValidPassengerTypeCategory((DictionaryReference<PassengerType>)type)).collect(Collectors.toList());
        if (!passengerTypesWithInvalidCategory.isEmpty()) {
            AviaValidationHelper.addValidationMessage((CommonSearchParameters)parameters, passengerTypesWithInvalidCategory::contains, SearchFlightsParametersValidationMessages.getInvalidPassengerTypeCategory());
        }
        int totalPassengers = passengers.values().stream().mapToInt(count -> count).sum();
        int adults = AviaHelper.getAdultPassengersCount(passengers);
        int youthsOrSeniors = AviaHelper.getYouthAndSeniorsCount(passengers);
        int infants = AviaHelper.getInfantPassengersCount(passengers);
        int children = AviaHelper.getChildrenPassengersCount(passengers);
        if (totalPassengers == 0) {
            parameters.getValidationContext().getPassengersValidationMessages().add(GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if (totalPassengers > 8) {
            AviaValidationHelper.addValidationMessage((CommonSearchParameters)parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsTooManyPassengers());
        }
        if (adults <= 0 && youthsOrSeniors <= 0) {
            AviaValidationHelper.addValidationMessage((CommonSearchParameters)parameters, AviaHelper.PassengerFilters.noFilterTypes, GdsValidationMessages.getSeatsNotEnoughMajorPassengers());
        }
        if ((adults > 0 || infants > 0 || children > 0) && youthsOrSeniors > 0) {
            AviaValidationHelper.addValidationMessage((CommonSearchParameters)parameters, AviaHelper.PassengerFilters.youthsAndSeniorsFilter, SearchFlightsParametersValidationMessages.getYouthAndSeniorDoNotCombineWithOthers());
        }
        if (adults < infants) {
            AviaValidationHelper.addValidationMessage((CommonSearchParameters)parameters, AviaHelper.PassengerFilters.adultsAndInfantsFilter, SearchFlightsParametersValidationMessages.getIllegalInfantsAmount());
        }
        if (children > 0 && CommonHelper.getStep1Settings((EntityReference<SMSite>)siteRef).isDisplayChildAgeSelector()) {
            AviaValidationHelper.validateChildAges((CommonSearchParameters)parameters, children);
        }
        AviaValidationHelper.validateFlightNumbers((CommonSearchParameters)parameters);
        if (!ValidationHelper.isValid((Validatable)parameters)) {
            throw new ValidationException();
        }
    }
}

