/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.primeconcept.avia.searchFlights;

import com.gridnine.bof.midoffice.ibus.IBusMidofficeContextKeys;
import com.gridnine.xtrip.common.gds.model.Flight;
import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.restriction.resource.IbeRestrictionEntityResources;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.ibecorp.sm.PriceDisplayStyle;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMStep2Settings;
import com.gridnine.xtrip.common.model.profile.ExchangeRateData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.server.gds.ibus.IBusGdsContextKeys;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.components.AviaPriceComponents;
import com.gridnine.xtrip.server.ibecorp.common.components.PriceComponentsParameters;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.avia.AviaConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.BestFlights;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.avia.SearchFlightsResult;
import com.gridnine.xtrip.server.ibecorp.helpers.IbecorpRulesHelper;
import com.gridnine.xtrip.server.ibus.components.BaseProcessor;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;

public class B2BPrimeConceptSearchFlightsResultConverter
extends BaseProcessor {
    public void process(MessageContext ctx) throws Exception {
        EntityReference siteRef = (EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE);
        SMSiteType siteType = (SMSiteType)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.SITE_TYPE);
        Collection gdsFlights = (Collection)ctx.getMandatoryObject((Enum)IBusGdsContextKeys.FLIGHTS);
        SalesContext salesContext = (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT);
        SMStep2Settings step2Settings = CommonHelper.getStep2Settings((EntityReference<SMSite>)siteRef);
        PriceDisplayStyle displayStyle = step2Settings.getPriceDisplayStyle();
        SearchFlightsResult result = new SearchFlightsResult();
        PriceComponentsParameters componentsParameters = this.getPriceConverterParameters(ctx);
        Map<String, ExchangeRateData> currencyExchangeRateDataMap = CommonConverterHelper.getCurrencyExchangeRateDataMap(gdsFlights, salesContext);
        gdsFlights.forEach(flight -> AviaConverterHelper.addFlightToBestPrices(flight, result.getBestPrices(), AviaPriceComponents.builder(flight, componentsParameters).build(), currencyExchangeRateDataMap));
        result.getBestPrices().entrySet().stream().forEach(bestFlightsEntry -> Collections.sort(((BestFlights)bestFlightsEntry.getValue()).getBestFlights(), (bf1, bf2) -> CommonConverterHelper.MONEY_COMPARATOR.compare(bf1.getPrice(), bf2.getPrice())));
        boolean showGdsAccountName = siteType == SMSiteType.B2B && IbecorpRulesHelper.isGranted(IbeRestrictionEntityResources.ENTITY_GDSNAMEVISIBILITY_AVIA);
        for (Flight flight2 : gdsFlights) {
            result.getFlights().add(AviaConverterHelper.convertFlightSearchItem2Rest(flight2, componentsParameters, displayStyle, false, showGdsAccountName, step2Settings, currencyExchangeRateDataMap));
        }
        ctx.putObject((Enum)IBusRestContextKeys.REST_RESULT, (Object)result);
    }

    protected PriceComponentsParameters getPriceConverterParameters(MessageContext ctx) {
        return PriceComponentsParameters.getB2BComponentsParameters((EntityReference<Person>)((EntityReference)ctx.getMandatoryObject((Enum)IBusIbecorpContextKeys.AUTHORIZED_USER)), (SalesContext)ctx.getMandatoryObject((Enum)IBusMidofficeContextKeys.SALES_CONTEXT));
    }
}

