/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthToken;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.asset.AssetsStorage;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonEmployment;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.fx.rpc.service.AuthServiceImpl;
import com.gridnine.xtrip.server.ibecorp.assets.SiteUserPreferences;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.authorization.AuthorizationHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class B2BAuthInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        HttpServletRequest request = context.getRequest();
        try {
            SMSiteType siteType = (SMSiteType)data.get(IBusIbecorpContextKeys.SITE_TYPE.name());
            RestServiceProvider.Operation operation = (RestServiceProvider.Operation)data.get(IBusRestContextKeys.REST_OPERATION.name());
            boolean b2cIgnoreAuth = MiscUtil.guarded((Collection)((Collection)operation.getAttributes().get("b2cIgnoreAuth"))).contains("true");
            boolean ignoreAuth = siteType == SMSiteType.B2C && b2cIgnoreAuth;
            Cookie[] cookies = request.getCookies();
            if (cookies == null || cookies.length == 0) {
                if (ignoreAuth) {
                    return;
                }
                throw Xeption.forEndUser((String)"User not logged in.", (Object[])new Object[0]);
            }
            AuthToken token = AuthToken.decode((String)B2BRestHelper.getCookieValue(cookies, "IBECORP_B2B_AUTH_TOKEN_COOKIE"));
            if (token == null) {
                if (ignoreAuth) {
                    return;
                }
                throw Xeption.forEndUser((String)"User not logged in.", (Object[])new Object[0]);
            }
            if (token.isExpired()) {
                request.getSession().invalidate();
                request.setAttribute("RETAIN_REQUEST_TOKEN", (Object)Boolean.FALSE);
                if (ignoreAuth) {
                    return;
                }
                throw Xeption.forEndUser((String)"Auth token expired", (Object[])new Object[0]);
            }
            if (!AuthServiceImpl.validateAuthToken((Serializable)((Object)token.getData()), (siteType == SMSiteType.B2C ? 1 : 0) != 0)) {
                throw Xeption.forAdmin((String)"Authorization failed.", (Object[])new Object[0]);
            }
            String login = AuthServiceImpl.extractUserLoginFromToken((Serializable)((Object)token.getData()));
            EntityContainer<Person> authUser = AuthorizationHelper.findProfileByLogin(login);
            try {
                data.put(IBusIbecorpContextKeys.AUTHORIZED_USER.name(), authUser.toReference());
                data.put(IBusIbecorpContextKeys.AUTHORIZED_USER_CONTAINER.name(), authUser);
            }
            catch (Exception e) {
                Cookie cookie = new Cookie("IBECORP_B2B_AUTH_TOKEN_COOKIE", "");
                cookie.setPath("/");
                cookie.setMaxAge(0);
                context.getResponse().addCookie(cookie);
                throw e;
            }
            request.setAttribute("AUTH_DATA", (Object)token.getData());
        }
        catch (Exception e) {
            context.setStatus(403);
            throw e;
        }
    }

    public static EntityReference<Organization> defineCurrentOrganization(EntityContainer<Person> authUser) {
        return (EntityReference)B2BAuthInterceptor.defineSelectedPreference(authUser).getFirst();
    }

    private static MiscUtil.Pair<EntityReference<Organization>, EntityReference<SalesPoint>> defineSelectedPreference(EntityContainer<Person> authUser) {
        EntityReference salesPointRef;
        EntityReference userOrgRef;
        MiscUtil.Pair result = new MiscUtil.Pair();
        Person user = (Person)authUser.getEntity();
        List<PersonEmployment> validEmployments = AuthorizationHelper.getValidEmployments(user);
        if (!validEmployments.isEmpty()) {
            boolean hasMainEmployment = validEmployments.stream().anyMatch(PersonEmployment::isMainEmployment);
            if (!hasMainEmployment) {
                throw Xeption.forAdmin((String)"\u041e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u043d\u0435\u043a\u043e\u0440\u0440\u0435\u043a\u0442\u043d\u043e \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u043e. \u041f\u0440\u043e\u0432\u0435\u0440\u044c\u0442\u0435, \u043f\u043e\u0436\u0430\u043b\u0443\u0439\u0441\u0442\u0430, \u043f\u0440\u0430\u0432\u0438\u043b\u044c\u043d\u043e\u0441\u0442\u044c \u0437\u0430\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f.", (Object[])new Object[0]);
            }
            SiteUserPreferences preferences = (SiteUserPreferences)AssetsStorage.get().find(SiteUserPreferences.class, "loginName", (Object)user.getLoginName());
            userOrgRef = null;
            salesPointRef = null;
            if (validEmployments.size() > 1) {
                if (preferences == null || preferences.getOrganizationReference() == null) {
                    throw Xeption.forDeveloper((String)"\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u044b\u0445 \u043c\u0435\u0441\u0442 \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}, \u043d\u043e \u043d\u0438 \u043e\u0434\u043d\u043e \u043d\u0435 \u0431\u044b\u043b\u043e \u0432\u044b\u0431\u0440\u0430\u043d\u043e \u043f\u0440\u0438 \u0432\u0445\u043e\u0434\u0435 \u043d\u0430 \u0441\u0430\u0439\u0442", (Object[])new Object[]{user.getLoginName()});
                }
                userOrgRef = preferences.getOrganizationReference();
                result.setSecond(preferences.getSalesPointReference());
            } else {
                if (!validEmployments.get(0).isMainEmployment()) {
                    throw Xeption.forAdmin((String)"\u041c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f \u043d\u0435 \u043e\u0442\u043c\u0435\u0447\u0435\u043d\u043e \u043a\u0430\u043a \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435.", (Object[])new Object[0]);
                }
                userOrgRef = validEmployments.get(0).getOrganization();
            }
            List<MiscUtil.Pair<PlaceOfSales, EntityReference<SalesPoint>>> spList = B2BRestHelper.buildOrgSalesPlacesMap(user).get(userOrgRef);
            if (spList != null) {
                if (spList.size() > 1) {
                    if (preferences == null) {
                        throw Xeption.forDeveloper((String)"\u041e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043d\u0435\u0441\u043a\u043e\u043b\u044c\u043a\u043e \u0442\u043e\u0447\u0435\u043a \u043f\u0440\u043e\u0434\u0430\u0436\u0438 \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}, \u043e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438\u044f {1}", (Object[])new Object[]{user.getLoginName(), userOrgRef.getCaption()});
                    }
                    salesPointRef = preferences.getSalesPointReference();
                } else if (spList.size() == 1) {
                    salesPointRef = (EntityReference)spList.get(0).getSecond();
                }
            }
        } else {
            throw Xeption.forAdmin((String)"\u041d\u0435 \u043e\u0431\u043d\u0430\u0440\u0443\u0436\u0435\u043d\u043e \u043e\u0441\u043d\u043e\u0432\u043d\u043e\u0435 \u043c\u0435\u0441\u0442\u043e \u0440\u0430\u0431\u043e\u0442\u044b \u0434\u043b\u044f \u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u0442\u0435\u043b\u044f {0}", (Object[])new Object[]{user.getLoginName()});
        }
        result.setFirst((Object)userOrgRef);
        result.setSecond(salesPointRef);
        return result;
    }
}

