/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.gridnine.xtrip.common.ibecorp.model.IBusIbecorpContextKeys;
import com.gridnine.xtrip.common.ibecorp.rest.AuthUserPreferencesToken;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSite;
import com.gridnine.xtrip.common.model.ibecorp.sm.SMSiteType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.B2BRestHelper;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.model.authorization.SelectPreferencesParameters;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.ibus.rest.RestContext;
import com.gridnine.xtrip.server.web.rest.AuthRestInterceptor;
import com.gridnine.xtrip.server.web.rest.RestServiceProvider;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

public class B2BAuthUserPreferencesInterceptor
implements AuthRestInterceptor {
    public void authorize(RestContext context, Map<String, Object> data) throws Exception {
        HttpServletRequest request = context.getRequest();
        try {
            EntityReference siteRef = Objects.requireNonNull((EntityReference)data.get(IBusIbecorpContextKeys.SITE.name()));
            SMSiteType siteType = (SMSiteType)data.get(IBusIbecorpContextKeys.SITE_TYPE.name());
            RestServiceProvider.Operation operation = (RestServiceProvider.Operation)data.get(IBusRestContextKeys.REST_OPERATION.name());
            Cookie[] cookies = request.getCookies();
            if (siteType == SMSiteType.B2B && !SelectPreferencesParameters.class.equals((Object)operation.getParamsClass())) {
                AuthUserPreferencesToken preferencesToken = AuthUserPreferencesToken.decode((String)B2BRestHelper.getCookieValue(cookies, "IBECORP_B2B_USER_PREFERENCES_TOKEN_COOKIE"));
                if (preferencesToken == null) {
                    throw Xeption.forDeveloper((String)"User preferences are empty", (Object[])new Object[0]);
                }
                if (preferencesToken.getPersonType() == null) {
                    throw Xeption.forDeveloper((String)"PersonType is empty", (Object[])new Object[0]);
                }
                if (preferencesToken.getOrganizationRef() == null) {
                    throw Xeption.forDeveloper((String)"User organization is empty", (Object[])new Object[0]);
                }
                data.put(IBusIbecorpContextKeys.CURRENT_ORGANIZATION.name(), preferencesToken.getOrganizationRef());
                data.put(IBusIbecorpContextKeys.SELECTED_SALES_POINT.name(), MiscUtil.guarded((Object)preferencesToken.getSalesPointRef(), CommonHelper.getSalesPoint((EntityReference<SMSite>)siteRef)));
                data.put(IBusIbecorpContextKeys.AUTHORIZED_USER_PERSON_TYPE.name(), preferencesToken.getPersonType());
            }
        }
        catch (Exception e) {
            context.setStatus(403);
            throw e;
        }
    }
}

