/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.server.ibecorp.b2b.rest;

import com.gridnine.xtrip.common.ibecorp.exception.NotEnoughFundsOnBalanceException;
import com.gridnine.xtrip.common.incidents.IncidentsHelper;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.midoffice.helper.SalesContextHandler;
import com.gridnine.xtrip.common.midoffice.model.SalesContext;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityIndex;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.BookingFileIndex;
import com.gridnine.xtrip.common.model.booking.Customer;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBooking;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedBookingHelper;
import com.gridnine.xtrip.common.model.booking.archive.ArchivedProductIndex;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.ExternalSystem;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.GeoLocationReference;
import com.gridnine.xtrip.common.model.dict.LocationType;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.entity.EntityStorageHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PlaceOfSales;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.rest.InformationMessage;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.search.SearchResult;
import com.gridnine.xtrip.common.util.Base64;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.GZIPUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.XSSerializable;
import com.gridnine.xtrip.common.util.XSerializable;
import com.gridnine.xtrip.common.xml.XSUtil;
import com.gridnine.xtrip.common.xml.XUtil;
import com.gridnine.xtrip.server.db.storage.LogicalStorage;
import com.gridnine.xtrip.server.ibecorp.b2b.rest.booking.initiatePayment.b2b.IbecorpPaymentHelper;
import com.gridnine.xtrip.server.ibecorp.common.CommonHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.CommonConverterHelper;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.ExternalSystemCode;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Money;
import com.gridnine.xtrip.server.ibecorp.common.rest.model.Price;
import com.gridnine.xtrip.server.ibus.IbusHelper;
import com.gridnine.xtrip.server.ibus.components.MessageContext;
import com.gridnine.xtrip.server.ibus.rest.IBusRestContextKeys;
import com.gridnine.xtrip.server.model.helpers.SysLogHelper;
import com.gridnine.xtrip.server.web.rest.JsonMarshaller;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class B2BRestHelper {
    private static final Logger log = LoggerFactory.getLogger(B2BRestHelper.class);

    public static String encodeToken(XSSerializable xobj) throws Exception {
        return Base64.encode((byte[])GZIPUtil.gzip((byte[])XSUtil.toString((XSSerializable)xobj).getBytes(StandardCharsets.UTF_8)));
    }

    public static <E extends BaseEntity> E decodeToken(Class<E> cls, String token) {
        try {
            BaseEntity result = (BaseEntity)cls.newInstance();
            XUtil.fromBytes((byte[])GZIPUtil.gunzip((byte[])Base64.decode((String)token)), (XSerializable)result);
            return (E)result;
        }
        catch (Exception ex) {
            throw Xeption.forDeveloper((String)"could not decode {0} token", (Object[])new Object[]{cls, ex});
        }
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName) {
        for (Cookie cookie : cookies) {
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static Collection<InformationMessage> getMessages(MessageContext ctx) {
        return (Collection)IbusHelper.getObjectN((MessageContext)ctx, (Enum)IBusRestContextKeys.REST_MESSAGES, ArrayList::new);
    }

    public static void addMessage(MessageContext ctx, InformationMessage message) {
        B2BRestHelper.getMessages(ctx).add(message);
    }

    public static <E extends BaseEntity> EntityContainer<E> findCtr(String uid, Class<E> type) {
        EntityContainer container = BookingFile.class.isAssignableFrom(type) ? B2BRestHelper.getBookingFileContainer(uid) : EntityStorage.get().resolve(B2BRestHelper.buildEntityReference(uid, type));
        return container;
    }

    public static <E extends BaseEntity> EntityContainer<E> findCtr(EntityReference<E> ref) {
        EntityContainer ctr = ref.getType() == BookingFile.class ? B2BRestHelper.getBookingFileContainer(ref.getUid()) : EntityStorage.get().resolve(ref);
        return ctr;
    }

    private static EntityContainer<BookingFile> getBookingFileContainer(String orderUid) {
        BookingFileIndex entityIndex = B2BRestHelper.getActualBookingFileIndex(orderUid);
        if (Objects.isNull(entityIndex)) {
            entityIndex = B2BRestHelper.getArchiveBookingFileIndex(orderUid);
        }
        return B2BRestHelper.getBookingFileContainer(entityIndex);
    }

    private static EntityContainer<BookingFile> getBookingFileContainer(EntityIndex<?> entityIndex) {
        if (Objects.isNull(entityIndex)) {
            return null;
        }
        EntityReference indexSource = entityIndex.getSource();
        if (Objects.isNull(indexSource)) {
            if (log.isDebugEnabled()) {
                log.debug("null source in " + entityIndex.getClass().getName() + " uid=" + entityIndex.getUid());
            }
            return null;
        }
        EntityContainer bookingFileCtr = BookingFile.class.isAssignableFrom(indexSource.getType()) ? EntityStorage.get().resolve(indexSource) : ArchivedBookingHelper.getBookingContainer((ArchivedBooking)((ArchivedBooking)EntityStorage.get().resolve(indexSource).getEntity()));
        String indexSourceStr = String.join((CharSequence)":", indexSource.getType().getName(), indexSource.getUid(), indexSource.getCaption());
        if (Objects.isNull(bookingFileCtr) && log.isDebugEnabled()) {
            log.debug("can't resolve reference " + indexSourceStr + " of index " + entityIndex.getClass().getName() + " uid=" + entityIndex.getUid());
        }
        return bookingFileCtr;
    }

    public static <T extends BaseEntity> EntityReference<T> buildEntityReference(String uid, Class<T> type) {
        if (BookingFile.class.isAssignableFrom(type) && NumberUtils.isDigits((String)uid)) {
            return B2BRestHelper.buildBookingFileReference(uid);
        }
        return new EntityReference(uid, type, null);
    }

    private static EntityReference<?> buildBookingFileReference(String uid) {
        BookingFileIndex bookingFileIndex = B2BRestHelper.getActualBookingFileIndex(uid);
        if (Objects.nonNull(bookingFileIndex)) {
            return bookingFileIndex.getSource();
        }
        ArchivedProductIndex archiveBookingFileIndex = B2BRestHelper.getArchiveBookingFileIndex(uid);
        if (archiveBookingFileIndex != null) {
            return archiveBookingFileIndex.getSource();
        }
        return null;
    }

    private static BookingFileIndex getActualBookingFileIndex(String uid) {
        SearchQuery searchQuery = new SearchQuery();
        if (NumberUtils.isDigits((String)uid)) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)BookingFileIndex.Property.fullNumber.name(), (Object)uid));
        } else {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)"containerUid", (Object)uid));
        }
        searchQuery.getPreferredProperties().add("uid");
        searchQuery.setLimit(1);
        SearchResult searchResult = EntityStorage.get().search(BookingFileIndex.class, searchQuery);
        if (EntityStorageHelper.isEmpty((SearchResult)searchResult)) {
            if (log.isDebugEnabled()) {
                log.debug("can't find bookingFileIndexes by query " + searchQuery);
            }
            return null;
        }
        return (BookingFileIndex)searchResult.unique();
    }

    private static ArchivedProductIndex getArchiveBookingFileIndex(String uid) {
        SearchQuery searchQuery = new SearchQuery();
        if (NumberUtils.isDigits((String)uid)) {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.bookingNumber.name(), (Object)uid));
        } else {
            searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)ArchivedProductIndex.Property.bookingContainerUid.name(), (Object)uid));
        }
        searchQuery.getPreferredProperties().add("uid");
        searchQuery.setLimit(1);
        SearchResult searchResult = EntityStorage.get().search(ArchivedProductIndex.class, searchQuery);
        if (EntityStorageHelper.isEmpty((SearchResult)searchResult)) {
            if (log.isDebugEnabled()) {
                log.debug("can't find archivedProductIndexes by query " + searchQuery);
            }
            return null;
        }
        return (ArchivedProductIndex)searchResult.unique();
    }

    public static void addObjToStackTrace(Throwable throwable, MessageContext ctx, String name, Object value) {
        JsonMarshaller jsonMarshaller = (JsonMarshaller)ctx.getMandatoryObject((Enum)IBusRestContextKeys.JSON_MARSHALLER);
        String valueText = jsonMarshaller.marshal(value);
        IncidentsHelper.addStackTraceElement((Throwable)throwable, (StackTraceElement[])new StackTraceElement[]{IncidentsHelper.getContextStackTraceElement((String)name, (String)valueText)});
    }

    public static EntityReference<Organization> getDefaultRetailClientProfileForAgency(EntityReference<Organization> orgRef) {
        EntityContainer currentOrg = EntityStorage.get().resolve(orgRef);
        if (((Organization)currentOrg.getEntity()).getTypes().contains(OrganizationType.AGENCY)) {
            EntityContainer orgCtr = ProfileHelper.getRetailProfileContainer();
            if (orgCtr != null) {
                return orgCtr.toReference();
            }
            throw Xeption.forAdmin((String)("Missing default retail profile for agency with UID." + orgRef.getUid()), (Object[])new Object[0]);
        }
        return null;
    }

    public static Map<EntityReference<Organization>, List<MiscUtil.Pair<PlaceOfSales, EntityReference<SalesPoint>>>> buildOrgSalesPlacesMap(Person person) {
        Date currentDate = new Date();
        HashMap<EntityReference<Organization>, List<MiscUtil.Pair<PlaceOfSales, EntityReference<SalesPoint>>>> result = new HashMap<EntityReference<Organization>, List<MiscUtil.Pair<PlaceOfSales, EntityReference<SalesPoint>>>>();
        person.getSalesPoints().stream().filter(Objects::nonNull).filter(pos -> pos.getOpened() == null || !MiscUtil.clearTime((Date)pos.getOpened()).after(currentDate)).filter(pos -> pos.getClosed() == null || !MiscUtil.setDayEndTime((Date)pos.getClosed()).before(currentDate)).filter(pos -> pos.getSalesPoint() != null).forEach(pos -> {
            EntityReference agency;
            EntityContainer spCtr = EntityStorage.get().resolve(pos.getSalesPoint());
            if (spCtr != null && (agency = ((SalesPoint)spCtr.getEntity()).getAgency()) != null) {
                List salesPlaces = (List)CollectionUtil.getFromMap((Map)result, (Object)agency, ArrayList::new);
                salesPlaces.add(MiscUtil.Pair.of((Object)pos, (Object)spCtr.toReference()));
            }
        });
        return result;
    }

    public static RailwayStation getMostRelevantRailwayStation(Set<RailwayStation> stations) {
        return stations.stream().filter(s -> Boolean.TRUE.equals(s.getMainCityStation())).findFirst().orElse(stations.size() == 1 ? (RailwayStation)stations.stream().findFirst().get() : null);
    }

    public static Set<RailwayStation> getRailwayStationsFromGeolocationCode(String locationCode) {
        return B2BRestHelper.getRailwayStationsFromGeolocationCode((DictionaryReference<GeoLocation>)new GeoLocationReference(locationCode));
    }

    public static Set<RailwayStation> getRailwayStationsFromGeolocationCode(DictionaryReference<GeoLocation> ref) {
        HashSet<RailwayStation> result = new HashSet<RailwayStation>();
        GeoLocation location = (GeoLocation)DictionaryCache.get().resolveReference(ref);
        if (location != null && location.getType() != LocationType.CITY) {
            location = (GeoLocation)DictionaryCache.get().resolveReference(location.getParent());
        }
        if (location != null) {
            result.addAll(DictionaryCache.get().search(RailwayStation.class, DictSearchCriterion.eq((String)RailwayStation.Property.geoLocation.name(), (Object)location.toReference())));
        }
        return result;
    }

    public static void checkBalance(EntityContainer<BookingFile> bookingCtr, Reservation reservation, BigDecimal price, PaymentType paymentType, String operation) {
        StringBuilder sb = new StringBuilder();
        sb.append("login: ").append(LogicalStorage.get().getUser()).append("\n");
        sb.append(operation).append(" price: ").append(price).append("\n");
        if (price == null) {
            sb.append(L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_BOOKING_PRICE", (Object[])new Object[0]));
            SysLogHelper.audit((EntityReference)bookingCtr.toReference(), (String)operation, (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)(operation + " disallowed"), (String)sb.toString(), (Object[])new Object[0])});
            throw Xeption.forDeveloper((String)L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_BOOKING_PRICE", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        SalesContext salesContext = SalesContextHandler.get().createSalesContext(reservation);
        EntityReference clientRef = salesContext.getClient();
        EntityReference subagencyRef = salesContext.getSubagency();
        EntityReference agencyRef = salesContext.getAgency();
        BigDecimal balance = IbecorpPaymentHelper.getBalance((EntityReference<Organization>)agencyRef, (EntityReference<Organization>)subagencyRef, (EntityReference<Organization>)clientRef);
        sb.append("agency: ").append(agencyRef).append("\n");
        sb.append("subagency: ").append(subagencyRef).append("\n");
        sb.append("clientRef: ").append(clientRef).append("\n");
        sb.append("balance: ");
        if (balance != null && BigDecimal.valueOf(Double.MAX_VALUE).compareTo(balance) == 0) {
            sb.append("unlimited");
        } else {
            sb.append(balance != null ? balance.toPlainString() : null);
        }
        sb.append("\n");
        if (balance == null) {
            sb.append(L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_ORGANIZATION_BALANCE", (Object[])new Object[0]));
            SysLogHelper.audit((EntityReference)bookingCtr.toReference(), (String)operation, (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)(operation + " disallowed"), (String)sb.toString(), (Object[])new Object[0])});
            throw Xeption.forDeveloper((String)L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_EMPTY_ORGANIZATION_BALANCE", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (price.compareTo(balance) > 0) {
            sb.append(L10nResourcesManager.getStr((String)"PAYMENT_PERMISSION_CHECK_NOT_ENOUGH_FUNDS_ON_BALANCE", (Object[])new Object[0]));
            SysLogHelper.audit((EntityReference)bookingCtr.toReference(), (String)operation, (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)(operation + " disallowed"), (String)sb.toString(), (Object[])new Object[0])});
            throw new NotEnoughFundsOnBalanceException();
        }
        sb.append("balance is sufficient");
        if (paymentType != null) {
            sb.append("\n\n").append("paymentType = ").append(paymentType);
        }
        SysLogHelper.audit((EntityReference)bookingCtr.toReference(), (String)operation, (Message[])new Message[]{MessagesHelper.createMessageWithDetails((MessageType)MessageType.MESSAGE, (String)(operation + " allowed"), (String)sb.toString(), (Object[])new Object[0])});
    }

    public static Customer createCustomer(Traveller customerTraveller, SalesContext salesContext) {
        Customer customer = new Customer();
        Passport customerPassport = customerTraveller.getPassport();
        if (customerPassport != null && customerPassport.getFirstName() != null && customerPassport.getLastName() != null) {
            customer.setName(customerPassport.getFirstName().concat(" ").concat(customerPassport.getLastName()));
            Passport passport = new Passport();
            passport.setFirstName(customerPassport.getFirstName());
            passport.setLastName(customerPassport.getLastName());
            customer.setPassport(passport);
        }
        CommonHelper.getEmail(customerTraveller.getCommunications()).map(c -> CommonConverterHelper.convertRest2EmailCommunication(CommonConverterHelper.convertEmailCommunication2Rest(c), Communication::new)).ifPresent(customer.getCommunications()::add);
        CommonHelper.getPhone(customerTraveller.getCommunications(), CommunicationType.MOBILE).map(c -> CommonConverterHelper.convertRest2PhoneCommunication(CommonConverterHelper.convertPhoneCommunication2Rest(c), CommunicationType.MOBILE, Communication::new)).ifPresent(customer.getCommunications()::add);
        customer.setPreferredLocale(LocaleHelper.getCurrentLocale());
        customer.setProfile(salesContext.getCustomer());
        return customer;
    }

    public static Money calcTotalMoney(Price ... prices) {
        if (prices.length == 0) {
            return null;
        }
        String currencyCode = null;
        BigDecimal totalPrice = BigDecimal.ZERO;
        for (Price price : prices) {
            if (price == null) continue;
            totalPrice = MiscUtil.sum((BigDecimal[])new BigDecimal[]{totalPrice, price.getTotal().getAmount()});
            if (currencyCode == null) {
                currencyCode = price.getTotal().getCurrencyCode();
                continue;
            }
            if (MiscUtil.equals((Object)currencyCode, (Object)price.getTotal().getCurrencyCode())) continue;
            throw Xeption.forDeveloper((String)"prices has different currencies", (Object[])new Object[0]);
        }
        return CommonConverterHelper.convertMoney2Rest(totalPrice, currencyCode);
    }

    public static Map<DictionaryReference<ExternalSystem>, String> convertExternalSystems(List<ExternalSystemCode> externalSystemCodes) {
        return externalSystemCodes == null ? Collections.emptyMap() : externalSystemCodes.stream().collect(Collectors.toMap(externalSystem -> ((ExternalSystem)DictionaryCache.get().findByCode(ExternalSystem.class, externalSystem.getUid())).toReference(), ExternalSystemCode::getCode));
    }
}

